/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UndoAction
extends JosmAction
implements OsmDataLayer.CommandQueueListener {
    public UndoAction() {
        super(I18n.tr("Undo", new Object[0]), "undo", I18n.tr("Undo the last action.", new Object[0]), Shortcut.registerShortcut("system:undo", I18n.tr("Edit: {0}", I18n.tr("Undo", new Object[0])), 90, 5006), true);
        this.setEnabled(false);
        this.putValue("help", HelpUtil.ht("/Action/Undo"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame == null) {
            return;
        }
        mapFrame.repaint();
        MainApplication.undoRedo.undo();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && !MainApplication.undoRedo.commands.isEmpty());
    }

    @Override
    public void commandChanged(int n, int n2) {
        if (MainApplication.undoRedo.commands.isEmpty()) {
            this.putValue("Name", I18n.tr("Undo", new Object[0]));
            this.setTooltip(I18n.tr("Undo the last action.", new Object[0]));
        } else {
            this.putValue("Name", I18n.tr("Undo ...", new Object[0]));
            this.setTooltip(I18n.tr("Undo {0}", MainApplication.undoRedo.commands.getLast().getDescriptionText()));
        }
    }
}

