/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class PostDownloadHandler
implements Runnable {
    private final DownloadTask task;
    private final Future<?> future;
    private Consumer<Collection<Object>> errorReporter;

    public PostDownloadHandler(DownloadTask downloadTask, Future<?> future) {
        this.task = downloadTask;
        this.future = future;
    }

    public PostDownloadHandler(DownloadTask downloadTask, Future<?> future, Consumer<Collection<Object>> consumer) {
        this(downloadTask, future);
        this.errorReporter = consumer;
    }

    @Override
    public void run() {
        try {
            this.future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
            Logging.error(exception);
            return;
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(this.task.getErrorObjects());
        if (this.errorReporter != null) {
            GuiHelper.runInEDT(() -> this.errorReporter.accept(linkedHashSet));
        }
        if (linkedHashSet.isEmpty()) {
            return;
        }
        if (linkedHashSet.size() == 1) {
            Object e = linkedHashSet.iterator().next();
            if (!GraphicsEnvironment.isHeadless()) {
                SwingUtilities.invokeLater(() -> {
                    if (e instanceof Exception) {
                        ExceptionDialogUtil.explainException((Exception)e);
                    } else if (I18n.tr("No data found in this area.", new Object[0]).equals(e)) {
                        new Notification(e.toString()).setIcon(2).show();
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, e.toString(), I18n.tr("Error during download", new Object[0]), 0);
                    }
                });
            }
            return;
        }
        if (!linkedHashSet.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : linkedHashSet) {
                if (e instanceof String) {
                    arrayList.add((String)e);
                    continue;
                }
                if (!(e instanceof Exception)) continue;
                arrayList.add(ExceptionUtil.explainException((Exception)e));
            }
            if (!GraphicsEnvironment.isHeadless()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Main.parent, "<html>" + Utils.joinAsHtmlUnorderedList(arrayList) + "</html>", I18n.tr("Errors during download", new Object[0]), 0));
            }
            return;
        }
    }
}

