/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class ImproveWayAccuracyAction
extends MapMode
implements SelectionChangedListener,
ModifierExListener {
    private static final String CROSSHAIR = "crosshair";
    private State state;
    private MapView mv;
    private static final long serialVersionUID = 42L;
    private transient Way targetWay;
    private transient Node candidateNode;
    private transient WaySegment candidateSegment;
    private Point mousePos;
    private boolean dragging;
    private final Cursor cursorSelect = ImageProvider.getCursor("normal", "mode");
    private final Cursor cursorSelectHover = ImageProvider.getCursor("hand", "mode");
    private final Cursor cursorImprove = ImageProvider.getCursor("crosshair", null);
    private final Cursor cursorImproveAdd = ImageProvider.getCursor("crosshair", "addnode");
    private final Cursor cursorImproveDelete = ImageProvider.getCursor("crosshair", "delete_node");
    private final Cursor cursorImproveAddLock = ImageProvider.getCursor("crosshair", "add_node_lock");
    private final Cursor cursorImproveLock = ImageProvider.getCursor("crosshair", "lock");
    private Color guideColor;
    private static final CachingProperty<BasicStroke> SELECT_TARGET_WAY_STROKE = new StrokeProperty("improvewayaccuracy.stroke.select-target", "2").cached();
    private static final CachingProperty<BasicStroke> MOVE_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.move-node", "1 6").cached();
    private static final CachingProperty<BasicStroke> MOVE_NODE_INTERSECTING_STROKE = new StrokeProperty("improvewayaccuracy.stroke.move-node-intersecting", "1 2 6").cached();
    private static final CachingProperty<BasicStroke> ADD_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.add-node", "1").cached();
    private static final CachingProperty<BasicStroke> DELETE_NODE_STROKE = new StrokeProperty("improvewayaccuracy.stroke.delete-node", "1").cached();
    private static final CachingProperty<Integer> DOT_SIZE = new IntegerProperty("improvewayaccuracy.dot-size", 6).cached();
    private boolean selectionChangedBlocked;
    protected String oldModeHelpText;
    private final transient AbstractMapViewPaintable temporaryLayer = new AbstractMapViewPaintable(){

        @Override
        public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
            ImproveWayAccuracyAction.this.paint(graphics2D, mapView, bounds);
        }
    };

    public ImproveWayAccuracyAction() {
        super(I18n.tr("Improve Way Accuracy", new Object[0]), "improvewayaccuracy", I18n.tr("Improve Way Accuracy mode", new Object[0]), Shortcut.registerShortcut("mapmode:ImproveWayAccuracy", I18n.tr("Mode: {0}", I18n.tr("Improve Way Accuracy", new Object[0])), 87, 5003), Cursor.getPredefinedCursor(0));
        this.readPreferences();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        MapFrame mapFrame = MainApplication.getMap();
        this.mv = mapFrame.mapView;
        this.mousePos = null;
        this.oldModeHelpText = "";
        if (this.getLayerManager().getEditDataSet() == null) {
            return;
        }
        this.updateStateByCurrentSelection();
        mapFrame.mapView.addMouseListener(this);
        mapFrame.mapView.addMouseMotionListener(this);
        mapFrame.mapView.addTemporaryLayer(this.temporaryLayer);
        DataSet.addSelectionListener(this);
        mapFrame.keyDetector.addModifierExListener(this);
    }

    @Override
    protected void readPreferences() {
        this.guideColor = new ColorProperty(I18n.marktr("improve way accuracy helper line"), Color.RED).get();
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.mapView.removeMouseListener(this);
        mapFrame.mapView.removeMouseMotionListener(this);
        mapFrame.mapView.removeTemporaryLayer(this.temporaryLayer);
        DataSet.removeSelectionListener(this);
        mapFrame.keyDetector.removeModifierExListener(this);
        this.temporaryLayer.invalidate();
    }

    @Override
    protected void updateStatusLine() {
        String string = this.getModeHelpText();
        if (!string.equals(this.oldModeHelpText)) {
            this.oldModeHelpText = string;
            MapFrame mapFrame = MainApplication.getMap();
            mapFrame.statusLine.setHelpText(string);
            mapFrame.statusLine.repaint();
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.state == State.SELECTING) {
            if (this.targetWay != null) {
                return I18n.tr("Click on the way to start improving its shape.", new Object[0]);
            }
            return I18n.tr("Select a way that you want to make more accurate.", new Object[0]);
        }
        if (this.ctrl) {
            return I18n.tr("Click to add a new node. Release Ctrl to move existing nodes or hold Alt to delete.", new Object[0]);
        }
        if (this.alt) {
            return I18n.tr("Click to delete the highlighted node. Release Alt to move existing nodes or hold Ctrl to add new nodes.", new Object[0]);
        }
        return I18n.tr("Click to move the highlighted node. Hold Ctrl to add new nodes, or Alt to delete.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mousePos == null) {
            return;
        }
        graphics2D.setColor(this.guideColor);
        if (this.state == State.SELECTING && this.targetWay != null) {
            BasicStroke basicStroke = SELECT_TARGET_WAY_STROKE.get();
            graphics2D.setStroke(basicStroke);
            List<Node> list = this.targetWay.getNodes();
            graphics2D.draw(new MapViewPath(mapView).append(list, false).computeClippedLine(basicStroke));
        } else if (this.state == State.IMPROVING) {
            List<Node> list;
            Node node = null;
            Node node2 = null;
            if (this.ctrl && this.candidateSegment != null) {
                graphics2D.setStroke(ADD_NODE_STROKE.get());
                node = this.candidateSegment.getFirstNode();
                node2 = this.candidateSegment.getSecondNode();
            } else if (!this.alt && !this.ctrl && this.candidateNode != null) {
                graphics2D.setStroke(MOVE_NODE_STROKE.get());
                list = this.targetWay.getNodePairs(false);
                for (Pair pair : list) {
                    if (pair.a == this.candidateNode) {
                        node = (Node)pair.b;
                    }
                    if (pair.b == this.candidateNode) {
                        node2 = (Node)pair.a;
                    }
                    if (node == null || node2 == null) continue;
                    break;
                }
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                graphics2D.setStroke(DELETE_NODE_STROKE.get());
                list = this.targetWay.getNodes();
                int n = list.indexOf(this.candidateNode);
                if (n != 0 && n != list.size() - 1) {
                    node = list.get(n - 1);
                    node2 = list.get(n + 1);
                } else if (this.targetWay.isClosed()) {
                    node = this.targetWay.getNode(1);
                    node2 = this.targetWay.getNode(list.size() - 2);
                }
            }
            list = new MapViewPath(mapView);
            if (this.alt && !this.ctrl) {
                if (node != null && node2 != null) {
                    ((MapViewPath)((Object)list)).moveTo(node);
                    ((MapViewPath)((Object)list)).lineTo(node2);
                }
            } else {
                if (node != null) {
                    ((Path2D.Double)((Object)list)).moveTo(this.mousePos.x, this.mousePos.y);
                    ((MapViewPath)((Object)list)).lineTo(node);
                }
                if (node2 != null) {
                    ((Path2D.Double)((Object)list)).moveTo(this.mousePos.x, this.mousePos.y);
                    ((MapViewPath)((Object)list)).lineTo(node2);
                }
            }
            graphics2D.draw(((MapViewPath)((Object)list)).computeClippedLine(graphics2D.getStroke()));
            if (this.candidateNode != null) {
                node = this.candidateNode;
                graphics2D.fill(new MapViewPath(mapView).shapeAround(node, SymbolShape.SQUARE, (double)DOT_SIZE.get().intValue()));
            }
            if (!this.alt && !this.ctrl && this.candidateNode != null) {
                ((Path2D)((Object)list)).reset();
                this.drawIntersectingWayHelperLines(mapView, (MapViewPath)((Object)list));
                graphics2D.setStroke(MOVE_NODE_INTERSECTING_STROKE.get());
                graphics2D.draw(((MapViewPath)((Object)list)).computeClippedLine(graphics2D.getStroke()));
            }
        }
    }

    protected void drawIntersectingWayHelperLines(MapView mapView, MapViewPath mapViewPath) {
        for (OsmPrimitive osmPrimitive : this.candidateNode.getReferrers()) {
            if (!(osmPrimitive instanceof Way) || this.targetWay.equals(osmPrimitive)) continue;
            List<Node> list = ((Way)osmPrimitive).getNodes();
            for (int i = 0; i < list.size(); ++i) {
                if (!this.candidateNode.equals(list.get(i))) continue;
                if (i > 0) {
                    mapViewPath.moveTo(this.mousePos.x, this.mousePos.y);
                    mapViewPath.lineTo(list.get(i - 1));
                }
                if (i >= list.size() - 1) continue;
                mapViewPath.moveTo(this.mousePos.x, this.mousePos.y);
                mapViewPath.lineTo(list.get(i + 1));
            }
        }
    }

    @Override
    public void modifiersExChanged(int n) {
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(n);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.selectionChangedBlocked) {
            return;
        }
        this.updateStateByCurrentSelection();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragging = true;
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        this.updateKeyModifiers(mouseEvent);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        if (!this.isEnabled() || mouseEvent.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        if (this.state == State.SELECTING) {
            if (this.targetWay != null) {
                this.getLayerManager().getEditDataSet().setSelected(this.targetWay.getPrimitiveId());
                this.updateStateByCurrentSelection();
            }
        } else if (this.state == State.IMPROVING) {
            if (this.mv.getLatLon(this.mousePos.x, this.mousePos.y).isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            if (this.ctrl && !this.alt && this.candidateSegment != null) {
                Object object;
                LinkedList<Command> linkedList = new LinkedList<Command>();
                Node node = new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y));
                linkedList.add(new AddCommand(node));
                List<Way> list = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                List<Way> list2 = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                LinkedList<WaySegment> linkedList2 = new LinkedList<WaySegment>();
                for (Way comparable : list) {
                    object = comparable.getNodePairs(true);
                    for (Way way : list2) {
                        if (!comparable.equals(way)) continue;
                        int n = -1;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            boolean bl;
                            Pair pair = (Pair)iterator.next();
                            ++n;
                            boolean bl2 = ((Node)pair.a).equals(this.candidateSegment.getFirstNode()) && ((Node)pair.b).equals(this.candidateSegment.getSecondNode());
                            boolean bl3 = bl = ((Node)pair.b).equals(this.candidateSegment.getFirstNode()) && ((Node)pair.a).equals(this.candidateSegment.getSecondNode());
                            if (!bl2 && !bl) continue;
                            linkedList2.add(new WaySegment(comparable, n));
                        }
                    }
                }
                for (WaySegment waySegment : linkedList2) {
                    object = waySegment.way;
                    Way way = new Way((Way)object);
                    way.addNode(waySegment.lowerIndex + 1, node);
                    linkedList.add(new ChangeCommand((OsmPrimitive)object, way));
                }
                String string = I18n.trn("Add a new node to way", "Add a new node to {0} ways", linkedList2.size(), linkedList2.size());
                MainApplication.undoRedo.add(new SequenceCommand(string, linkedList));
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                List<OsmPrimitive> list = this.candidateNode.getReferrers();
                List<Way> list3 = OsmPrimitive.getFilteredList(list, Way.class);
                if (list.size() != 1 || list3.size() != 1) {
                    Way way = new Way(this.targetWay);
                    List<Node> list4 = way.getNodes();
                    list4.remove(this.candidateNode);
                    way.setNodes(list4);
                    if (list4.size() < 2) {
                        Command command = DeleteCommand.delete(this.getLayerManager().getEditLayer(), Collections.singleton(this.targetWay), true);
                        if (command != null) {
                            MainApplication.undoRedo.add(command);
                        }
                    } else {
                        MainApplication.undoRedo.add(new ChangeCommand(this.targetWay, way));
                    }
                } else if (this.candidateNode.isTagged()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot delete node that has tags", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                } else {
                    Command command = DeleteCommand.delete(this.getLayerManager().getEditLayer(), Collections.singleton(this.candidateNode), true);
                    if (command != null) {
                        MainApplication.undoRedo.add(command);
                    }
                }
            } else if (this.candidateNode != null) {
                EastNorth eastNorth = this.candidateNode.getEastNorth();
                EastNorth eastNorth2 = this.mv.getEastNorth(this.mousePos.x, this.mousePos.y);
                MainApplication.undoRedo.add(new MoveCommand((OsmPrimitive)this.candidateNode, eastNorth2.east() - eastNorth.east(), eastNorth2.north() - eastNorth.north()));
            }
        }
        this.mousePos = null;
        this.updateCursor();
        this.updateStatusLine();
        this.temporaryLayer.invalidate();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragging) {
            this.mousePos = null;
        }
        this.temporaryLayer.invalidate();
    }

    private void updateCursor() {
        if (!this.isEnabled()) {
            this.mv.setNewCursor(null, (Object)this);
            return;
        }
        if (this.state == State.SELECTING) {
            this.mv.setNewCursor(this.targetWay == null ? this.cursorSelect : this.cursorSelectHover, (Object)this);
        } else if (this.state == State.IMPROVING) {
            if (this.alt && !this.ctrl) {
                this.mv.setNewCursor(this.cursorImproveDelete, (Object)this);
            } else if (this.shift || this.dragging) {
                if (this.ctrl) {
                    this.mv.setNewCursor(this.cursorImproveAddLock, (Object)this);
                } else {
                    this.mv.setNewCursor(this.cursorImproveLock, (Object)this);
                }
            } else if (this.ctrl && !this.alt) {
                this.mv.setNewCursor(this.cursorImproveAdd, (Object)this);
            } else {
                this.mv.setNewCursor(this.cursorImprove, (Object)this);
            }
        }
    }

    public void updateCursorDependentObjectsIfNeeded() {
        if (this.state == State.IMPROVING && (this.shift || this.dragging) && (this.candidateNode != null || this.candidateSegment != null)) {
            return;
        }
        if (this.mousePos == null) {
            this.candidateNode = null;
            this.candidateSegment = null;
            return;
        }
        if (this.state == State.SELECTING) {
            this.targetWay = ImproveWayAccuracyHelper.findWay(this.mv, this.mousePos);
        } else if (this.state == State.IMPROVING) {
            if (this.ctrl && !this.alt) {
                this.candidateSegment = ImproveWayAccuracyHelper.findCandidateSegment(this.mv, this.targetWay, this.mousePos);
                this.candidateNode = null;
            } else {
                this.candidateNode = ImproveWayAccuracyHelper.findCandidateNode(this.mv, this.targetWay, this.mousePos);
                this.candidateSegment = null;
            }
        }
    }

    public void startSelecting() {
        this.state = State.SELECTING;
        this.targetWay = null;
        this.temporaryLayer.invalidate();
        this.updateStatusLine();
    }

    public void startImproving(Way way) {
        this.state = State.IMPROVING;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        Collection<OsmPrimitive> collection = dataSet.getSelected();
        if (collection.size() != 1 || !collection.iterator().next().equals(way)) {
            this.selectionChangedBlocked = true;
            dataSet.clearSelection();
            dataSet.setSelected(way.getPrimitiveId());
            this.selectionChangedBlocked = false;
        }
        this.targetWay = way;
        this.candidateNode = null;
        this.candidateSegment = null;
        this.temporaryLayer.invalidate();
        this.updateStatusLine();
    }

    private void updateStateByCurrentSelection() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        Object object = collection.iterator();
        while (object.hasNext()) {
            OsmPrimitive osmPrimitive = object.next();
            if (osmPrimitive instanceof Way) {
                arrayList2.add((Way)osmPrimitive);
            }
            if (!(osmPrimitive instanceof Node)) continue;
            arrayList.add((Node)osmPrimitive);
        }
        if (arrayList2.size() == 1) {
            this.startImproving((Way)arrayList2.get(0));
            return;
        }
        if (arrayList.size() == 1 && (object = ((Node)arrayList.get(0)).getReferrers()).size() == 1 && object.get(0) instanceof Way) {
            this.startImproving((Way)object.get(0));
            return;
        }
        this.startSelecting();
    }

    static enum State {
        SELECTING,
        IMPROVING;

    }
}

