/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OffsetBookmark {
    private static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    @Preferences.pref
    private String projection_code;
    @Preferences.pref
    private String imagery_name;
    @Preferences.pref
    private String name;
    @Preferences.pref
    @Preferences.writeExplicitly
    private double dx;
    @Preferences.pref
    @Preferences.writeExplicitly
    private double dy;
    @Preferences.pref
    private double center_lon;
    @Preferences.pref
    private double center_lat;

    public boolean isUsable(ImageryLayer imageryLayer) {
        if (this.projection_code == null) {
            return false;
        }
        if (!Main.getProjection().toCode().equals(this.projection_code) && !this.hasCenter()) {
            return false;
        }
        return imageryLayer.getInfo().getName().equals(this.imagery_name);
    }

    public OffsetBookmark() {
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2) {
        this(string, string2, string3, d, d2, 0.0, 0.0);
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2, double d3, double d4) {
        this.projection_code = string;
        this.imagery_name = string2;
        this.name = string3;
        this.dx = d;
        this.dy = d2;
        this.center_lon = d3;
        this.center_lat = d4;
    }

    public OffsetBookmark(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        this.projection_code = (String)arrayList.get(0);
        this.imagery_name = (String)arrayList.get(1);
        this.name = (String)arrayList.get(2);
        this.dx = Double.parseDouble((String)arrayList.get(3));
        this.dy = Double.parseDouble((String)arrayList.get(4));
        if (arrayList.size() >= 7) {
            this.center_lon = Double.parseDouble((String)arrayList.get(5));
            this.center_lat = Double.parseDouble((String)arrayList.get(6));
        }
        if (this.projection_code == null) {
            Logging.error(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", this.projection_code, this.name));
        }
    }

    public String getProjectionCode() {
        return this.projection_code;
    }

    public String getName() {
        return this.name;
    }

    public String getImageryName() {
        return this.imagery_name;
    }

    public EastNorth getDisplacement() {
        return new EastNorth(this.dx, this.dy);
    }

    public EastNorth getDisplacement(Projection projection) {
        if (projection.toCode().equals(this.projection_code)) {
            return this.getDisplacement();
        }
        LatLon latLon = this.getCenter();
        Projection projection2 = Projections.getProjectionByCode(this.projection_code);
        EastNorth eastNorth = latLon.getEastNorth(projection2);
        EastNorth eastNorth2 = eastNorth.add(this.getDisplacement());
        LatLon latLon2 = projection2.eastNorth2latlon(eastNorth2);
        EastNorth eastNorth3 = latLon.getEastNorth(projection);
        EastNorth eastNorth4 = latLon2.getEastNorth(projection);
        return eastNorth4.subtract(eastNorth3);
    }

    public LatLon getCenter() {
        return new LatLon(this.center_lat, this.center_lon);
    }

    public boolean hasCenter() {
        return this.center_lat != 0.0 || this.center_lon != 0.0;
    }

    public void setProjectionCode(String string) {
        this.projection_code = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setImageryName(String string) {
        this.imagery_name = string;
    }

    public void setDisplacement(EastNorth eastNorth) {
        this.dx = eastNorth.east();
        this.dy = eastNorth.north();
    }

    public static void loadBookmarks() {
        List<OffsetBookmark> list = Main.pref.getListOfStructs("imagery.offsetbookmarks", null, OffsetBookmark.class);
        if (list == null) {
            OffsetBookmark.loadBookmarksOld();
            OffsetBookmark.saveBookmarks();
        } else {
            allBookmarks.addAll(list);
        }
    }

    private static void loadBookmarksOld() {
        for (Collection<String> collection : Main.pref.getArray("imagery.offsets", Collections.emptySet())) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        Main.pref.putListOfStructs("imagery.offsetbookmarks", allBookmarks, OffsetBookmark.class);
    }

    public static List<OffsetBookmark> getBookmarks() {
        return Collections.unmodifiableList(allBookmarks);
    }

    public static int getBookmarksSize() {
        return allBookmarks.size();
    }

    public static boolean addBookmark(OffsetBookmark offsetBookmark) {
        return allBookmarks.add(offsetBookmark);
    }

    public static boolean removeBookmark(OffsetBookmark offsetBookmark) {
        return allBookmarks.remove(offsetBookmark);
    }

    public static OffsetBookmark getBookmarkByIndex(int n) {
        return allBookmarks.get(n);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer imageryLayer, String string) {
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            if (!offsetBookmark.isUsable(imageryLayer) || !string.equals(offsetBookmark.name)) continue;
            return offsetBookmark;
        }
        return null;
    }

    public static void bookmarkOffset(String string, AbstractTileSourceLayer abstractTileSourceLayer) {
        LatLon latLon = MainApplication.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(MainApplication.getMap().mapView.getCenter()) : LatLon.ZERO;
        OffsetBookmark offsetBookmark = new OffsetBookmark(Main.getProjection().toCode(), abstractTileSourceLayer.getInfo().getName(), string, abstractTileSourceLayer.getDisplaySettings().getDx(), abstractTileSourceLayer.getDisplaySettings().getDy(), latLon.lon(), latLon.lat());
        ListIterator<OffsetBookmark> listIterator = allBookmarks.listIterator();
        while (listIterator.hasNext()) {
            OffsetBookmark offsetBookmark2 = listIterator.next();
            if (!offsetBookmark2.isUsable(abstractTileSourceLayer) || !string.equals(offsetBookmark2.name)) continue;
            listIterator.set(offsetBookmark);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(offsetBookmark);
        OffsetBookmark.saveBookmarks();
    }

    public Map<String, String> toPropertiesMap() {
        return Preferences.serializeStruct(this, OffsetBookmark.class);
    }

    public static OffsetBookmark fromPropertiesMap(Map<String, String> map) {
        return Preferences.deserializeStruct(map, OffsetBookmark.class);
    }
}

