/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.GetCapabilitiesParseHelper;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSDefaultLayer;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class WMTSTileSource
extends AbstractTMSTileSource
implements TemplatedTileSource {
    public static final String WMTS_NS_URL = "http://www.opengis.net/wmts/1.0";
    private static final QName QN_CONTENTS = new QName("http://www.opengis.net/wmts/1.0", "Contents");
    private static final QName QN_DEFAULT = new QName("http://www.opengis.net/wmts/1.0", "Default");
    private static final QName QN_DIMENSION = new QName("http://www.opengis.net/wmts/1.0", "Dimension");
    private static final QName QN_FORMAT = new QName("http://www.opengis.net/wmts/1.0", "Format");
    private static final QName QN_LAYER = new QName("http://www.opengis.net/wmts/1.0", "Layer");
    private static final QName QN_MATRIX_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "MatrixWidth");
    private static final QName QN_MATRIX_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "MatrixHeight");
    private static final QName QN_RESOURCE_URL = new QName("http://www.opengis.net/wmts/1.0", "ResourceURL");
    private static final QName QN_SCALE_DENOMINATOR = new QName("http://www.opengis.net/wmts/1.0", "ScaleDenominator");
    private static final QName QN_STYLE = new QName("http://www.opengis.net/wmts/1.0", "Style");
    private static final QName QN_TILEMATRIX = new QName("http://www.opengis.net/wmts/1.0", "TileMatrix");
    private static final QName QN_TILEMATRIXSET = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSet");
    private static final QName QN_TILEMATRIX_SET_LINK = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSetLink");
    private static final QName QN_TILE_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "TileWidth");
    private static final QName QN_TILE_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "TileHeight");
    private static final QName QN_TOPLEFT_CORNER = new QName("http://www.opengis.net/wmts/1.0", "TopLeftCorner");
    private static final QName QN_VALUE = new QName("http://www.opengis.net/wmts/1.0", "Value");
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String URL_GET_ENCODING_PARAMS = "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER={layer}&STYLE={style}&FORMAT={format}&tileMatrixSet={TileMatrixSet}&tileMatrix={TileMatrix}&tileRow={TileRow}&tileCol={TileCol}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}"};
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Collection<Layer> layers;
    private Layer currentLayer;
    private TileMatrixSet currentTileMatrixSet;
    private double crsScale;
    private GetCapabilitiesParseHelper.TransferMode transferMode;
    private NativeScaleLayer.ScaleList nativeScaleList;
    private final WMTSDefaultLayer defaultLayer;
    private Projection tileProjection;

    public WMTSTileSource(ImageryInfo imageryInfo) throws IOException {
        super(imageryInfo);
        CheckParameterUtil.ensureThat(imageryInfo.getDefaultLayers().size() < 2, "At most 1 default layer for WMTS is supported");
        this.baseUrl = GetCapabilitiesParseHelper.normalizeCapabilitiesUrl(this.handleTemplate(imageryInfo.getUrl()));
        this.layers = this.getCapabilities();
        if (imageryInfo.getDefaultLayers().isEmpty()) {
            Logging.warn(I18n.tr("No default layer selected, choosing first layer.", new Object[0]));
            if (!this.layers.isEmpty()) {
                Layer layer = this.layers.iterator().next();
                this.defaultLayer = new WMTSDefaultLayer(layer.identifier, layer.tileMatrixSet.identifier);
            } else {
                this.defaultLayer = null;
            }
        } else {
            DefaultLayer defaultLayer = imageryInfo.getDefaultLayers().iterator().next();
            this.defaultLayer = defaultLayer instanceof WMTSDefaultLayer ? (WMTSDefaultLayer)defaultLayer : null;
        }
        if (this.layers.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("No layers defined by getCapabilities document: {0}", imageryInfo.getUrl()));
        }
    }

    public DefaultLayer userSelectLayer() {
        Object object;
        Map<String, List<Layer>> map = this.layers.stream().collect(Collectors.groupingBy(layer -> ((Layer)layer).identifier));
        if (map.size() == 1 && (object = map.entrySet().iterator().next().getValue().stream().filter(layer -> ((Layer)layer).tileMatrixSet.crs.equals(Main.getProjection().toCode())).collect(Collectors.toList())).size() == 1) {
            Layer layer2 = (Layer)object.get(0);
            return new WMTSDefaultLayer(layer2.identifier, layer2.tileMatrixSet.identifier);
        }
        object = new SelectLayerDialog(this.layers);
        if (((ExtendedDialog)object).showDialog().getValue() == 1) {
            return ((SelectLayerDialog)object).getSelectedLayer();
        }
        return null;
    }

    private String handleTemplate(String string) {
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    private Collection<Layer> getCapabilities() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Collection<Layer> parseContents(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_CONTENTS.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                Object object;
                if (QN_LAYER.equals(xMLStreamReader.getName()) && (object = WMTSTileSource.parseLayer(xMLStreamReader)) != null) {
                    arrayList.add(object);
                }
                if (QN_TILEMATRIXSET.equals(xMLStreamReader.getName())) {
                    object = WMTSTileSource.parseTileMatrixSet(xMLStreamReader);
                    concurrentHashMap.put(((TileMatrixSet)object).identifier, object);
                }
            }
            n = xMLStreamReader.next();
        }
        ArrayList<Layer> arrayList2 = new ArrayList<Layer>();
        for (Layer layer : arrayList) {
            for (String string : layer.tileMatrixSetLinks) {
                Layer layer2 = new Layer(layer);
                layer2.tileMatrixSet = (TileMatrixSet)concurrentHashMap.get(string);
                arrayList2.add(layer2);
            }
        }
        return arrayList2;
    }

    private static Layer parseLayer(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Layer layer = new Layer();
        Stack<QName> stack = new Stack<QName>();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ImageIO.getReaderMIMETypes()));
        arrayList.add("image/jpgpng");
        arrayList.add("image/png8");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_LAYER.equals(xMLStreamReader.getName()))) {
            Object object;
            if (n == 1) {
                stack.push(xMLStreamReader.getName());
                if (stack.size() == 2) {
                    if (QN_FORMAT.equals(xMLStreamReader.getName())) {
                        object = xMLStreamReader.getElementText();
                        if (arrayList.contains(object)) {
                            layer.format = (String)object;
                        } else {
                            arrayList2.add(object);
                        }
                    } else if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                        layer.identifier = xMLStreamReader.getElementText();
                    } else if (GetCapabilitiesParseHelper.QN_OWS_TITLE.equals(xMLStreamReader.getName())) {
                        layer.title = xMLStreamReader.getElementText();
                    } else if (QN_RESOURCE_URL.equals(xMLStreamReader.getName()) && "tile".equals(xMLStreamReader.getAttributeValue("", "resourceType"))) {
                        layer.baseUrl = xMLStreamReader.getAttributeValue("", "template");
                    } else if (QN_STYLE.equals(xMLStreamReader.getName()) && "true".equals(xMLStreamReader.getAttributeValue("", "isDefault"))) {
                        if (GetCapabilitiesParseHelper.moveReaderToTag(xMLStreamReader, GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER)) {
                            layer.style = xMLStreamReader.getElementText();
                            stack.push(xMLStreamReader.getName());
                        }
                    } else if (QN_DIMENSION.equals(xMLStreamReader.getName())) {
                        layer.dimensions.add(WMTSTileSource.parseDimension(xMLStreamReader));
                    } else if (QN_TILEMATRIX_SET_LINK.equals(xMLStreamReader.getName())) {
                        layer.tileMatrixSetLinks.add(WMTSTileSource.parseTileMatrixSetLink(xMLStreamReader));
                    } else {
                        GetCapabilitiesParseHelper.moveReaderToEndCurrentTag(xMLStreamReader);
                    }
                }
            }
            if (xMLStreamReader.getEventType() == 2 && !((QName)(object = (QName)stack.pop())).equals(xMLStreamReader.getName())) {
                throw new IllegalStateException(I18n.tr("WMTS Parser error - start element {0} has different name than end element {2}", object, xMLStreamReader.getName()));
            }
            n = xMLStreamReader.next();
        }
        if (layer.style == null) {
            layer.style = "";
        }
        if (layer.format == null) {
            Logging.warn(I18n.tr("Can''t use layer {0} because no supported formats where found. Layer is available in formats: {1}", layer.getUserTitle(), String.join((CharSequence)", ", arrayList2)));
            return null;
        }
        return layer;
    }

    private static Dimension parseDimension(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Dimension dimension = new Dimension();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_DIMENSION.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                    dimension.identifier = xMLStreamReader.getElementText();
                } else if (QN_DEFAULT.equals(xMLStreamReader.getName())) {
                    dimension.defaultValue = xMLStreamReader.getElementText();
                } else if (QN_VALUE.equals(xMLStreamReader.getName())) {
                    dimension.values.add(xMLStreamReader.getElementText());
                }
            }
            n = xMLStreamReader.next();
        }
        return dimension;
    }

    private static String parseTileMatrixSetLink(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = null;
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIX_SET_LINK.equals(xMLStreamReader.getName()))) {
            if (n == 1 && QN_TILEMATRIXSET.equals(xMLStreamReader.getName())) {
                string = xMLStreamReader.getElementText();
            }
            n = xMLStreamReader.next();
        }
        return string;
    }

    private static TileMatrixSet parseTileMatrixSet(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        TileMatrixSetBuilder tileMatrixSetBuilder = new TileMatrixSetBuilder();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIXSET.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.identifier = xMLStreamReader.getElementText();
                }
                if (GetCapabilitiesParseHelper.QN_OWS_SUPPORTED_CRS.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.crs = GetCapabilitiesParseHelper.crsToCode(xMLStreamReader.getElementText());
                }
                if (QN_TILEMATRIX.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.tileMatrix.add(WMTSTileSource.parseTileMatrix(xMLStreamReader, tileMatrixSetBuilder.crs));
                }
            }
            n = xMLStreamReader.next();
        }
        return tileMatrixSetBuilder.build();
    }

    private static TileMatrix parseTileMatrix(XMLStreamReader xMLStreamReader, String string) throws XMLStreamException {
        Projection projection = Optional.ofNullable(Projections.getProjectionByCode(string)).orElseGet(Main::getProjection);
        TileMatrix tileMatrix = new TileMatrix();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIX.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                    tileMatrix.identifier = xMLStreamReader.getElementText();
                }
                if (QN_SCALE_DENOMINATOR.equals(xMLStreamReader.getName())) {
                    tileMatrix.scaleDenominator = Double.parseDouble(xMLStreamReader.getElementText());
                }
                if (QN_TOPLEFT_CORNER.equals(xMLStreamReader.getName())) {
                    String[] stringArray = xMLStreamReader.getElementText().split(" ");
                    if (projection.switchXY()) {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
                    } else {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                    }
                }
                if (QN_TILE_HEIGHT.equals(xMLStreamReader.getName())) {
                    tileMatrix.tileHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_TILE_WIDTH.equals(xMLStreamReader.getName())) {
                    tileMatrix.tileWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_MATRIX_HEIGHT.equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_MATRIX_WIDTH.equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
            }
            n = xMLStreamReader.next();
        }
        if (tileMatrix.tileHeight != tileMatrix.tileWidth) {
            throw new AssertionError((Object)I18n.tr("Only square tiles are supported. {0}x{1} returned by server for TileMatrix identifier {2}", tileMatrix.tileHeight, tileMatrix.tileWidth, tileMatrix.identifier));
        }
        return tileMatrix;
    }

    private void parseOperationMetadata(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !GetCapabilitiesParseHelper.QN_OWS_OPERATIONS_METADATA.equals(xMLStreamReader.getName()))) {
            if (n == 1 && GetCapabilitiesParseHelper.QN_OWS_OPERATION.equals(xMLStreamReader.getName()) && "GetTile".equals(xMLStreamReader.getAttributeValue("", "name")) && GetCapabilitiesParseHelper.moveReaderToTag(xMLStreamReader, GetCapabilitiesParseHelper.QN_OWS_DCP, GetCapabilitiesParseHelper.QN_OWS_HTTP, GetCapabilitiesParseHelper.QN_OWS_GET)) {
                this.baseUrl = xMLStreamReader.getAttributeValue("http://www.w3.org/1999/xlink", "href");
                this.transferMode = GetCapabilitiesParseHelper.getTransferMode(xMLStreamReader);
            }
            n = xMLStreamReader.next();
        }
    }

    public void initProjection(Projection projection) {
        if (projection.equals(this.tileProjection)) {
            return;
        }
        List list = this.layers.stream().filter(layer -> ((Layer)layer).identifier.equals(this.defaultLayer.layerName) && ((Layer)layer).tileMatrixSet.crs.equals(projection.toCode())).collect(Collectors.toList());
        if (list.size() > 1) {
            this.currentLayer = list.stream().filter(layer -> ((Layer)layer).tileMatrixSet.identifier.equals(this.defaultLayer.getTileMatrixSet())).findFirst().orElse((Layer)list.get(0));
            this.tileProjection = projection;
        } else if (list.size() == 1) {
            this.currentLayer = (Layer)list.get(0);
            this.tileProjection = projection;
        } else if (this.currentLayer == null) {
            this.tileProjection = null;
            for (Layer object : this.layers) {
                Object object2;
                if (!object.identifier.equals(this.defaultLayer.layerName) || (object2 = Projections.getProjectionByCode(object.tileMatrixSet.crs)) == null) continue;
                this.currentLayer = object;
                this.tileProjection = object2;
                break;
            }
            if (this.currentLayer == null) {
                return;
            }
        }
        if (this.currentLayer != null) {
            this.currentTileMatrixSet = this.currentLayer.tileMatrixSet;
            ArrayList arrayList = new ArrayList(this.currentTileMatrixSet.tileMatrix.size());
            for (Object object2 : this.currentTileMatrixSet.tileMatrix) {
                arrayList.add(((TileMatrix)object2).scaleDenominator * 2.8E-4);
            }
            this.nativeScaleList = new NativeScaleLayer.ScaleList(arrayList);
        }
        this.crsScale = (double)this.getTileSize() * 2.8E-4 / this.tileProjection.getMetersPerUnit();
    }

    private Collection<Layer> getLayers(WMTSDefaultLayer wMTSDefaultLayer, String string) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        if (this.layers != null) {
            for (Layer layer : this.layers) {
                if (wMTSDefaultLayer != null && !wMTSDefaultLayer.getLayerName().equals(layer.identifier) || string != null && !string.equals(layer.tileMatrixSet.crs)) continue;
                arrayList.add(layer);
            }
        }
        return arrayList;
    }

    @Override
    public int getTileSize() {
        Collection<Layer> collection = this.getLayers(null, this.tileProjection.toCode());
        if (!collection.isEmpty()) {
            return ((TileMatrix)collection.iterator().next().tileMatrixSet.tileMatrix.get(0)).tileHeight;
        }
        Logging.warn("WMTS: Could not determine tile size. Using default tile size of: {0}", this.getDefaultTileSize());
        return this.getDefaultTileSize();
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string;
        if (this.currentLayer == null) {
            return "";
        }
        if (this.currentLayer.baseUrl != null && this.transferMode == null) {
            string = this.currentLayer.baseUrl;
        } else {
            switch (this.transferMode) {
                case KVP: {
                    string = this.baseUrl + URL_GET_ENCODING_PARAMS;
                    break;
                }
                case REST: {
                    string = this.currentLayer.baseUrl;
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return "";
        }
        string = string.replaceAll("\\{layer\\}", this.currentLayer.identifier).replaceAll("\\{format\\}", this.currentLayer.format).replaceAll("\\{TileMatrixSet\\}", this.currentTileMatrixSet.identifier).replaceAll("\\{TileMatrix\\}", tileMatrix.identifier).replaceAll("\\{TileRow\\}", Integer.toString(n3)).replaceAll("\\{TileCol\\}", Integer.toString(n2)).replaceAll("(?i)\\{style\\}", this.currentLayer.style);
        for (Dimension dimension : this.currentLayer.dimensions) {
            string = string.replaceAll("\\{" + dimension.identifier + "\\}", dimension.defaultValue);
        }
        return string;
    }

    private TileMatrix getTileMatrix(int n) {
        if (n > this.getMaxZoom()) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return (TileMatrix)this.currentTileMatrixSet.tileMatrix.get(n);
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return CoordinateConversion.llToCoor(this.tileProjection.getWorldBoundsLatLon().getCenter());
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        return CoordinateConversion.llToCoor(this.tileProjection.eastNorth2latlon(eastNorth));
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileXY(0.0, 0.0);
        }
        EastNorth eastNorth = this.tileProjection.latlon2eastNorth(new LatLon(d, d2));
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        return new TileXY((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3, (tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.getTileXMax(n, this.tileProjection);
    }

    @Override
    public int getTileYMax(int n) {
        return this.getTileYMax(n, this.tileProjection);
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new Point(0, 0);
        }
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = this.tileProjection.latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3), (int)Math.round((tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public Coordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public Coordinate xyToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return new Coordinate(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        LatLon latLon = this.tileProjection.eastNorth2latlon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getMaxZoom() {
        if (this.currentTileMatrixSet != null) {
            return this.currentTileMatrixSet.tileMatrix.size() - 1;
        }
        return 0;
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    public Collection<String> getSupportedProjections() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.currentLayer == null) {
            for (Layer layer : this.layers) {
                linkedHashSet.add(layer.tileMatrixSet.crs);
            }
        } else {
            for (Layer layer : this.layers) {
                if (!this.currentLayer.identifier.equals(layer.identifier)) continue;
                linkedHashSet.add(layer.tileMatrixSet.crs);
            }
        }
        return linkedHashSet;
    }

    private int getTileYMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixHeight != -1) {
            return tileMatrix.matrixHeight;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.north() - eastNorth.north()) / d);
    }

    private int getTileXMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixWidth != -1) {
            return tileMatrix.matrixWidth;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.east() - eastNorth.east()) / d);
    }

    public NativeScaleLayer.ScaleList getNativeScales() {
        return this.nativeScaleList;
    }

    public Projection getTileProjection() {
        return this.tileProjection;
    }

    @Override
    public IProjected tileXYtoProjected(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return new Projected(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        return new Projected(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
    }

    @Override
    public TileXY projectedToTileXY(IProjected iProjected, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileXY(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        return new TileXY((iProjected.getEast() - tileMatrix.topLeftCorner.east()) / d, -(iProjected.getNorth() - tileMatrix.topLeftCorner.north()) / d);
    }

    private EastNorth tileToEastNorth(int n, int n2, int n3) {
        return CoordinateConversion.projToEn(this.tileXYtoProjected(n, n2, n3));
    }

    private ProjectionBounds getTileProjectionBounds(Tile tile) {
        ProjectionBounds projectionBounds = new ProjectionBounds(this.tileToEastNorth(tile.getXtile(), tile.getYtile(), tile.getZoom()));
        projectionBounds.extend(this.tileToEastNorth(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom()));
        return projectionBounds;
    }

    @Override
    public boolean isInside(Tile tile, Tile tile2) {
        ProjectionBounds projectionBounds = this.getTileProjectionBounds(tile);
        ProjectionBounds projectionBounds2 = this.getTileProjectionBounds(tile2);
        double d = 1.0E-7 * (projectionBounds2.maxEast - projectionBounds2.minEast);
        return projectionBounds2.minEast <= projectionBounds.minEast + d && projectionBounds2.minNorth <= projectionBounds.minNorth + d && projectionBounds2.maxEast >= projectionBounds.maxEast - d && projectionBounds2.maxNorth >= projectionBounds.maxNorth - d;
    }

    @Override
    public TileRange getCoveringTileRange(Tile tile, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileRange(new TileXY(0.0, 0.0), new TileXY(0.0, 0.0), n);
        }
        IProjected iProjected = this.tileXYtoProjected(tile.getXtile(), tile.getYtile(), tile.getZoom());
        IProjected iProjected2 = this.tileXYtoProjected(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        TileXY tileXY = this.projectedToTileXY(iProjected, n);
        TileXY tileXY2 = this.projectedToTileXY(iProjected2, n);
        double d = 1.0E-7 * (tileXY2.getX() - tileXY.getX());
        int n2 = (int)Math.floor(tileXY.getX() + d);
        int n3 = (int)Math.floor(tileXY.getY() + d);
        int n4 = (int)Math.ceil(tileXY2.getX() - d) - 1;
        int n5 = (int)Math.ceil(tileXY2.getY() - d) - 1;
        return new TileRange(new TileXY(n2, n3), new TileXY(n4, n5), n);
    }

    @Override
    public String getServerCRS() {
        return this.tileProjection.toCode();
    }

    private static final class SelectLayerDialog
    extends ExtendedDialog {
        private final transient List<Map.Entry<String, List<Layer>>> layers;
        private final JTable list;

        SelectLayerDialog(Collection<Layer> collection) {
            super(Main.parent, I18n.tr("Select WMTS layer", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.layers = SelectLayerDialog.groupLayersByNameAndTileMatrixSet(collection);
            this.list = new JTable(new AbstractTableModel(){

                @Override
                public Object getValueAt(int n, int n2) {
                    switch (n2) {
                        case 0: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(Layer::getUserTitle).collect(Collectors.joining(", "));
                        }
                        case 1: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(layer -> ((Layer)layer).tileMatrixSet.crs).collect(Collectors.joining(", "));
                        }
                        case 2: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(layer -> ((Layer)layer).tileMatrixSet.identifier).collect(Collectors.joining(", "));
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public int getRowCount() {
                    return layers.size();
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return I18n.tr("Layer name", new Object[0]);
                        }
                        case 1: {
                            return I18n.tr("Projection", new Object[0]);
                        }
                        case 2: {
                            return I18n.tr("Matrix set identifier", new Object[0]);
                        }
                    }
                    throw new IllegalArgumentException();
                }
            });
            this.list.setSelectionMode(0);
            this.list.setRowSelectionAllowed(true);
            this.list.setColumnSelectionAllowed(false);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JScrollPane(this.list), GBC.eol().fill());
            this.setContent(jPanel);
        }

        public DefaultLayer getSelectedLayer() {
            int n = this.list.getSelectedRow();
            if (n < 0) {
                return null;
            }
            Layer layer = this.layers.get(n).getValue().get(0);
            return new WMTSDefaultLayer(layer.identifier, layer.tileMatrixSet.identifier);
        }

        private static List<Map.Entry<String, List<Layer>>> groupLayersByNameAndTileMatrixSet(Collection<Layer> collection) {
            Map<String, List<Layer>> map = collection.stream().collect(Collectors.groupingBy(layer -> ((Layer)layer).identifier + '\u001c' + ((Layer)layer).tileMatrixSet.identifier));
            return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        }
    }

    private static class Layer {
        private String format;
        private String identifier;
        private String title;
        private TileMatrixSet tileMatrixSet;
        private String baseUrl;
        private String style;
        private final Collection<String> tileMatrixSetLinks = new ArrayList<String>();
        private final Collection<Dimension> dimensions = new ArrayList<Dimension>();

        Layer(Layer layer) {
            Objects.requireNonNull(layer);
            this.format = layer.format;
            this.identifier = layer.identifier;
            this.title = layer.title;
            this.baseUrl = layer.baseUrl;
            this.style = layer.style;
            this.tileMatrixSet = new TileMatrixSet(layer.tileMatrixSet);
            this.dimensions.addAll(layer.dimensions);
        }

        Layer() {
        }

        public String getUserTitle() {
            return this.title != null ? this.title : this.identifier;
        }
    }

    private static class Dimension {
        private String identifier;
        private String defaultValue;
        private final List<String> values = new ArrayList<String>();

        private Dimension() {
        }
    }

    private static class TileMatrixSet {
        private final List<TileMatrix> tileMatrix;
        private final String crs;
        private final String identifier;

        TileMatrixSet(TileMatrixSet tileMatrixSet) {
            if (tileMatrixSet != null) {
                this.tileMatrix = new ArrayList<TileMatrix>(tileMatrixSet.tileMatrix);
                this.crs = tileMatrixSet.crs;
                this.identifier = tileMatrixSet.identifier;
            } else {
                this.tileMatrix = Collections.emptyList();
                this.crs = null;
                this.identifier = null;
            }
        }

        TileMatrixSet(TileMatrixSetBuilder tileMatrixSetBuilder) {
            this.tileMatrix = new ArrayList<TileMatrix>(tileMatrixSetBuilder.tileMatrix);
            this.crs = tileMatrixSetBuilder.crs;
            this.identifier = tileMatrixSetBuilder.identifier;
        }
    }

    private static class TileMatrixSetBuilder {
        SortedSet<TileMatrix> tileMatrix = new TreeSet<TileMatrix>((tileMatrix, tileMatrix2) -> -1 * Double.compare(((TileMatrix)tileMatrix).scaleDenominator, ((TileMatrix)tileMatrix2).scaleDenominator));
        private String crs;
        private String identifier;

        private TileMatrixSetBuilder() {
        }

        TileMatrixSet build() {
            return new TileMatrixSet(this);
        }
    }

    private static class TileMatrix {
        private String identifier;
        private double scaleDenominator;
        private EastNorth topLeftCorner;
        private int tileWidth;
        private int tileHeight;
        private int matrixWidth = -1;
        private int matrixHeight = -1;

        private TileMatrix() {
        }
    }
}

