/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.FilterWorker;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class FilterModel {
    private int disabledCount;
    private int disabledAndHiddenCount;
    private boolean changed;
    private final List<Filter> filters = new LinkedList<Filter>();
    private final FilterMatcher filterMatcher = new FilterMatcher();

    private void updateFilterMatcher() {
        this.filterMatcher.reset();
        for (Filter filter : this.filters) {
            try {
                this.filterMatcher.add(filter);
            }
            catch (SearchParseError searchParseError) {
                Logging.error(searchParseError);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Error in filter <code>{0}</code>:<br>{1}", Utils.escapeReservedCharactersHTML(Utils.shortenString(filter.text, 80)), Utils.escapeReservedCharactersHTML(searchParseError.getMessage())), I18n.tr("Error in filter", new Object[0]), 0);
                filter.enable = false;
            }
        }
    }

    public void loadPrefs(String string) {
        List<Filter.FilterPreferenceEntry> list = Main.pref.getListOfStructs(string, null, Filter.FilterPreferenceEntry.class);
        if (list != null) {
            for (Filter.FilterPreferenceEntry filterPreferenceEntry : list) {
                this.filters.add(new Filter(filterPreferenceEntry));
            }
            this.updateFilterMatcher();
        }
    }

    public void savePrefs(String string) {
        ArrayList<Filter.FilterPreferenceEntry> arrayList = new ArrayList<Filter.FilterPreferenceEntry>();
        for (Filter filter : this.filters) {
            arrayList.add(filter.getPreferenceEntry());
        }
        Main.pref.putListOfStructs(string, arrayList, Filter.FilterPreferenceEntry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters() {
        DataSet dataSet = Main.main.getEditDataSet();
        this.changed = false;
        if (dataSet == null) {
            this.disabledAndHiddenCount = 0;
            this.disabledCount = 0;
            this.changed = true;
        } else {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            dataSet.beginUpdate();
            try {
                Collection<OsmPrimitive> collection = dataSet.allNonDeletedCompletePrimitives();
                this.changed = FilterWorker.executeFilters(collection, this.filterMatcher);
                this.disabledCount = 0;
                this.disabledAndHiddenCount = 0;
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!osmPrimitive.isDisabled()) continue;
                    ++this.disabledCount;
                    if (osmPrimitive.isSelected()) {
                        hashSet.add(osmPrimitive);
                    }
                    if (!osmPrimitive.isDisabledAndHidden()) continue;
                    ++this.disabledAndHiddenCount;
                }
                this.disabledCount -= this.disabledAndHiddenCount;
            }
            finally {
                dataSet.endUpdate();
            }
            if (!hashSet.isEmpty()) {
                dataSet.clearSelection(hashSet);
            }
        }
        if (this.changed) {
            FilterModel.updateMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters(Collection<? extends OsmPrimitive> collection) {
        DataSet dataSet = Main.main.getEditDataSet();
        if (dataSet == null) {
            return;
        }
        this.changed = false;
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        dataSet.beginUpdate();
        try {
            for (int i = 0; i < 2; ++i) {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (i == 0 && osmPrimitive instanceof Node || i == 1 && !(osmPrimitive instanceof Node)) continue;
                    if (osmPrimitive.isDisabled()) {
                        --this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        --this.disabledAndHiddenCount;
                    }
                    this.changed |= FilterWorker.executeFilters(osmPrimitive, this.filterMatcher);
                    if (osmPrimitive.isDisabled()) {
                        ++this.disabledCount;
                    }
                    if (osmPrimitive.isDisabledAndHidden()) {
                        ++this.disabledAndHiddenCount;
                    }
                    if (!osmPrimitive.isSelected() || !osmPrimitive.isDisabled()) continue;
                    arrayList.add(osmPrimitive);
                }
            }
        }
        finally {
            dataSet.endUpdate();
        }
        if (!arrayList.isEmpty()) {
            dataSet.clearSelection(arrayList);
        }
        if (this.changed) {
            FilterModel.updateMap();
        }
    }

    private static void updateMap() {
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.invalidate();
        }
    }

    public void clearFilterFlags() {
        DataSet dataSet = Main.main.getEditDataSet();
        if (dataSet != null) {
            FilterWorker.clearFilterFlags(dataSet.allPrimitives());
        }
        this.disabledCount = 0;
        this.disabledAndHiddenCount = 0;
    }

    public void clearFilters() {
        this.filters.clear();
        this.updateFilterMatcher();
    }

    public boolean addFilter(Filter filter) {
        this.filters.add(filter);
        this.updateFilterMatcher();
        return true;
    }

    public boolean moveDownFilter(int n) {
        if (n >= this.filters.size() - 1) {
            return false;
        }
        this.filters.add(n + 1, this.filters.remove(n));
        this.updateFilterMatcher();
        return true;
    }

    public boolean moveUpFilter(int n) {
        if (n == 0) {
            return false;
        }
        this.filters.add(n - 1, this.filters.remove(n));
        this.updateFilterMatcher();
        return true;
    }

    public Filter removeFilter(int n) {
        Filter filter = this.filters.remove(n);
        this.updateFilterMatcher();
        return filter;
    }

    public Filter setFilter(int n, Filter filter) {
        Filter filter2 = this.filters.set(n, filter);
        this.updateFilterMatcher();
        return filter2;
    }

    public Filter getFilter(int n) {
        return this.filters.get(n);
    }

    public void drawOSDText(Graphics2D graphics2D, OSDLabel oSDLabel, String string, String string2) {
        if (this.disabledCount == 0 && this.disabledAndHiddenCount == 0) {
            return;
        }
        String string3 = "<html>" + string;
        if (this.disabledAndHiddenCount != 0) {
            string3 = string3 + I18n.trn("<p><b>{0}</b> object hidden", "<p><b>{0}</b> objects hidden", this.disabledAndHiddenCount, this.disabledAndHiddenCount);
        }
        if (this.disabledAndHiddenCount != 0 && this.disabledCount != 0) {
            string3 = string3 + "<br>";
        }
        if (this.disabledCount != 0) {
            string3 = string3 + I18n.trn("<b>{0}</b> object disabled", "<b>{0}</b> objects disabled", this.disabledCount, this.disabledCount);
        }
        string3 = string3 + string2;
        oSDLabel.setText(string3);
        oSDLabel.setSize(oSDLabel.getPreferredSize());
        int n = MainApplication.getMap().mapView.getWidth() - oSDLabel.getPreferredSize().width - 15;
        int n2 = 15;
        graphics2D.translate(n, n2);
        oSDLabel.paintComponent(graphics2D);
        graphics2D.translate(-n, -n2);
    }

    public List<Filter> getFilters() {
        return new ArrayList<Filter>(this.filters);
    }

    public int getFiltersCount() {
        return this.filters.size();
    }

    public int getDisabledCount() {
        return this.disabledCount;
    }

    public int getDisabledAndHiddenCount() {
        return this.disabledAndHiddenCount;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public static Collection<OsmPrimitive> getAffectedPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        Stack<? extends OsmPrimitive> stack = new Stack<OsmPrimitive>();
        stack.addAll(collection);
        while (!stack.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)stack.pop();
            if (hashSet.contains(osmPrimitive)) continue;
            hashSet.add(osmPrimitive);
            if (osmPrimitive instanceof Way) {
                for (OsmPrimitive osmPrimitive2 : ((Way)osmPrimitive).getNodes()) {
                    stack.push(osmPrimitive2);
                }
            } else if (osmPrimitive instanceof Relation) {
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    stack.push(relationMember.getMember());
                }
            }
            for (OsmPrimitive osmPrimitive3 : osmPrimitive.getReferrers()) {
                stack.push(osmPrimitive3);
            }
        }
        return hashSet;
    }
}

