/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryDataSet
implements LayerManager.LayerChangeListener {
    private static HistoryDataSet historyDataSet;
    private final Map<PrimitiveId, ArrayList<HistoryOsmPrimitive>> data = new HashMap<PrimitiveId, ArrayList<HistoryOsmPrimitive>>();
    private final CopyOnWriteArrayList<HistoryDataSetListener> listeners = new CopyOnWriteArrayList();
    private final Map<Long, Changeset> changesets = new HashMap<Long, Changeset>();

    public static synchronized HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
            MainApplication.getLayerManager().addLayerChangeListener(historyDataSet);
        }
        return historyDataSet;
    }

    public void addHistoryDataSetListener(HistoryDataSetListener historyDataSetListener) {
        if (historyDataSetListener != null) {
            this.listeners.addIfAbsent(historyDataSetListener);
        }
    }

    public void removeHistoryDataSetListener(HistoryDataSetListener historyDataSetListener) {
        this.listeners.remove(historyDataSetListener);
    }

    protected void fireHistoryUpdated(PrimitiveId primitiveId) {
        for (HistoryDataSetListener historyDataSetListener : this.listeners) {
            historyDataSetListener.historyUpdated(this, primitiveId);
        }
    }

    protected void fireCacheCleared() {
        for (HistoryDataSetListener historyDataSetListener : this.listeners) {
            historyDataSetListener.historyDataSetCleared(this);
        }
    }

    public HistoryOsmPrimitive get(long l, OsmPrimitiveType osmPrimitiveType, long l2) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        if (l2 <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "version", l2));
        }
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(l, osmPrimitiveType);
        List list = this.data.get(simplePrimitiveId);
        if (list == null) {
            return null;
        }
        for (HistoryOsmPrimitive historyOsmPrimitive : list) {
            if (!historyOsmPrimitive.matches(l, l2)) continue;
            return historyOsmPrimitive;
        }
        return null;
    }

    public void put(HistoryOsmPrimitive historyOsmPrimitive) {
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(historyOsmPrimitive.getId(), historyOsmPrimitive.getType());
        if (this.data.get(simplePrimitiveId) == null) {
            this.data.put(simplePrimitiveId, new ArrayList());
        }
        this.data.get(simplePrimitiveId).add(historyOsmPrimitive);
        this.fireHistoryUpdated(simplePrimitiveId);
    }

    public void putChangeset(Changeset changeset) {
        this.changesets.put(Long.valueOf(changeset.getId()), changeset);
        this.fireHistoryUpdated(null);
    }

    public History getHistory(long l, OsmPrimitiveType osmPrimitiveType) {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(l, osmPrimitiveType);
        return this.getHistory(simplePrimitiveId);
    }

    public History getHistory(PrimitiveId primitiveId) {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, "pid");
        List list = this.data.get(primitiveId);
        if (list == null && primitiveId instanceof IPrimitive) {
            list = this.data.get(((IPrimitive)primitiveId).getPrimitiveId());
        }
        if (list == null) {
            return null;
        }
        for (HistoryOsmPrimitive historyOsmPrimitive : list) {
            historyOsmPrimitive.setChangeset(this.changesets.get(historyOsmPrimitive.getChangesetId()));
        }
        return new History(primitiveId.getUniqueId(), primitiveId.getType(), list);
    }

    public void mergeInto(HistoryDataSet historyDataSet) {
        if (historyDataSet == null) {
            return;
        }
        this.data.putAll(historyDataSet.data);
        this.changesets.putAll(historyDataSet.changesets);
        this.fireHistoryUpdated(null);
    }

    public Collection<Long> getChangesetIds() {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Collection collection : this.data.values()) {
            for (HistoryOsmPrimitive historyOsmPrimitive : collection) {
                hashSet.add(historyOsmPrimitive.getChangesetId());
            }
        }
        return hashSet;
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        if (MainApplication.getLayerManager().getLayers().isEmpty()) {
            this.data.clear();
            this.fireCacheCleared();
        }
    }
}

