/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.search;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class SearchSetting {
    public String text;
    public SearchMode mode;
    public boolean caseSensitive;
    public boolean regexSearch;
    public boolean mapCSSSearch;
    public boolean allElements;

    public SearchSetting() {
        this.text = "";
        this.mode = SearchMode.replace;
    }

    public SearchSetting(SearchSetting searchSetting) {
        this.text = searchSetting.text;
        this.mode = searchSetting.mode;
        this.caseSensitive = searchSetting.caseSensitive;
        this.regexSearch = searchSetting.regexSearch;
        this.mapCSSSearch = searchSetting.mapCSSSearch;
        this.allElements = searchSetting.allElements;
    }

    public String toString() {
        String string = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
        String string2 = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
        String string3 = this.mapCSSSearch ? ", " + I18n.trc("search", "CSS") : "";
        String string4 = this.allElements ? ", " + I18n.trc("search", "A") : "";
        return '\"' + this.text + "\" (" + string + string2 + string3 + string4 + ", " + (Object)((Object)this.mode) + ')';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SearchSetting searchSetting = (SearchSetting)object;
        return this.caseSensitive == searchSetting.caseSensitive && this.regexSearch == searchSetting.regexSearch && this.mapCSSSearch == searchSetting.mapCSSSearch && this.allElements == searchSetting.allElements && this.mode == searchSetting.mode && Objects.equals(this.text, searchSetting.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.mode, this.caseSensitive, this.regexSearch, this.mapCSSSearch, this.allElements});
    }

    public static SearchSetting readFromString(String string) {
        if (string.isEmpty()) {
            return null;
        }
        SearchSetting searchSetting = new SearchSetting();
        int n = 1;
        searchSetting.mode = SearchMode.fromCode(string.charAt(0));
        if (searchSetting.mode == null) {
            searchSetting.mode = SearchMode.replace;
            n = 0;
        }
        while (n < string.length()) {
            if (string.charAt(n) == 'C') {
                searchSetting.caseSensitive = true;
            } else if (string.charAt(n) == 'R') {
                searchSetting.regexSearch = true;
            } else if (string.charAt(n) == 'A') {
                searchSetting.allElements = true;
            } else if (string.charAt(n) == 'M') {
                searchSetting.mapCSSSearch = true;
            } else {
                if (string.charAt(n) == ' ') break;
                Logging.warn("Unknown char in SearchSettings: " + string);
                break;
            }
            ++n;
        }
        if (n < string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        searchSetting.text = string.substring(n);
        return searchSetting;
    }

    public String writeToString() {
        if (this.text == null || this.text.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mode.getCode());
        if (this.caseSensitive) {
            stringBuilder.append('C');
        }
        if (this.regexSearch) {
            stringBuilder.append('R');
        }
        if (this.mapCSSSearch) {
            stringBuilder.append('M');
        }
        if (this.allElements) {
            stringBuilder.append('A');
        }
        stringBuilder.append(' ').append(this.text);
        return stringBuilder.toString();
    }
}

