/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class ClipboardUtils {
    private static Clipboard clipboard;

    private ClipboardUtils() {
    }

    public static synchronized Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (HeadlessException headlessException) {
                Logging.warn("Headless. Using fake clipboard.", headlessException);
                clipboard = new Clipboard("fake");
            }
        }
        return clipboard;
    }

    public static Clipboard getSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return Toolkit.getDefaultToolkit().getSystemSelection();
    }

    public static String getClipboardStringContent() {
        try {
            Transferable transferable = ClipboardUtils.getClipboardContent();
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logging.error(exception);
        }
        return null;
    }

    public static synchronized Transferable getClipboardContent() {
        return ClipboardUtils.getClipboardContent(ClipboardUtils.getClipboard());
    }

    public static Transferable getClipboardContent(Clipboard clipboard) {
        Transferable transferable = null;
        for (int i = 0; transferable == null && i < 10; ++i) {
            try {
                transferable = clipboard.getContents(null);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.trace("Clipboard unavailable.", illegalStateException);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    Logging.log(Logging.LEVEL_WARN, "InterruptedException in " + Utils.class.getSimpleName() + " while getting clipboard content", interruptedException);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                Logging.error(nullPointerException);
            }
        }
        return transferable;
    }

    public static boolean copyString(String string) {
        return ClipboardUtils.copy(new StringSelection(string));
    }

    public static boolean copy(Transferable transferable) {
        return GuiHelper.runInEDTAndWaitAndReturn(() -> {
            try {
                ClipboardUtils.getClipboard().setContents(transferable, new DoNothingClipboardOwner());
                return Boolean.TRUE;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.error(illegalStateException);
                return Boolean.FALSE;
            }
        });
    }

    public static DataFlavor newDataFlavor(Class<?> clazz, String string) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + clazz.getName(), string, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    private static final class DoNothingClipboardOwner
    implements ClipboardOwner {
        private DoNothingClipboardOwner() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

