/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractTagPaster;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.TextTagParser;

public final class TextTagPaster
extends AbstractTagPaster {
    private static final String HELP = HelpUtil.ht("/Action/PasteTags");

    public TextTagPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean supports(TransferHandler.TransferSupport transferSupport) {
        try {
            return super.supports(transferSupport) && this.containsValidTags(transferSupport);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logging.warn(exception);
            return false;
        }
    }

    private boolean containsValidTags(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        return !this.getTagsImpl(transferSupport).isEmpty();
    }

    @Override
    protected Map<String, String> getTags(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        Map<String, String> map = this.getTagsImpl(transferSupport);
        if (map.isEmpty()) {
            TextTagPaster.showBadBufferMessage(HELP);
            throw new IOException("Invalid tags to paste.");
        }
        if (!TextTagParser.validateTags(map, TextTagPaster::warning)) {
            throw new IOException("Tags to paste are not valid.");
        }
        return map;
    }

    private Map<String, String> getTagsImpl(TransferHandler.TransferSupport transferSupport) throws UnsupportedFlavorException, IOException {
        return TextTagParser.readTagsFromText((String)transferSupport.getTransferable().getTransferData(this.df));
    }

    public static int warning(String string, String string2, String string3) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Do you want to paste these tags?", new Object[0]), I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Clear buffer", new Object[0]), I18n.tr("Ignore warnings", new Object[0]));
        extendedDialog.setButtonIcons("ok", "cancel", "dialogs/delete", "pastetags");
        extendedDialog.setContent("<html><b>" + string + "</b><br/><br/><div width=\"300px\">" + XmlWriter.encode(string2, true) + "</html>");
        extendedDialog.setDefaultButton(2);
        extendedDialog.setCancelButton(2);
        extendedDialog.setIcon(2);
        extendedDialog.toggleEnable(string3);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n == 0) {
            n = 2;
        }
        if (n == 3) {
            ClipboardUtils.copyString("");
        }
        return n;
    }

    public static void showBadBufferMessage(String string) {
        String string2 = I18n.tr("<html><p> Sorry, it is impossible to paste tags from buffer. It does not contain any JOSM object or suitable text. </p></html>", new Object[0]);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string2), GBC.eop());
        String string3 = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.DEFAULT));
        if (string3 != null) {
            jPanel.add((Component)new UrlLabel(string3), GBC.eop());
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), I18n.tr("Ok", new Object[0]), I18n.tr("Clear buffer", new Object[0])).setButtonIcons("ok", "dialogs/delete").setContent(jPanel).setDefaultButton(1).setCancelButton(1).setIcon(2).toggleEnable("tags.paste.cleanbadbuffer");
        extendedDialog.showDialog();
        if (extendedDialog.getValue() == 2) {
            ClipboardUtils.copyString("");
        }
    }
}

