/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private final TagEditorPanel pnlTagEditor = new TagEditorPanel(null, null, 255);
    private final transient ChangesetCommentModel changesetCommentModel;
    private final transient ChangesetCommentModel changesetSourceModel;

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetCommentModel2) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel2, "changesetSourceModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetSourceModel = changesetCommentModel2;
        this.changesetCommentModel.addChangeListener(new ChangesetCommentChangeListener("comment"));
        this.changesetSourceModel.addChangeListener(new ChangesetCommentChangeListener("source"));
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlTagEditor, "Center");
    }

    protected void setProperty(String string, String string2) {
        String string3;
        String string4 = (string2 == null ? "" : string2).trim();
        if (string4.equals(string3 = this.getTagEditorValue(string))) {
            return;
        }
        if (string4.isEmpty()) {
            this.pnlTagEditor.getModel().delete(string);
            return;
        }
        TagModel tagModel = this.pnlTagEditor.getModel().get(string);
        if (tagModel == null) {
            tagModel = new TagModel(string, string4);
            this.pnlTagEditor.getModel().add(tagModel);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tagModel, string4);
        }
    }

    protected String getTagEditorValue(String string) {
        TagModel tagModel = this.pnlTagEditor.getModel().get(string);
        return tagModel == null ? null : tagModel.getValue();
    }

    public void initFromTags(Map<String, String> map) {
        this.pnlTagEditor.getModel().initFromTags(map);
    }

    public Map<String, String> getTags(boolean bl) {
        this.forceCommentFieldReload();
        return this.pnlTagEditor.getModel().getTags(bl);
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(MainApplication.getLayerManager().getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.changesetCommentModel.setComment(this.getTagEditorValue("comment"));
        this.changesetSourceModel.setComment(this.getTagEditorValue("source"));
    }

    private void forceCommentFieldReload() {
        this.setProperty("comment", this.changesetCommentModel.getComment());
        this.setProperty("source", this.changesetSourceModel.getComment());
    }

    class ChangesetCommentChangeListener
    implements ChangeListener {
        private final String key;

        ChangesetCommentChangeListener(String string) {
            this.key = string;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof ChangesetCommentModel) {
                String string = ((ChangesetCommentModel)changeEvent.getSource()).getComment();
                String string2 = Optional.ofNullable(TagSettingsPanel.this.getTagEditorValue(this.key)).orElse("");
                if (!string2.equals(string)) {
                    TagSettingsPanel.this.setProperty(this.key, string);
                }
            }
        }
    }
}

