/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class GammaImageProcessor
implements ImageProcessor,
SessionAwareReadApply {
    private double gamma = 1.0;
    final short[] gammaChange = new short[256];
    private final LookupOp op3 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange}), null);
    private final LookupOp op4 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange, this.gammaChange}), null);

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
        for (int i = 0; i < 256; ++i) {
            this.gammaChange[i] = (short)(255.0 * Math.pow((double)i / 255.0, d));
        }
    }

    @Override
    public BufferedImage process(BufferedImage bufferedImage) {
        int n;
        if (this.gamma == 1.0) {
            return bufferedImage;
        }
        try {
            n = bufferedImage.getRaster().getNumBands();
            if (bufferedImage.getType() != 0 && n == 3) {
                return this.op3.filter(bufferedImage, null);
            }
            if (bufferedImage.getType() != 0 && n == 4) {
                return this.op4.filter(bufferedImage, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.trace(illegalArgumentException);
        }
        n = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        return this.process(bufferedImage2);
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> map) {
        String string = map.get("gamma");
        if (string != null) {
            try {
                this.setGamma(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.trace(numberFormatException);
            }
        }
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        if (Utils.equalsEpsilon(this.gamma, 1.0)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gamma", Double.toString(this.gamma));
    }

    public String toString() {
        return "GammaImageProcessor [gamma=" + this.gamma + ']';
    }
}

