/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.tools.ImageWarp;
import org.openstreetmap.josm.tools.Utils;

public class ReprojectionTile
extends Tile {
    protected TileAnchor anchor;
    private double nativeScale;
    protected boolean maxZoomReached;

    public ReprojectionTile(TileSource tileSource, int n, int n2, int n3) {
        super(tileSource, n, n2, n3);
    }

    public TileAnchor getAnchor() {
        return this.anchor;
    }

    public double getNativeScale() {
        return this.nativeScale;
    }

    public synchronized boolean needsUpdate(double d) {
        if (Utils.equalsEpsilon(this.nativeScale, d)) {
            return false;
        }
        return !this.maxZoomReached || d >= this.nativeScale;
    }

    @Override
    public void setImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            this.reset();
        } else {
            this.transform(bufferedImage);
        }
    }

    public synchronized void invalidate() {
        this.loaded = false;
        this.loading = false;
        this.error = false;
        this.error_message = null;
    }

    private synchronized void reset() {
        this.image = null;
        this.anchor = null;
        this.maxZoomReached = false;
    }

    private EastNorth tileToEastNorth(int n, int n2, int n3) {
        return CoordinateConversion.projToEn(this.source.tileXYtoProjected(n, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(BufferedImage bufferedImage) {
        ImageWarp.Interpolation interpolation;
        if (!MainApplication.isDisplayingMapView()) {
            this.reset();
            return;
        }
        double d = MainApplication.getMap().mapView.getScale();
        switch (Main.pref.get("imagery.warp.pixel-interpolation", "bilinear")) {
            case "nearest_neighbor": {
                interpolation = ImageWarp.Interpolation.NEAREST_NEIGHBOR;
                break;
            }
            default: {
                interpolation = ImageWarp.Interpolation.BILINEAR;
            }
        }
        Object object = Main.getProjection();
        Projection projection = Projections.getProjectionByCode(this.source.getServerCRS());
        EastNorth eastNorth = this.tileToEastNorth(this.xtile, this.ytile, this.zoom);
        EastNorth eastNorth2 = this.tileToEastNorth(this.xtile + 1, this.ytile + 1, this.zoom);
        ProjectionBounds projectionBounds = new ProjectionBounds(eastNorth);
        projectionBounds.extend(eastNorth2);
        ProjectionBounds projectionBounds2 = object.getEastNorthBoundsBox(projectionBounds, projection);
        double d2 = 2.0;
        Dimension dimension = ReprojectionTile.getDimension(ReprojectionTile.pbMarginAndAlign(projectionBounds2, d, d2), d);
        Integer n = this.limitScale(this.source.getTileSize(), Math.sqrt(dimension.getWidth() * dimension.getHeight()));
        double d3 = n == null ? d : d * (double)n.intValue();
        ProjectionBounds projectionBounds3 = ReprojectionTile.pbMarginAndAlign(projectionBounds2, d3, d2);
        ImageWarp.PointTransform pointTransform = arg_0 -> this.lambda$transform$0(projectionBounds3, d3, projection, (Projection)object, projectionBounds, arg_0);
        EastNorth eastNorth3 = object.latlon2eastNorth(projection.eastNorth2latlon(eastNorth));
        EastNorth eastNorth4 = object.latlon2eastNorth(projection.eastNorth2latlon(eastNorth2));
        Point2D.Double double_ = new Point2D.Double((eastNorth3.east() - projectionBounds3.minEast) / d3, (projectionBounds3.maxNorth - eastNorth3.north()) / d3);
        Point2D.Double double_2 = new Point2D.Double((eastNorth4.east() - projectionBounds3.minEast) / d3, (projectionBounds3.maxNorth - eastNorth4.north()) / d3);
        int n2 = Main.pref.getInteger("imagery.warp.projection-interpolation.stride", 7);
        ImageWarp.PointTransform pointTransform2 = n2 > 0 ? new ImageWarp.GridTransform(pointTransform, n2) : pointTransform;
        BufferedImage bufferedImage2 = ImageWarp.warp(bufferedImage, ReprojectionTile.getDimension(projectionBounds3, d3), pointTransform2, interpolation);
        ReprojectionTile reprojectionTile = this;
        synchronized (reprojectionTile) {
            this.image = bufferedImage2;
            this.anchor = new TileAnchor(double_, double_2);
            this.nativeScale = d3;
            this.maxZoomReached = n != null;
        }
    }

    private static ProjectionBounds pbMarginAndAlign(ProjectionBounds projectionBounds, double d, double d2) {
        double d3 = Math.floor(projectionBounds.minEast / d - d2) * d;
        double d4 = -Math.floor(-(projectionBounds.minNorth / d - d2)) * d;
        double d5 = Math.ceil(projectionBounds.maxEast / d + d2) * d;
        double d6 = -Math.ceil(-(projectionBounds.maxNorth / d + d2)) * d;
        return new ProjectionBounds(d3, d4, d5, d6);
    }

    private static Dimension getDimension(ProjectionBounds projectionBounds, double d) {
        return new Dimension((int)Math.round((projectionBounds.maxEast - projectionBounds.minEast) / d), (int)Math.round((projectionBounds.maxNorth - projectionBounds.minNorth) / d));
    }

    protected Integer limitScale(double d, double d2) {
        if (d2 > 3.0 * d) {
            int n = (int)Math.ceil((Math.log(d2) - Math.log(3.0 * d)) / Math.log(2.0));
            int n2 = 1 << n;
            double d3 = d2 / (double)n2;
            if (d3 > 3.0 * d) {
                throw new AssertionError();
            }
            if (d3 <= 3.0 * d / 2.0) {
                throw new AssertionError();
            }
            return n2;
        }
        if (d2 > 3.0 * d / 2.0) {
            return 1;
        }
        return null;
    }

    private /* synthetic */ Point2D lambda$transform$0(ProjectionBounds projectionBounds, double d, Projection projection, Projection projection2, ProjectionBounds projectionBounds2, Point2D point2D) {
        EastNorth eastNorth = new EastNorth(projectionBounds.minEast + point2D.getX() * d, projectionBounds.maxNorth - point2D.getY() * d);
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection2.eastNorth2latlon(eastNorth));
        double d2 = (double)this.source.getTileSize() * (eastNorth2.east() - projectionBounds2.minEast) / (projectionBounds2.maxEast - projectionBounds2.minEast);
        double d3 = (double)this.source.getTileSize() * (projectionBounds2.maxNorth - eastNorth2.north()) / (projectionBounds2.maxNorth - projectionBounds2.minNorth);
        return new Point2D.Double(d2, d3);
    }
}

