/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.ShiftedProjecting;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;

public class TileCoordinateConverter {
    private final MapView mapView;
    private final TileSourceDisplaySettings settings;
    private final TileSource tileSource;

    public TileCoordinateConverter(MapView mapView, TileSource tileSource, TileSourceDisplaySettings tileSourceDisplaySettings) {
        this.mapView = Objects.requireNonNull(mapView, "mapView");
        this.tileSource = Objects.requireNonNull(tileSource, "tileSource");
        this.settings = Objects.requireNonNull(tileSourceDisplaySettings, "settings");
    }

    private MapViewState.MapViewPoint pos(ICoordinate iCoordinate) {
        return this.mapView.getState().getPointFor(CoordinateConversion.coorToLL(iCoordinate)).add(this.settings.getDisplacement());
    }

    private MapViewState.MapViewPoint pos(IProjected iProjected) {
        return this.mapView.getState().getPointFor(CoordinateConversion.projToEn(iProjected)).add(this.settings.getDisplacement());
    }

    public IProjected shiftDisplayToServer(EastNorth eastNorth) {
        return CoordinateConversion.enToProj(eastNorth.subtract(this.settings.getDisplacement()));
    }

    public Projecting getProjecting() {
        return new ShiftedProjecting(this.mapView.getProjection(), this.settings.getDisplacement());
    }

    public Point2D getPixelForTile(int n, int n2, int n3) {
        ICoordinate iCoordinate = this.tileSource.tileXYToLatLon(n, n2, n3);
        return this.pos(iCoordinate).getInView();
    }

    public Point2D getPixelForTile(Tile tile) {
        return this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    public TileXY getTileforPixel(int n, int n2, int n3) {
        if (this.requiresReprojection()) {
            LatLon latLon = this.getProjecting().eastNorth2latlonClamped(this.mapView.getEastNorth(n, n2));
            return this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(latLon), n3);
        }
        IProjected iProjected = this.shiftDisplayToServer(this.mapView.getEastNorth(n, n2));
        return this.tileSource.projectedToTileXY(iProjected, n3);
    }

    public Rectangle2D getRectangleForTile(Tile tile) {
        ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
        ICoordinate iCoordinate2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return this.pos(iCoordinate).rectTo(this.pos(iCoordinate2)).getInView();
    }

    public Shape getTileShapeScreen(Tile tile) {
        if (this.requiresReprojection()) {
            Point2D point2D = this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
            Point2D point2D2 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile(), tile.getZoom());
            Point2D point2D3 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
            Point2D point2D4 = this.getPixelForTile(tile.getXtile(), tile.getYtile() + 1, tile.getZoom());
            return new Polygon(new int[]{(int)Math.round(point2D.getX()), (int)Math.round(point2D4.getX()), (int)Math.round(point2D3.getX()), (int)Math.round(point2D2.getX())}, new int[]{(int)Math.round(point2D.getY()), (int)Math.round(point2D4.getY()), (int)Math.round(point2D3.getY()), (int)Math.round(point2D2.getY())}, 4);
        }
        Point2D point2D = this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
        Point2D point2D5 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return new Rectangle((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()), (int)Math.round(point2D5.getX()) - (int)Math.round(point2D.getX()), (int)Math.round(point2D5.getY()) - (int)Math.round(point2D.getY()));
    }

    public double getScaleFactor(int n) {
        TileXY tileXY;
        TileXY tileXY2;
        Coordinate coordinate;
        Coordinate coordinate2;
        if (this.requiresReprojection()) {
            coordinate2 = this.mapView.getLatLon(0, 0);
            coordinate = this.mapView.getLatLon(this.mapView.getWidth(), this.mapView.getHeight());
            tileXY2 = this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(coordinate2), n);
            tileXY = this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(coordinate), n);
        } else {
            coordinate2 = this.mapView.getEastNorth(0, 0);
            coordinate = this.mapView.getEastNorth(this.mapView.getWidth(), this.mapView.getHeight());
            tileXY2 = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj((EastNorth)coordinate2), n);
            tileXY = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj((EastNorth)coordinate), n);
        }
        int n2 = this.mapView.getWidth() * this.mapView.getHeight();
        double d = Math.abs((tileXY.getY() - tileXY2.getY()) * (tileXY.getX() - tileXY2.getX()) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (n2 == 0 || d == 0.0) {
            return 1.0;
        }
        return (double)n2 / d;
    }

    public TileAnchor getScreenAnchorForTile(Tile tile) {
        if (this.requiresReprojection()) {
            ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
            ICoordinate iCoordinate2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
            return new TileAnchor(this.pos(iCoordinate).getInView(), this.pos(iCoordinate2).getInView());
        }
        IProjected iProjected = this.tileSource.tileXYtoProjected(tile.getXtile(), tile.getYtile(), tile.getZoom());
        IProjected iProjected2 = this.tileSource.tileXYtoProjected(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return new TileAnchor(this.pos(iProjected).getInView(), this.pos(iProjected2).getInView());
    }

    public boolean requiresReprojection() {
        return !this.tileSource.getServerCRS().equals(Main.getProjection().toCode());
    }
}

