/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.OnLineStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PartiallyInsideAreaStrategy;

public interface PositionForAreaStrategy {
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath var1, Rectangle2D var2);

    public boolean supportsGlyphVector();

    default public List<GlyphVector> generateGlyphVectors(MapViewPath mapViewPath, Rectangle2D rectangle2D, List<GlyphVector> list, boolean bl) {
        throw new UnsupportedOperationException("Single glyph transformation is not supported by this implementation");
    }

    public static PositionForAreaStrategy forKeyword(Keyword keyword) {
        return PositionForAreaStrategy.forKeyword(keyword, OnLineStrategy.INSTANCE);
    }

    public static PositionForAreaStrategy forKeyword(Keyword keyword, PositionForAreaStrategy positionForAreaStrategy) {
        if (keyword == null) {
            return positionForAreaStrategy;
        }
        switch (keyword.val) {
            case "center": {
                return PartiallyInsideAreaStrategy.INSTANCE;
            }
            case "inside": {
                return CompletelyInsideAreaStrategy.INSTANCE;
            }
            case "line": {
                return OnLineStrategy.INSTANCE;
            }
        }
        return positionForAreaStrategy;
    }

    public PositionForAreaStrategy withAddedOffset(Point2D var1);
}

