/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TaggingPresetMenu taggingPresetMenu = (TaggingPresetMenu)object;
        return Objects.equals(this.getRawName(), taggingPresetMenu.getRawName());
    }

    public int hashCode() {
        return Objects.hash(this.getRawName());
    }

    @Override
    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("Optional tooltip text", this.group != null ? I18n.tr("Preset group {1} / {0}", this.getLocaleName(), this.group.getName()) : I18n.tr("Preset group {0}", this.getLocaleName()));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    private static Component copyMenuComponent(Component component) {
        if (component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            JMenu jMenu2 = new JMenu(jMenu.getAction());
            for (Component component2 : jMenu.getMenuComponents()) {
                jMenu2.add(TaggingPresetMenu.copyMenuComponent(component2));
            }
            jMenu2.setText(jMenu.getText());
            return jMenu2;
        }
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getAction());
            jMenuItem2.setText(jMenuItem.getText());
            return jMenuItem2;
        }
        if (component instanceof JSeparator) {
            return new JSeparator();
        }
        return component;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.menu != null && object instanceof Component) {
            JPopupMenu jPopupMenu = new JPopupMenu(this.getName());
            for (Component component : this.menu.getMenuComponents()) {
                jPopupMenu.add(TaggingPresetMenu.copyMenuComponent(component));
            }
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo != null) {
                Point point = pointerInfo.getLocation();
                jPopupMenu.show(Main.parent, point.x - Main.parent.getX(), point.y - Main.parent.getY());
            }
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu jMenu) {
        Component[] componentArray = jMenu.getMenuComponents();
        PresetTextComparator presetTextComparator = new PresetTextComparator();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)component);
            }
            if (component instanceof JMenuItem) {
                arrayList.add((JMenuItem)component);
                if (i != componentArray.length - 1) continue;
                TaggingPresetMenu.handleMenuItem(jMenu, presetTextComparator, arrayList, n);
                arrayList = new ArrayList();
                n = 0;
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            TaggingPresetMenu.handleMenuItem(jMenu, presetTextComparator, arrayList, n);
            arrayList = new ArrayList();
            n = i;
        }
    }

    private static void handleMenuItem(JMenu jMenu, PresetTextComparator presetTextComparator, List<JMenuItem> list, int n) {
        list.sort(presetTextComparator);
        int n2 = 0;
        for (JMenuItem jMenuItem : list) {
            int n3 = n == 0 ? n2 : n2 + n + 1;
            jMenu.add((Component)jMenuItem, n3);
            ++n2;
        }
    }

    private static class PresetTextComparator
    implements Comparator<JMenuItem>,
    Serializable {
        private PresetTextComparator() {
        }

        @Override
        public int compare(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
            if (MainApplication.getMenu().presetSearchAction.equals(jMenuItem.getAction())) {
                return -1;
            }
            if (MainApplication.getMenu().presetSearchAction.equals(jMenuItem2.getAction())) {
                return 1;
            }
            return AlphanumComparator.getInstance().compare(jMenuItem.getText(), jMenuItem2.getText());
        }
    }
}

