/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;

public class JosmTextField
extends JTextField
implements FocusListener {
    private String hint;

    public JosmTextField(Document document, String string, int n) {
        this(document, string, n, true);
    }

    public JosmTextField(Document document, String string, int n, boolean bl) {
        super(document, string, n);
        TextContextualPopupMenu.enableMenuFor(this, bl);
        if (n > 0) {
            this.setMinimumSize(this.getPreferredSize());
        }
        this.addFocusListener(this);
        JosmPasswordField.workaroundJdkBug6322854(this);
    }

    public JosmTextField(String string, int n) {
        this(null, string, n);
    }

    public JosmTextField(String string) {
        this(null, string, 0);
    }

    public JosmTextField(int n) {
        this(null, null, n);
    }

    public JosmTextField() {
        this(null, null, 0);
    }

    public final String getHint() {
        return this.hint;
    }

    public final void setHint(String string) {
        this.hint = string;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.hint != null && !this.hint.isEmpty() && this.getText().isEmpty() && !this.isFocusOwner()) {
            int n = this.getHeight();
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            Insets insets = this.getInsets();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = this.getBackground().getRGB();
            int n3 = this.getForeground().getRGB();
            int n4 = -16843010;
            int n5 = ((n2 & n4) >>> 1) + ((n3 & n4) >>> 1);
            graphics.setColor(new Color(n5, true));
            graphics.drawString(this.hint, insets.left, n / 2 + fontMetrics.getAscent() / 2 - 2);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame != null) {
            mapFrame.keyDetector.setEnabled(false);
        }
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame != null) {
            mapFrame.keyDetector.setEnabled(true);
        }
        this.repaint();
    }
}

