/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader
implements GpxConstants {
    private String version;
    private GpxData gpxData;
    private final InputSource inputSource;

    public GpxReader(InputStream inputStream) throws IOException {
        UTFInputStreamReader uTFInputStreamReader = UTFInputStreamReader.create(inputStream);
        InvalidXmlCharacterFilter invalidXmlCharacterFilter = new InvalidXmlCharacterFilter(uTFInputStreamReader);
        this.inputSource = new InputSource(invalidXmlCharacterFilter);
    }

    public boolean parse(boolean bl) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            Utils.parseSafeSAX(this.inputSource, parser);
            return true;
        }
        catch (SAXException sAXException) {
            if (bl) {
                parser.tryToFinish();
                if (parser.data.isEmpty()) {
                    throw sAXException;
                }
                String string = sAXException.getMessage();
                if (sAXException instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)sAXException;
                    string = string + ' ' + I18n.tr("(at line {0}, column {1})", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                }
                Logging.warn(string);
                return false;
            }
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logging.error(parserConfigurationException);
            throw new SAXException(parserConfigurationException);
        }
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    private class Parser
    extends DefaultHandler {
        private GpxData data;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.INIT;
        private GpxLink currentLink;
        private Extensions currentExtensions;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuilder accumulator = new StringBuilder();
        private boolean nokiaSportsTrackerBug;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuilder();
            this.states = new Stack();
            this.data = new GpxData();
        }

        private double parseCoord(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes attributes) {
            return new LatLon(this.parseCoord(attributes.getValue("lat")), this.parseCoord(attributes.getValue("lon")));
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string2);
            block0 : switch (this.currentState) {
                case INIT: {
                    this.states.push(this.currentState);
                    this.currentState = State.GPX;
                    this.data.creator = attributes.getValue("creator");
                    GpxReader.this.version = attributes.getValue("version");
                    if (GpxReader.this.version != null && GpxReader.this.version.startsWith("1.0")) {
                        GpxReader.this.version = "1.0";
                        break;
                    }
                    if ("1.1".equals(GpxReader.this.version)) break;
                    GpxReader.this.version = "1.1";
                    break;
                }
                case GPX: {
                    switch (string2) {
                        case "metadata": {
                            this.states.push(this.currentState);
                            this.currentState = State.METADATA;
                            break;
                        }
                        case "wpt": {
                            this.states.push(this.currentState);
                            this.currentState = State.WPT;
                            this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                            break;
                        }
                        case "rte": {
                            this.states.push(this.currentState);
                            this.currentState = State.RTE;
                            this.currentRoute = new GpxRoute();
                            break;
                        }
                        case "trk": {
                            this.states.push(this.currentState);
                            this.currentState = State.TRK;
                            this.currentTrack = new ArrayList<Collection<WayPoint>>();
                            this.currentTrackAttr = new HashMap<String, Object>();
                            break;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break;
                        }
                        case "gpx": {
                            if (attributes.getValue("creator") == null || !attributes.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                            this.nokiaSportsTrackerBug = true;
                            break;
                        }
                    }
                    break;
                }
                case METADATA: {
                    switch (string2) {
                        case "author": {
                            this.states.push(this.currentState);
                            this.currentState = State.AUTHOR;
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                        case "copyright": {
                            this.states.push(this.currentState);
                            this.currentState = State.COPYRIGHT;
                            this.data.put("meta.copyright.author", attributes.getValue("author"));
                            break block0;
                        }
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(attributes.getValue("href"));
                            break block0;
                        }
                        case "bounds": {
                            this.data.put("meta.bounds", new Bounds(this.parseCoord(attributes.getValue("minlat")), this.parseCoord(attributes.getValue("minlon")), this.parseCoord(attributes.getValue("maxlat")), this.parseCoord(attributes.getValue("maxlon"))));
                            break block0;
                        }
                    }
                    break;
                }
                case AUTHOR: {
                    switch (string2) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(attributes.getValue("href"));
                            break block0;
                        }
                        case "email": {
                            this.data.put("meta.author.email", attributes.getValue("id") + '@' + attributes.getValue("domain"));
                            break block0;
                        }
                    }
                    break;
                }
                case TRK: {
                    switch (string2) {
                        case "trkseg": {
                            this.states.push(this.currentState);
                            this.currentState = State.TRKSEG;
                            this.currentTrackSeg = new ArrayList<WayPoint>();
                            break block0;
                        }
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(attributes.getValue("href"));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
                case TRKSEG: {
                    if (!"trkpt".equals(string2)) break;
                    this.states.push(this.currentState);
                    this.currentState = State.WPT;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                    break;
                }
                case WPT: {
                    switch (string2) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(attributes.getValue("href"));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
                case RTE: {
                    switch (string2) {
                        case "link": {
                            this.states.push(this.currentState);
                            this.currentState = State.LINK;
                            this.currentLink = new GpxLink(attributes.getValue("href"));
                            break block0;
                        }
                        case "rtept": {
                            this.states.push(this.currentState);
                            this.currentState = State.WPT;
                            this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                            break block0;
                        }
                        case "extensions": {
                            this.states.push(this.currentState);
                            this.currentState = State.EXT;
                            this.currentExtensions = new Extensions();
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '\u0001') continue;
                    cArray[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(cArray, n, n2);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case RTE: {
                    return this.currentRoute.attr;
                }
                case METADATA: {
                    return this.data.attr;
                }
                case WPT: {
                    return this.currentWayPoint.attr;
                }
                case TRK: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.elements.pop();
            block1 : switch (this.currentState) {
                case GPX: 
                case METADATA: {
                    switch (string2) {
                        case "name": {
                            this.data.put("meta.name", this.accumulator.toString());
                            break;
                        }
                        case "desc": {
                            this.data.put("meta.desc", this.accumulator.toString());
                            break;
                        }
                        case "time": {
                            this.data.put("meta.time", this.accumulator.toString());
                            break;
                        }
                        case "keywords": {
                            this.data.put("meta.keywords", this.accumulator.toString());
                            break;
                        }
                        case "author": {
                            if (!"1.0".equals(GpxReader.this.version)) break;
                            this.data.put("meta.author.name", this.accumulator.toString());
                            break;
                        }
                        case "email": {
                            if (!"1.0".equals(GpxReader.this.version)) break;
                            this.data.put("meta.author.email", this.accumulator.toString());
                            break;
                        }
                        case "url": 
                        case "urlname": {
                            this.data.put(string2, this.accumulator.toString());
                            break;
                        }
                        case "metadata": 
                        case "gpx": {
                            if ((this.currentState != State.METADATA || !"metadata".equals(string2)) && (this.currentState != State.GPX || !"gpx".equals(string2))) break;
                            this.convertUrlToLink(this.data.attr);
                            if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                                this.data.put("meta.extensions", this.currentExtensions);
                            }
                            this.currentState = this.states.pop();
                            break;
                        }
                        case "bounds": {
                            break;
                        }
                    }
                    break;
                }
                case AUTHOR: {
                    switch (string2) {
                        case "author": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "name": {
                            this.data.put("meta.author.name", this.accumulator.toString());
                            break block1;
                        }
                        case "email": {
                            break block1;
                        }
                        case "link": {
                            this.data.put("meta.author.link", this.currentLink);
                            break block1;
                        }
                    }
                    break;
                }
                case COPYRIGHT: {
                    switch (string2) {
                        case "copyright": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "year": {
                            this.data.put("meta.copyright.year", this.accumulator.toString());
                            break block1;
                        }
                        case "license": {
                            this.data.put("meta.copyright.license", this.accumulator.toString());
                            break block1;
                        }
                    }
                    break;
                }
                case LINK: {
                    switch (string2) {
                        case "text": {
                            this.currentLink.text = this.accumulator.toString();
                            break;
                        }
                        case "type": {
                            this.currentLink.type = this.accumulator.toString();
                            break;
                        }
                        case "link": {
                            if (this.currentLink.uri == null && this.accumulator != null && !this.accumulator.toString().isEmpty()) {
                                this.currentLink = new GpxLink(this.accumulator.toString());
                            }
                            this.currentState = this.states.pop();
                            break;
                        }
                    }
                    if (this.currentState == State.AUTHOR) {
                        this.data.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.LINK) break;
                    Map<String, Object> map = this.getAttr();
                    if (map != null && !map.containsKey("meta.links")) {
                        map.put("meta.links", new LinkedList());
                    }
                    if (map == null) break;
                    ((Collection)map.get("meta.links")).add(this.currentLink);
                    break;
                }
                case WPT: {
                    switch (string2) {
                        case "ele": 
                        case "magvar": 
                        case "name": 
                        case "src": 
                        case "geoidheight": 
                        case "type": 
                        case "sym": 
                        case "url": 
                        case "urlname": {
                            this.currentWayPoint.put(string2, this.accumulator.toString());
                            break block1;
                        }
                        case "hdop": 
                        case "vdop": 
                        case "pdop": {
                            try {
                                this.currentWayPoint.put(string2, Float.valueOf(this.accumulator.toString()));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.currentWayPoint.put(string2, Float.valueOf(0.0f));
                            }
                            break block1;
                        }
                        case "time": 
                        case "cmt": 
                        case "desc": {
                            this.currentWayPoint.put(string2, this.accumulator.toString());
                            this.currentWayPoint.setTime();
                            break block1;
                        }
                        case "rtept": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            this.currentRoute.routePoints.add(this.currentWayPoint);
                            break block1;
                        }
                        case "trkpt": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            this.currentTrackSeg.add(this.currentWayPoint);
                            break block1;
                        }
                        case "wpt": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentWayPoint.attr);
                            if (this.currentExtensions != null && !this.currentExtensions.isEmpty()) {
                                this.currentWayPoint.put("meta.extensions", this.currentExtensions);
                            }
                            this.data.waypoints.add(this.currentWayPoint);
                            break block1;
                        }
                    }
                    break;
                }
                case TRKSEG: {
                    if (!"trkseg".equals(string2)) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case TRK: {
                    switch (string2) {
                        case "trk": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentTrackAttr);
                            this.data.addTrack(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                            break block1;
                        }
                        case "name": 
                        case "cmt": 
                        case "desc": 
                        case "src": 
                        case "type": 
                        case "number": 
                        case "url": 
                        case "urlname": {
                            this.currentTrackAttr.put(string2, this.accumulator.toString());
                            break block1;
                        }
                    }
                    break;
                }
                case EXT: {
                    if ("extensions".equals(string2)) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!GpxConstants.JOSM_EXTENSIONS_NAMESPACE_URI.equals(string)) break;
                    this.currentExtensions.put(string2, this.accumulator.toString());
                    break;
                }
                default: {
                    switch (string2) {
                        case "wpt": {
                            this.currentState = this.states.pop();
                            break block1;
                        }
                        case "rte": {
                            this.currentState = this.states.pop();
                            this.convertUrlToLink(this.currentRoute.attr);
                            this.data.addRoute(this.currentRoute);
                            break block1;
                        }
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
            }
            Extensions extensions = (Extensions)this.data.get("meta.extensions");
            if (extensions != null && "true".equals(extensions.get("from-server"))) {
                this.data.fromServer = true;
            }
            GpxReader.this.gpxData = this.data;
        }

        private void convertUrlToLink(Map<String, Object> map) {
            String string = (String)map.get("url");
            String string2 = (String)map.get("urlname");
            if (string != null) {
                if (!map.containsKey("meta.links")) {
                    map.put("meta.links", new LinkedList());
                }
                GpxLink gpxLink = new GpxLink(string);
                gpxLink.text = string2;
                Collection collection = (Collection)map.get("meta.links");
                collection.add(gpxLink);
            }
        }

        void tryToFinish() throws SAXException {
            ArrayList<String> arrayList = new ArrayList<String>(this.elements);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)arrayList.get(i), (String)arrayList.get(i));
            }
            this.endDocument();
        }
    }

    private static enum State {
        INIT,
        GPX,
        METADATA,
        WPT,
        RTE,
        TRK,
        EXT,
        AUTHOR,
        LINK,
        TRKSEG,
        COPYRIGHT;

    }
}

