/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.openstreetmap.josm.Main;

public final class GuiSizesHelper {
    private static float screenDPI = -1.0f;

    private GuiSizesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float getScreenDPI() {
        if (screenDPI != -1.0f) return screenDPI;
        Class<GuiSizesHelper> clazz = GuiSizesHelper.class;
        synchronized (GuiSizesHelper.class) {
            if (screenDPI != -1.0f) return screenDPI;
            float f = (float)Main.pref.getDouble("gui.scale", 1.0);
            screenDPI = f != 0.0f ? 96.0f * f : (!GraphicsEnvironment.isHeadless() ? (float)Toolkit.getDefaultToolkit().getScreenResolution() : 96.0f);
            // ** MonitorExit[var0] (shouldn't be in output)
            return screenDPI;
        }
    }

    public static float getPixelDensity() {
        return GuiSizesHelper.getScreenDPI() / 96.0f;
    }

    public static boolean isHiDPI() {
        return GuiSizesHelper.getPixelDensity() >= 2.0f;
    }

    public static int getSizeDpiAdjusted(int n) {
        if (n <= 0) {
            return n;
        }
        return Math.round((float)n * GuiSizesHelper.getScreenDPI() / 96.0f);
    }

    public static float getSizeDpiAdjusted(float f) {
        if (f <= 0.0f) {
            return f;
        }
        return f * GuiSizesHelper.getScreenDPI() / 96.0f;
    }

    public static double getSizeDpiAdjusted(double d) {
        if (d <= 0.0) {
            return d;
        }
        return d * (double)GuiSizesHelper.getScreenDPI() / 96.0;
    }

    public static Dimension getDimensionDpiAdjusted(Dimension dimension) {
        float f = GuiSizesHelper.getScreenDPI();
        int n = dimension.width;
        int n2 = dimension.height;
        if (dimension.width > 0) {
            n = Math.round((float)dimension.width * f / 96.0f);
        }
        if (dimension.height > 0) {
            n2 = Math.round((float)dimension.height * f / 96.0f);
        }
        return new Dimension(n, n2);
    }
}

