/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MemoryManager {
    private static final long JOSM_CORE_FOOTPRINT = 0x3200000L;
    private static final MemoryManager INSTANCE = new MemoryManager();
    private final ArrayList<MemoryHandle<?>> activeHandles = new ArrayList();

    protected MemoryManager() {
    }

    public synchronized <T> MemoryHandle<T> allocateMemory(String string, long l, Supplier<T> supplier) throws NotEnoughMemoryException {
        if (this.isAvailable(l)) {
            T t = supplier.get();
            if (t == null) {
                throw new IllegalArgumentException("Factory did not return a content element.");
            }
            Logging.info(MessageFormat.format("Allocate for {0}: {1} MB of memory. Available: {2} MB.", string, l / 1024L / 1024L, this.getAvailableMemory() / 1024L / 1024L));
            ManualFreeMemoryHandle<T> manualFreeMemoryHandle = new ManualFreeMemoryHandle<T>(string, t, l);
            this.activeHandles.add(manualFreeMemoryHandle);
            return manualFreeMemoryHandle;
        }
        throw new NotEnoughMemoryException(l);
    }

    public synchronized boolean isAvailable(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot allocate negative number of bytes: {0}", l));
        }
        return this.getAvailableMemory() >= l;
    }

    public synchronized long getMaxMemory() {
        return Runtime.getRuntime().maxMemory() - 0x3200000L;
    }

    public synchronized long getAvailableMemory() {
        return this.getMaxMemory() - this.activeHandles.stream().mapToLong(MemoryHandle::getSize).sum();
    }

    public static MemoryManager getInstance() {
        return INSTANCE;
    }

    protected synchronized List<MemoryHandle<?>> resetState() {
        ArrayList arrayList = new ArrayList(this.activeHandles);
        arrayList.forEach((Consumer<MemoryHandle<?>>)((Consumer<MemoryHandle>)MemoryHandle::free));
        return arrayList;
    }

    public static class NotEnoughMemoryException
    extends Exception {
        NotEnoughMemoryException(long l) {
            super(I18n.tr("To add another layer you need to allocate at least {0,number,#}MB memory to JOSM using -Xmx{0,number,#}M option (see http://forum.openstreetmap.org/viewtopic.php?id=25677).\nCurrently you have {1,number,#}MB memory allocated for JOSM", l / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        }
    }

    private class ManualFreeMemoryHandle<T>
    implements MemoryHandle<T> {
        private final String name;
        private T content;
        private final long size;

        ManualFreeMemoryHandle(String string, T t, long l) {
            this.name = string;
            this.content = t;
            this.size = l;
        }

        @Override
        public T get() {
            if (this.content == null) {
                throw new IllegalStateException(MessageFormat.format("Memory area was accessed after free(): {0}", this.name));
            }
            return this.content;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            if (this.content == null) {
                throw new IllegalStateException(MessageFormat.format("Memory area was already marked as freed: {0}", this.name));
            }
            this.content = null;
            MemoryManager memoryManager = MemoryManager.this;
            synchronized (memoryManager) {
                MemoryManager.this.activeHandles.remove(this);
            }
        }

        public String toString() {
            return "MemoryHandle [name=" + this.name + ", size=" + this.size + ']';
        }
    }

    public static interface MemoryHandle<T> {
        public T get();

        public long getSize();

        public void free();
    }
}

