/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.date;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;

public final class DateUtils {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final BooleanProperty PROP_ISO_DATES = new BooleanProperty("iso.dates", false);
    private static final DatatypeFactory XML_DATE;

    private DateUtils() {
    }

    public static synchronized Date fromString(String string) {
        return new Date(DateUtils.tsFromString(string));
    }

    public static synchronized long tsFromString(String string) {
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx") || DateUtils.checkLayout(string, "xxxx:xx:xx xx:xx:xx") || DateUtils.checkLayout(string, "xxxx-xx-xx xx:xx:xxZ") || DateUtils.checkLayout(string, "xxxx-xx-xx xx:xx:xx UTC") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx+xx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx-xx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            ZonedDateTime zonedDateTime = ZonedDateTime.of(DateUtils.parsePart4(string, 0), DateUtils.parsePart2(string, 5), DateUtils.parsePart2(string, 8), DateUtils.parsePart2(string, 11), DateUtils.parsePart2(string, 14), DateUtils.parsePart2(string, 17), 0, DateUtils.checkLayout(string, "xxxx:xx:xx xx:xx:xx") ? ZoneId.systemDefault() : ZoneOffset.UTC);
            if (string.length() == 22 || string.length() == 25) {
                int n = DateUtils.parsePart2(string, 20);
                long l = string.charAt(19) == '+' ? -1L : 1L;
                return zonedDateTime.plusHours((long)n * l).toInstant().toEpochMilli();
            }
            return zonedDateTime.toInstant().toEpochMilli();
        }
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx") || DateUtils.checkLayout(string, "xxxx:xx:xx xx:xx:xx.xxx") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx.xxx-xx:00")) {
            ZonedDateTime zonedDateTime = ZonedDateTime.of(DateUtils.parsePart4(string, 0), DateUtils.parsePart2(string, 5), DateUtils.parsePart2(string, 8), DateUtils.parsePart2(string, 11), DateUtils.parsePart2(string, 14), DateUtils.parsePart2(string, 17), DateUtils.parsePart3(string, 20) * 1000000, DateUtils.checkLayout(string, "xxxx:xx:xx xx:xx:xx.xxx") ? ZoneId.systemDefault() : ZoneOffset.UTC);
            if (string.length() == 29) {
                int n = DateUtils.parsePart2(string, 24);
                long l = string.charAt(23) == '+' ? -1L : 1L;
                return zonedDateTime.plusHours((long)n * l).toInstant().toEpochMilli();
            }
            return zonedDateTime.toInstant().toEpochMilli();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date date = simpleDateFormat.parse(string, new ParsePosition(0));
        if (date != null) {
            return date.getTime();
        }
        try {
            return XML_DATE.newXMLGregorianCalendar(string).toGregorianCalendar().getTimeInMillis();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UncheckedParseException("The date string (" + string + ") could not be parsed.", illegalArgumentException);
        }
    }

    public static synchronized String fromTimestamp(int n) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(TimeUnit.SECONDS.toMillis(n)).atZone(ZoneOffset.UTC);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }

    public static synchronized String fromDate(Date date) {
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneOffset.UTC);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }

    public static Date cloneDate(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static boolean checkLayout(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            char c2 = string.charAt(i);
            if (c == 'x' && Character.isDigit(c2) || c != 'x' && c == c2) continue;
            return false;
        }
        return true;
    }

    private static int num(char c) {
        return c - 48;
    }

    private static int parsePart2(String string, int n) {
        return 10 * DateUtils.num(string.charAt(n)) + DateUtils.num(string.charAt(n + 1));
    }

    private static int parsePart3(String string, int n) {
        return 100 * DateUtils.num(string.charAt(n)) + 10 * DateUtils.num(string.charAt(n + 1)) + DateUtils.num(string.charAt(n + 2));
    }

    private static int parsePart4(String string, int n) {
        return 1000 * DateUtils.num(string.charAt(n)) + 100 * DateUtils.num(string.charAt(n + 1)) + 10 * DateUtils.num(string.charAt(n + 2)) + DateUtils.num(string.charAt(n + 3));
    }

    public static SimpleDateFormat newIsoDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static SimpleDateFormat newIsoDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    }

    public static SimpleDateFormat newOsmApiDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
    }

    public static DateFormat getDateFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return DateUtils.newIsoDateFormat();
        }
        return DateFormat.getDateInstance(n, Locale.getDefault());
    }

    public static String formatDate(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "date");
        return DateUtils.getDateFormat(n).format(date);
    }

    public static DateFormat getTimeFormat(int n) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("HH:mm:ss");
        }
        return DateFormat.getTimeInstance(n, Locale.getDefault());
    }

    public static String formatTime(Date date, int n) {
        CheckParameterUtil.ensureParameterNotNull(date, "time");
        return DateUtils.getTimeFormat(n).format(date);
    }

    public static DateFormat getDateTimeFormat(int n, int n2) {
        if (PROP_ISO_DATES.get().booleanValue()) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return DateFormat.getDateTimeInstance(n, n2, Locale.getDefault());
    }

    public static String formatDateTime(Date date, int n, int n2) {
        CheckParameterUtil.ensureParameterNotNull(date, "datetime");
        return DateUtils.getDateTimeFormat(n, n2).format(date);
    }

    static {
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Logging.error(datatypeConfigurationException);
        }
        XML_DATE = datatypeFactory;
    }
}

