/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.CompoundTemplateEntry;
import org.openstreetmap.josm.tools.template_engine.Condition;
import org.openstreetmap.josm.tools.template_engine.ContextSwitchTemplate;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.SearchExpressionCondition;
import org.openstreetmap.josm.tools.template_engine.StaticText;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.Tokenizer;
import org.openstreetmap.josm.tools.template_engine.Variable;

public class TemplateParser {
    private final Tokenizer tokenizer;
    private static final Collection<Tokenizer.TokenType> EXPRESSION_END_TOKENS = Arrays.asList(Tokenizer.TokenType.EOF);
    private static final Collection<Tokenizer.TokenType> CONDITION_WITH_APOSTROPHES_END_TOKENS = Arrays.asList(Tokenizer.TokenType.APOSTROPHE);

    public TemplateParser(String string) {
        this.tokenizer = new Tokenizer(string);
    }

    private Tokenizer.Token check(Tokenizer.TokenType tokenType) throws ParseError {
        Tokenizer.Token token = this.tokenizer.nextToken();
        if (token.getType() != tokenType) {
            throw new ParseError(token, tokenType);
        }
        return token;
    }

    public TemplateEntry parse() throws ParseError {
        return this.parseExpression(EXPRESSION_END_TOKENS);
    }

    private TemplateEntry parseExpression(Collection<Tokenizer.TokenType> collection) throws ParseError {
        ArrayList<TemplateEntry> arrayList = new ArrayList<TemplateEntry>();
        while (true) {
            TemplateEntry templateEntry;
            Tokenizer.Token token;
            if ((token = this.tokenizer.lookAhead()).getType() == Tokenizer.TokenType.CONDITION_START) {
                templateEntry = this.parseCondition();
            } else if (token.getType() == Tokenizer.TokenType.CONTEXT_SWITCH_START) {
                templateEntry = this.parseContextSwitch();
            } else if (token.getType() == Tokenizer.TokenType.VARIABLE_START) {
                templateEntry = this.parseVariable();
            } else {
                if (collection.contains((Object)token.getType())) {
                    return CompoundTemplateEntry.fromArray(arrayList.toArray(new TemplateEntry[arrayList.size()]));
                }
                if (token.getType() == Tokenizer.TokenType.TEXT) {
                    this.tokenizer.nextToken();
                    templateEntry = new StaticText(token.getText());
                } else {
                    throw new ParseError(token);
                }
            }
            arrayList.add(templateEntry);
        }
    }

    private TemplateEntry parseVariable() throws ParseError {
        this.check(Tokenizer.TokenType.VARIABLE_START);
        String string = this.check(Tokenizer.TokenType.TEXT).getText();
        this.check(Tokenizer.TokenType.END);
        return new Variable(string);
    }

    private void skipWhitespace() throws ParseError {
        Tokenizer.Token token = this.tokenizer.lookAhead();
        if (token.getType() == Tokenizer.TokenType.TEXT && token.getText().trim().isEmpty()) {
            this.tokenizer.nextToken();
        }
    }

    private TemplateEntry parseCondition() throws ParseError {
        this.check(Tokenizer.TokenType.CONDITION_START);
        Condition condition = new Condition();
        while (true) {
            Tokenizer.Token token = this.tokenizer.skip('\'');
            this.check(Tokenizer.TokenType.APOSTROPHE);
            TemplateEntry templateEntry = this.parseExpression(CONDITION_WITH_APOSTROPHES_END_TOKENS);
            this.check(Tokenizer.TokenType.APOSTROPHE);
            String string = token.getText().trim();
            if (string.isEmpty()) {
                condition.getEntries().add(templateEntry);
            } else {
                try {
                    condition.getEntries().add(new SearchExpressionCondition(SearchCompiler.compile(string), templateEntry));
                }
                catch (SearchParseError searchParseError) {
                    throw new ParseError(token.getPosition(), searchParseError);
                }
            }
            this.skipWhitespace();
            Tokenizer.Token token2 = this.tokenizer.lookAhead();
            if (token2.getType() == Tokenizer.TokenType.END) {
                this.tokenizer.nextToken();
                return condition;
            }
            this.check(Tokenizer.TokenType.PIPE);
        }
    }

    private TemplateEntry parseContextSwitch() throws ParseError {
        ContextSwitchTemplate contextSwitchTemplate;
        this.check(Tokenizer.TokenType.CONTEXT_SWITCH_START);
        Tokenizer.Token token = this.tokenizer.skip('\'');
        this.check(Tokenizer.TokenType.APOSTROPHE);
        TemplateEntry templateEntry = this.parseExpression(CONDITION_WITH_APOSTROPHES_END_TOKENS);
        this.check(Tokenizer.TokenType.APOSTROPHE);
        String string = token.getText().trim();
        if (string.isEmpty()) {
            throw new ParseError(I18n.tr("Expected search expression", new Object[0]));
        }
        try {
            SearchCompiler.Match match = SearchCompiler.compile(string);
            contextSwitchTemplate = new ContextSwitchTemplate(match, templateEntry, token.getPosition());
        }
        catch (SearchParseError searchParseError) {
            throw new ParseError(token.getPosition(), searchParseError);
        }
        this.skipWhitespace();
        this.check(Tokenizer.TokenType.END);
        return contextSwitchTemplate;
    }
}

