/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

public final class BitSet {
    static final int BITS_PER_BYTE = 8;
    public static final int SINGLE_BYTE_SIZE = 256;
    private static final int BITS_IN_ROOM = 32;
    static final int BITSET_SIZE = 8;
    static final int ROOM_SHIFT = BitSet.log2(32);
    final int[] bits = new int[8];
    private static final int BITS_TO_STRING_WRAP = 4;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BitSet");
        for (int i2 = 0; i2 < 256; ++i2) {
            if (i2 % 64 == 0) {
                buffer.append("\n  ");
            }
            buffer.append(this.at(i2) ? "1" : "0");
        }
        return buffer.toString();
    }

    public boolean at(int pos2) {
        return (this.bits[pos2 >>> ROOM_SHIFT] & BitSet.bit(pos2)) != 0;
    }

    public void set(int pos2) {
        int n = pos2 >>> ROOM_SHIFT;
        this.bits[n] = this.bits[n] | BitSet.bit(pos2);
    }

    public void clear(int pos2) {
        int n = pos2 >>> ROOM_SHIFT;
        this.bits[n] = this.bits[n] & ~BitSet.bit(pos2);
    }

    public void invert(int pos2) {
        int n = pos2 >>> ROOM_SHIFT;
        this.bits[n] = this.bits[n] ^ BitSet.bit(pos2);
    }

    public void clear() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < 8; ++i2) {
            if (this.bits[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public void setRange(int from, int to) {
        for (int i2 = from; i2 <= to && i2 < 256; ++i2) {
            this.set(i2);
        }
    }

    public void setAll() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bits[i2] = -1;
        }
    }

    public void invert() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bits[i2] = ~this.bits[i2];
        }
    }

    public void invertTo(BitSet to) {
        for (int i2 = 0; i2 < 8; ++i2) {
            to.bits[i2] = ~this.bits[i2];
        }
    }

    public void and(BitSet other) {
        for (int i2 = 0; i2 < 8; ++i2) {
            int n = i2;
            this.bits[n] = this.bits[n] & other.bits[i2];
        }
    }

    public void or(BitSet other) {
        for (int i2 = 0; i2 < 8; ++i2) {
            int n = i2;
            this.bits[n] = this.bits[n] | other.bits[i2];
        }
    }

    public void copy(BitSet other) {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.bits[i2] = other.bits[i2];
        }
    }

    public int numOn() {
        int num = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!this.at(i2)) continue;
            ++num;
        }
        return num;
    }

    static int bit(int pos2) {
        return 1 << pos2 % 256;
    }

    private static int log2(int n) {
        int log = 0;
        while ((n >>>= 1) != 0) {
            ++log;
        }
        return log;
    }
}

