/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.WsaTubeHelper;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.OneWayFeature;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.message.RelatesToHeader;
import com.sun.xml.internal.ws.message.StringHeader;
import com.sun.xml.internal.ws.resources.AddressingMessages;
import com.sun.xml.internal.ws.resources.ClientMessages;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;

public final class HeaderList
extends ArrayList<Header> {
    private static final long serialVersionUID = -6358045781349627237L;
    private int understoodBits;
    private BitSet moreUnderstoodBits = null;
    private String to = null;
    private String action = null;
    private WSEndpointReference replyTo = null;
    private WSEndpointReference faultTo = null;
    private String messageId;
    private String relatesTo;

    public HeaderList() {
    }

    public HeaderList(HeaderList that) {
        super(that);
        this.understoodBits = that.understoodBits;
        if (that.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = (BitSet)that.moreUnderstoodBits.clone();
        }
        this.to = that.to;
        this.action = that.action;
        this.replyTo = that.replyTo;
        this.faultTo = that.faultTo;
        this.messageId = that.messageId;
    }

    @Override
    public int size() {
        return super.size();
    }

    public void addAll(Header ... headers) {
        for (Header header : headers) {
            this.add(header);
        }
    }

    @Override
    public Header get(int index) {
        return (Header)super.get(index);
    }

    public void understood(int index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index < 32) {
            this.understoodBits |= 1 << index;
        } else {
            if (this.moreUnderstoodBits == null) {
                this.moreUnderstoodBits = new BitSet();
            }
            this.moreUnderstoodBits.set(index - 32);
        }
    }

    public boolean isUnderstood(int index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index < 32) {
            return this.understoodBits == (this.understoodBits | 1 << index);
        }
        if (this.moreUnderstoodBits == null) {
            return false;
        }
        return this.moreUnderstoodBits.get(index - 32);
    }

    public void understood(@NotNull Header header) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (this.get(i) != header) continue;
            this.understood(i);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public Header get(@NotNull String nsUri, @NotNull String localName, boolean markAsUnderstood) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            Header h = this.get(i);
            if (!h.getLocalPart().equals(localName) || !h.getNamespaceURI().equals(nsUri)) continue;
            if (markAsUnderstood) {
                this.understood(i);
            }
            return h;
        }
        return null;
    }

    public Header get(String nsUri, String localName) {
        return this.get(nsUri, localName, true);
    }

    @Nullable
    public Header get(@NotNull QName name, boolean markAsUnderstood) {
        return this.get(name.getNamespaceURI(), name.getLocalPart(), markAsUnderstood);
    }

    @Nullable
    public Header get(@NotNull QName name) {
        return this.get(name, true);
    }

    public Iterator<Header> getHeaders(String nsUri, String localName) {
        return this.getHeaders(nsUri, localName, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String nsUri, final @NotNull String localName, final boolean markAsUnderstood) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (markAsUnderstood) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header h;
                    if (!(h = HeaderList.this.get(this.idx++)).getLocalPart().equals(localName) || !h.getNamespaceURI().equals(nsUri)) continue;
                    this.next = h;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull QName headerName, boolean markAsUnderstood) {
        return this.getHeaders(headerName.getNamespaceURI(), headerName.getLocalPart(), markAsUnderstood);
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull String nsUri) {
        return this.getHeaders(nsUri, true);
    }

    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String nsUri, final boolean markAsUnderstood) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (markAsUnderstood) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header h;
                    if (!(h = HeaderList.this.get(this.idx++)).getNamespaceURI().equals(nsUri)) continue;
                    this.next = h;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Header getFirstHeader(QName name, boolean markUnderstood, SOAPVersion sv) {
        if (sv == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        Iterator<Header> iter = this.getHeaders(name.getNamespaceURI(), name.getLocalPart(), markUnderstood);
        while (iter.hasNext()) {
            Header h = iter.next();
            if (!h.getRole(sv).equals(sv.implicitRole)) continue;
            return h;
        }
        return null;
    }

    public String getTo(AddressingVersion av, SOAPVersion sv) {
        if (this.to != null) {
            return this.to;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.toTag, true, sv);
        this.to = h != null ? h.getStringContent() : av.anonymousUri;
        return this.to;
    }

    public String getAction(@NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        if (this.action != null) {
            return this.action;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.actionTag, true, sv);
        if (h != null) {
            this.action = h.getStringContent();
        }
        return this.action;
    }

    public WSEndpointReference getReplyTo(@NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.replyToTag, true, sv);
        if (h != null) {
            try {
                this.replyTo = h.readAsEPR(av);
            }
            catch (XMLStreamException e) {
                throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), e);
            }
        } else {
            this.replyTo = av.anonymousEpr;
        }
        return this.replyTo;
    }

    public WSEndpointReference getFaultTo(@NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        if (this.faultTo != null) {
            return this.faultTo;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.faultToTag, true, sv);
        if (h != null) {
            try {
                this.faultTo = h.readAsEPR(av);
            }
            catch (XMLStreamException e) {
                throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), e);
            }
        }
        return this.faultTo;
    }

    public String getMessageID(@NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        if (this.messageId != null) {
            return this.messageId;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.messageIDTag, true, sv);
        if (h != null) {
            this.messageId = h.getStringContent();
        }
        return this.messageId;
    }

    public String getRelatesTo(@NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        if (this.relatesTo != null) {
            return this.relatesTo;
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        Header h = this.getFirstHeader(av.relatesToTag, true, sv);
        if (h != null) {
            this.relatesTo = h.getStringContent();
        }
        return this.relatesTo;
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion av, SOAPVersion sv, boolean oneway, String action, boolean mustUnderstand) {
        this.fillCommonAddressingHeaders(packet, av, sv, action, mustUnderstand);
        if (!oneway) {
            WSEndpointReference epr = av.anonymousEpr;
            this.add(epr.createHeader(av.replyToTag));
            StringHeader h = new StringHeader(av.messageIDTag, packet.getMessage().getID(av, sv));
            this.add(h);
        }
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion av, SOAPVersion sv, boolean oneway, String action) {
        this.fillRequestAddressingHeaders(packet, av, sv, oneway, action, false);
    }

    public void fillRequestAddressingHeaders(WSDLPort wsdlPort, @NotNull WSBinding binding, Packet packet) {
        WSDLBoundOperation wbo;
        boolean oneway;
        if (binding == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_BINDING());
        }
        HeaderList hl = packet.getMessage().getHeaders();
        String action = hl.getAction(binding.getAddressingVersion(), binding.getSOAPVersion());
        if (action != null) {
            return;
        }
        AddressingVersion addressingVersion = binding.getAddressingVersion();
        WsaTubeHelper wsaHelper = addressingVersion.getWsaHelper(wsdlPort, null, binding);
        String effectiveInputAction = wsaHelper.getEffectiveInputAction(packet);
        if (effectiveInputAction == null || effectiveInputAction.equals("")) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ACTION());
        }
        boolean bl = oneway = packet.expectReply == false;
        if (wsdlPort != null && !oneway && packet.getMessage() != null && (wbo = wsdlPort.getBinding().get(packet.getWSDLOperation())) != null && wbo.getAnonymous() == WSDLBoundOperation.ANONYMOUS.prohibited) {
            throw new WebServiceException(AddressingMessages.WSAW_ANONYMOUS_PROHIBITED());
        }
        if (!binding.isFeatureEnabled(OneWayFeature.class)) {
            this.fillRequestAddressingHeaders(packet, addressingVersion, binding.getSOAPVersion(), oneway, effectiveInputAction, AddressingVersion.isRequired(binding));
        } else {
            this.fillRequestAddressingHeaders(packet, addressingVersion, binding.getSOAPVersion(), binding.getFeature(OneWayFeature.class), effectiveInputAction);
        }
    }

    private void fillRequestAddressingHeaders(@NotNull Packet packet, @NotNull AddressingVersion av, @NotNull SOAPVersion sv, @NotNull OneWayFeature of, @NotNull String action) {
        this.fillCommonAddressingHeaders(packet, av, sv, action, false);
        if (of.getReplyTo() != null) {
            this.add(of.getReplyTo().createHeader(av.replyToTag));
            StringHeader h = new StringHeader(av.messageIDTag, packet.getMessage().getID(av, sv));
            this.add(h);
        }
        if (of.getFrom() != null) {
            this.add(of.getFrom().createHeader(av.fromTag));
        }
        if (of.getRelatesToID() != null) {
            this.add(new RelatesToHeader(av.relatesToTag, of.getRelatesToID()));
        }
    }

    private void fillCommonAddressingHeaders(Packet packet, @NotNull AddressingVersion av, @NotNull SOAPVersion sv, @NotNull String action, boolean mustUnderstand) {
        if (packet == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_PACKET());
        }
        if (av == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ADDRESSING_VERSION());
        }
        if (sv == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_SOAP_VERSION());
        }
        if (action == null) {
            throw new IllegalArgumentException(AddressingMessages.NULL_ACTION());
        }
        StringHeader h = new StringHeader(av.toTag, packet.endpointAddress.toString());
        this.add(h);
        packet.soapAction = action;
        h = new StringHeader(av.actionTag, action, sv, mustUnderstand);
        this.add(h);
    }

    @Override
    public boolean add(Header header) {
        return super.add(header);
    }

    @Nullable
    public Header remove(@NotNull String nsUri, @NotNull String localName) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            Header h = this.get(i);
            if (!h.getLocalPart().equals(localName) || !h.getNamespaceURI().equals(nsUri)) continue;
            return this.remove(i);
        }
        return null;
    }

    @Nullable
    public Header remove(@NotNull QName name) {
        return this.remove(name.getNamespaceURI(), name.getLocalPart());
    }

    @Override
    public Header remove(int index) {
        this.removeUnderstoodBit(index);
        return (Header)super.remove(index);
    }

    private void removeUnderstoodBit(int index) {
        assert (index < this.size());
        if (index < 32) {
            int shiftedUpperBits = this.understoodBits >>> -31 + index << index;
            int lowerBits = this.understoodBits << -index >>> 31 - index >>> 1;
            this.understoodBits = shiftedUpperBits | lowerBits;
            if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
                if (this.moreUnderstoodBits.get(0)) {
                    this.understoodBits |= Integer.MIN_VALUE;
                }
                this.moreUnderstoodBits.clear(0);
                int i = this.moreUnderstoodBits.nextSetBit(1);
                while (i > 0) {
                    this.moreUnderstoodBits.set(i - 1);
                    this.moreUnderstoodBits.clear(i);
                    i = this.moreUnderstoodBits.nextSetBit(i + 1);
                }
            }
        } else if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
            this.moreUnderstoodBits.clear(index -= 32);
            int i = this.moreUnderstoodBits.nextSetBit(index);
            while (i >= 1) {
                this.moreUnderstoodBits.set(i - 1);
                this.moreUnderstoodBits.clear(i);
                i = this.moreUnderstoodBits.nextSetBit(i + 1);
            }
        }
        if (this.size() - 1 <= 33 && this.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = null;
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o != null) {
            for (int index = 0; index < this.size(); ++index) {
                if (!o.equals(this.get(index))) continue;
                this.remove(index);
                return true;
            }
        }
        return false;
    }

    public static HeaderList copy(HeaderList original) {
        if (original == null) {
            return null;
        }
        return new HeaderList(original);
    }

    public void readResponseAddressingHeaders(WSDLPort wsdlPort, WSBinding binding) {
        String wsaAction = this.getAction(binding.getAddressingVersion(), binding.getSOAPVersion());
    }
}

