/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Accessible {
    Vector<Menu> menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<MenuBar> clazz = MenuBar.class;
        synchronized (MenuBar.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int nmenus = this.getMenuCount();
            for (int i = 0; i < nmenus; ++i) {
                this.getMenu(i).addNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int nmenus = this.getMenuCount();
            for (int i = 0; i < nmenus; ++i) {
                this.getMenu(i).removeNotify();
            }
            super.removeNotify();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpMenu(Menu m) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == m) {
                return;
            }
            if (this.helpMenu != null) {
                this.remove(this.helpMenu);
            }
            if (m.parent != this) {
                this.add(m);
            }
            this.helpMenu = m;
            if (m != null) {
                m.isHelpMenu = true;
                m.parent = this;
                MenuBarPeer peer = (MenuBarPeer)this.peer;
                if (peer != null) {
                    if (m.peer == null) {
                        m.addNotify();
                    }
                    peer.addHelpMenu(m);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(Menu m) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (m.parent != null) {
                m.parent.remove(m);
            }
            m.parent = this;
            MenuBarPeer peer = (MenuBarPeer)this.peer;
            if (peer != null) {
                if (m.peer == null) {
                    m.addNotify();
                }
                this.menus.addElement(m);
                peer.addMenu(m);
            } else {
                this.menus.addElement(m);
            }
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Menu m = this.getMenu(index);
            this.menus.removeElementAt(index);
            MenuBarPeer peer = (MenuBarPeer)this.peer;
            if (peer != null) {
                peer.delMenu(index);
                m.removeNotify();
                m.parent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(MenuComponent m) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int index = this.menus.indexOf(m);
            if (index >= 0) {
                this.remove(index);
            }
        }
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    @Deprecated
    public int countMenus() {
        return this.getMenuCountImpl();
    }

    final int getMenuCountImpl() {
        return this.menus.size();
    }

    public Menu getMenu(int i) {
        return this.getMenuImpl(i);
    }

    final Menu getMenuImpl(int i) {
        return this.menus.elementAt(i);
    }

    public synchronized Enumeration<MenuShortcut> shortcuts() {
        Vector<MenuShortcut> shortcuts = new Vector<MenuShortcut>();
        int nmenus = this.getMenuCount();
        for (int i = 0; i < nmenus; ++i) {
            Enumeration<MenuShortcut> e = this.getMenu(i).shortcuts();
            while (e.hasMoreElements()) {
                shortcuts.addElement(e.nextElement());
            }
        }
        return shortcuts.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut s) {
        int nmenus = this.getMenuCount();
        for (int i = 0; i < nmenus; ++i) {
            MenuItem mi = this.getMenu(i).getShortcutMenuItem(s);
            if (mi == null) continue;
            return mi;
        }
        return null;
    }

    boolean handleShortcut(KeyEvent e) {
        int id = e.getID();
        if (id != 401 && id != 402) {
            return false;
        }
        int accelKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((e.getModifiers() & accelKey) == 0) {
            return false;
        }
        int nmenus = this.getMenuCount();
        for (int i = 0; i < nmenus; ++i) {
            Menu m = this.getMenu(i);
            if (!m.handleShortcut(e)) continue;
            return true;
        }
        return false;
    }

    public void deleteShortcut(MenuShortcut s) {
        int nmenus = this.getMenuCount();
        for (int i = 0; i < nmenus; ++i) {
            this.getMenu(i).deleteShortcut(s);
        }
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        s.defaultReadObject();
        for (int i = 0; i < this.menus.size(); ++i) {
            Menu m = this.menus.elementAt(i);
            m.parent = this;
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    @Override
    int getAccessibleChildIndex(MenuComponent child) {
        return this.menus.indexOf(child);
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuBar.initIDs();
        }
        AWTAccessor.setMenuBarAccessor(new AWTAccessor.MenuBarAccessor(){

            @Override
            public Menu getHelpMenu(MenuBar menuBar) {
                return menuBar.helpMenu;
            }

            @Override
            public Vector<Menu> getMenus(MenuBar menuBar) {
                return menuBar.menus;
            }
        });
        nameCounter = 0;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private static final long serialVersionUID = -8577604491830083815L;

        protected AccessibleAWTMenuBar() {
            super(MenuBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

