/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public final class ScriptProcessor
extends AbstractProcessor {
    public static final String TYPE = "script";
    private final Script script;
    private final ScriptService scriptService;

    ScriptProcessor(String tag, Script script, ScriptService scriptService) {
        super(tag);
        this.script = script;
        this.scriptService = scriptService;
    }

    public void execute(IngestDocument document) {
        CompiledScript compiledScript = this.scriptService.compile(this.script, (ScriptContext)ScriptContext.Standard.INGEST);
        ExecutableScript executableScript = this.scriptService.executable(compiledScript, this.script.getParams());
        executableScript.setNextVar("ctx", (Object)document.getSourceAndMetadata());
        executableScript.run();
    }

    public String getType() {
        return TYPE;
    }

    Script getScript() {
        return this.script;
    }

    public static final class Factory
    implements Processor.Factory {
        private final Logger logger = ESLoggerFactory.getLogger(Factory.class);
        private final DeprecationLogger deprecationLogger = new DeprecationLogger(this.logger);
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public ScriptProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String scriptPropertyUsed;
            Script script;
            boolean moreThanOneConfigured;
            boolean containsNoScript;
            String lang = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"lang");
            String source = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"source");
            String file = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"file");
            String id = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"id");
            Map params = ConfigurationUtils.readOptionalMap((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"params");
            if (source == null && (source = ConfigurationUtils.readOptionalStringProperty((String)ScriptProcessor.TYPE, (String)processorTag, config, (String)"inline")) != null) {
                this.deprecationLogger.deprecated("Specifying script source with [inline] is deprecated, use [source] instead.", new Object[0]);
            }
            boolean bl = containsNoScript = !Strings.hasLength((String)file) && !Strings.hasLength((String)id) && !Strings.hasLength((String)source);
            if (containsNoScript) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Need [file], [id], or [source] parameter to refer to scripts");
            }
            boolean bl2 = moreThanOneConfigured = Strings.hasLength((String)file) && Strings.hasLength((String)id) || Strings.hasLength((String)file) && Strings.hasLength((String)source) || Strings.hasLength((String)id) && Strings.hasLength((String)source);
            if (moreThanOneConfigured) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Only one of [file], [id], or [source] may be configured");
            }
            if (lang == null) {
                lang = "painless";
            }
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (Strings.hasLength((String)file)) {
                script = new Script(ScriptType.FILE, lang, file, params);
                scriptPropertyUsed = "file";
            } else if (Strings.hasLength((String)source)) {
                script = new Script(ScriptType.INLINE, lang, source, params);
                scriptPropertyUsed = "source";
            } else if (Strings.hasLength((String)id)) {
                script = new Script(ScriptType.STORED, lang, id, params);
                scriptPropertyUsed = "id";
            } else {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, null, (String)"Could not initialize script");
            }
            try {
                this.scriptService.compile(script, (ScriptContext)ScriptContext.Standard.INGEST);
            }
            catch (ScriptException e) {
                throw ConfigurationUtils.newConfigurationException((String)ScriptProcessor.TYPE, (String)processorTag, (String)scriptPropertyUsed, (Exception)((Object)e));
            }
            return new ScriptProcessor(processorTag, script, this.scriptService);
        }
    }
}

