/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.index.translog.Translog;

final class MultiSnapshot
implements Translog.Snapshot {
    private final Translog.Snapshot[] translogs;
    private final int totalOperations;
    private int index;

    MultiSnapshot(Translog.Snapshot[] translogs) {
        this.translogs = translogs;
        this.totalOperations = Arrays.stream(translogs).mapToInt(Translog.Snapshot::totalOperations).sum();
        this.index = 0;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public Translog.Operation next() throws IOException {
        while (this.index < this.translogs.length) {
            Translog.Snapshot current = this.translogs[this.index];
            Translog.Operation op = current.next();
            if (op != null) {
                return op;
            }
            ++this.index;
        }
        return null;
    }
}

