/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;

public class ExpertToggleAction
extends ToggleAction {
    private static final ListenerList<ExpertModeChangeListener> listeners = ListenerList.createUnchecked();
    private static final ListenerList<Component> visibilityToggleListeners = ListenerList.createUnchecked();
    private static final BooleanProperty PREF_EXPERT = new BooleanProperty("expert", false);
    private static final ExpertToggleAction INSTANCE = new ExpertToggleAction();

    private static synchronized void fireExpertModeChanged(boolean bl) {
        listeners.fireEvent(expertModeChangeListener -> expertModeChangeListener.expertChanged(bl));
        visibilityToggleListeners.fireEvent(component -> component.setVisible(bl));
    }

    public static void addExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener) {
        ExpertToggleAction.addExpertModeChangeListener(expertModeChangeListener, false);
    }

    public static synchronized void addExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener, boolean bl) {
        if (expertModeChangeListener == null) {
            return;
        }
        listeners.addWeakListener(expertModeChangeListener);
        if (bl) {
            expertModeChangeListener.expertChanged(ExpertToggleAction.isExpert());
        }
    }

    public static synchronized void removeExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener) {
        if (expertModeChangeListener == null) {
            return;
        }
        listeners.removeListener(expertModeChangeListener);
    }

    public static synchronized void addVisibilitySwitcher(Component component) {
        if (component == null) {
            return;
        }
        visibilityToggleListeners.addWeakListener(component);
        component.setVisible(ExpertToggleAction.isExpert());
    }

    public static synchronized void removeVisibilitySwitcher(Component component) {
        if (component == null) {
            return;
        }
        visibilityToggleListeners.removeListener(component);
    }

    public ExpertToggleAction() {
        super(I18n.tr("Expert Mode", new Object[0]), "expert", I18n.tr("Enable/disable expert mode", new Object[0]), null, false);
        this.putValue("toolbar", "expertmode");
        if (MainApplication.getToolbar() != null) {
            MainApplication.getToolbar().register(this);
        }
        this.setSelected(PREF_EXPERT.get());
        this.notifySelectedState();
    }

    @Override
    protected final void notifySelectedState() {
        super.notifySelectedState();
        PREF_EXPERT.put(this.isSelected());
        ExpertToggleAction.fireExpertModeChanged(this.isSelected());
    }

    public void setExpert(boolean bl) {
        if (this.isSelected() != bl) {
            this.setSelected(bl);
            this.notifySelectedState();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState(actionEvent);
        this.notifySelectedState();
    }

    public static ExpertToggleAction getInstance() {
        return INSTANCE;
    }

    public static boolean isExpert() {
        return INSTANCE.isSelected();
    }

    @FunctionalInterface
    public static interface ExpertModeChangeListener {
        public void expertChanged(boolean var1);
    }
}

