/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DrawSnapHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.paint.ArrowPaintHelper;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.DoubleProperty;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class DrawAction
extends MapMode
implements MapViewPaintable,
DataSelectionListener,
KeyPressReleaseListener,
ModifierExListener {
    public static final CachingProperty<Boolean> VIEWPORT_FOLLOWING = new BooleanProperty("draw.viewport.following", false).cached();
    private static final Color ORANGE_TRANSPARENT = new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue(), 128);
    private static final ArrowPaintHelper START_WAY_INDICATOR = new ArrowPaintHelper(Utils.toRadians(90.0), 8.0);
    static final CachingProperty<Boolean> USE_REPEATED_SHORTCUT = new BooleanProperty("draw.anglesnap.toggleOnRepeatedA", true).cached();
    static final CachingProperty<BasicStroke> RUBBER_LINE_STROKE = new StrokeProperty("draw.stroke.helper-line", "3").cached();
    static final CachingProperty<BasicStroke> HIGHLIGHT_STROKE = new StrokeProperty("draw.anglesnap.stroke.highlight", "10").cached();
    static final CachingProperty<BasicStroke> HELPER_STROKE = new StrokeProperty("draw.anglesnap.stroke.helper", "1 4").cached();
    static final CachingProperty<Double> SNAP_ANGLE_TOLERANCE = new DoubleProperty("draw.anglesnap.tolerance", 5.0).cached();
    static final CachingProperty<Boolean> DRAW_CONSTRUCTION_GEOMETRY = new BooleanProperty("draw.anglesnap.drawConstructionGeometry", true).cached();
    static final CachingProperty<Boolean> SHOW_PROJECTED_POINT = new BooleanProperty("draw.anglesnap.drawProjectedPoint", true).cached();
    static final CachingProperty<Boolean> SNAP_TO_PROJECTIONS = new BooleanProperty("draw.anglesnap.projectionsnap", true).cached();
    static final CachingProperty<Boolean> SHOW_ANGLE = new BooleanProperty("draw.anglesnap.showAngle", true).cached();
    static final CachingProperty<Color> SNAP_HELPER_COLOR = new ColorProperty(I18n.marktr("draw angle snap"), Color.ORANGE).cached();
    static final CachingProperty<Color> HIGHLIGHT_COLOR = new ColorProperty(I18n.marktr("draw angle snap highlight"), ORANGE_TRANSPARENT).cached();
    static final AbstractToStringProperty<Color> RUBBER_LINE_COLOR = PaintColors.SELECTED.getProperty().getChildColor(I18n.marktr("helper line"));
    static final CachingProperty<Boolean> DRAW_HELPER_LINE = new BooleanProperty("draw.helper-line", true).cached();
    static final CachingProperty<Boolean> DRAW_TARGET_HIGHLIGHT = new BooleanProperty("draw.target-highlight", true).cached();
    static final CachingProperty<Double> SNAP_TO_INTERSECTION_THRESHOLD = new DoubleProperty("edit.snap-intersection-threshold", 10.0).cached();
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private transient Node lastUsedNode;
    private double toleranceMultiplier;
    private transient Node mouseOnExistingNode;
    private transient Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private transient Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private boolean wayIsFinished;
    private Point mousePos;
    private Point oldMousePos;
    private transient Node currentBaseNode;
    private transient Node previousNode;
    private EastNorth currentMouseEastNorth;
    private final transient DrawSnapHelper snapHelper = new DrawSnapHelper(this);
    private final transient Shortcut backspaceShortcut;
    private final BackSpaceAction backspaceAction;
    private final transient Shortcut snappingShortcut = Shortcut.registerShortcut("mapmode:drawanglesnapping", I18n.tr("Mode: Draw Angle snapping", new Object[0]), 65535, 5000);
    private boolean ignoreNextKeyRelease;
    private final SnapChangeAction snapChangeAction = new SnapChangeAction();
    private final JCheckBoxMenuItem snapCheckboxMenuItem = this.addMenuItem();
    private static final BasicStroke BASIC_STROKE = new BasicStroke(1.0f);
    private Point rightClickPressPos;

    public DrawAction() {
        super(I18n.tr("Draw", new Object[0]), "node/autonode", I18n.tr("Draw nodes", new Object[0]), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw", new Object[0])), 65, 5003), ImageProvider.getCursor("crosshair", null));
        this.snapHelper.setMenuCheckBox(this.snapCheckboxMenuItem);
        this.backspaceShortcut = Shortcut.registerShortcut("mapmode:backspace", I18n.tr("Backspace in Add mode", new Object[0]), 8, 5003);
        this.backspaceAction = new BackSpaceAction();
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
        this.snapHelper.init();
    }

    private JCheckBoxMenuItem addMenuItem() {
        int n = MainApplication.getMenu().editMenu.getItemCount();
        for (int i = n - 1; i > 0; --i) {
            JMenuItem jMenuItem = MainApplication.getMenu().editMenu.getItem(i);
            if (jMenuItem == null || jMenuItem.getAction() == null || !(jMenuItem.getAction() instanceof SnapChangeAction)) continue;
            MainApplication.getMenu().editMenu.remove(i);
        }
        return MainMenu.addWithCheckbox(MainApplication.getMenu().editMenu, this.snapChangeAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    private boolean redrawIfRequired() {
        boolean bl;
        this.updateStatusLine();
        boolean bl2 = bl = DRAW_HELPER_LINE.get() != false && !this.wayIsFinished;
        if (DRAW_TARGET_HIGHLIGHT.get().booleanValue()) {
            for (OsmPrimitive object : this.newHighlights) {
                if (this.oldHighlights.contains(object)) continue;
                object.setHighlighted(true);
                bl = true;
            }
            this.oldHighlights.removeAll(this.newHighlights);
            for (OsmPrimitive osmPrimitive : this.oldHighlights) {
                osmPrimitive.setHighlighted(false);
                bl = true;
            }
        }
        this.oldHighlights = this.newHighlights;
        if (!bl && !DRAW_TARGET_HIGHLIGHT.get().booleanValue()) {
            return false;
        }
        OsmDataLayer osmDataLayer = this.getLayerManager().getEditLayer();
        if (osmDataLayer != null && this.getCurrentBaseNode() != null && !osmDataLayer.data.selectionEmpty()) {
            DataSet dataSet = osmDataLayer.data;
            Way way = DrawAction.getWayForNode(this.getCurrentBaseNode());
            if (this.alt && way != null && (!this.getCurrentBaseNode().isSelected() || way.isSelected())) {
                DrawAction.addRemoveSelection(dataSet, this.getCurrentBaseNode(), way);
                bl = true;
            } else if (!this.alt && way != null && !way.isSelected()) {
                dataSet.addSelected(way);
                bl = true;
            }
        }
        if (bl && osmDataLayer != null) {
            osmDataLayer.invalidate();
        }
        return bl;
    }

    private static void addRemoveSelection(DataSet dataSet, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        dataSet.beginUpdate();
        try {
            dataSet.addSelected(osmPrimitive);
            dataSet.clearSelection(osmPrimitive2);
        }
        finally {
            dataSet.endUpdate();
        }
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        this.determineCurrentBaseNodeAndPreviousNode(this.getLayerManager().getEditDataSet().getSelected());
        this.wayIsFinished = this.getCurrentBaseNode() == null;
        this.toleranceMultiplier = 0.01 * (double)NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue();
        this.snapHelper.init();
        this.snapCheckboxMenuItem.getAction().setEnabled(true);
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.statusLine.getAnglePanel().addMouseListener(this.snapHelper.anglePopupListener);
        MainApplication.registerActionShortcut(this.backspaceAction, this.backspaceShortcut);
        mapFrame.mapView.addMouseListener(this);
        mapFrame.mapView.addMouseMotionListener(this);
        mapFrame.mapView.addTemporaryLayer(this);
        SelectionEventManager.getInstance().addSelectionListenerForEdt(this);
        mapFrame.keyDetector.addKeyListener(this);
        mapFrame.keyDetector.addModifierExListener(this);
        this.ignoreNextKeyRelease = true;
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.mapView.removeMouseListener(this);
        mapFrame.mapView.removeMouseMotionListener(this);
        mapFrame.mapView.removeTemporaryLayer(this);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MainApplication.unregisterActionShortcut(this.backspaceAction, this.backspaceShortcut);
        this.snapHelper.unsetFixedMode();
        this.snapCheckboxMenuItem.getAction().setEnabled(false);
        mapFrame.statusLine.getAnglePanel().removeMouseListener(this.snapHelper.anglePopupListener);
        mapFrame.statusLine.activateAnglePanel(false);
        this.removeHighlighting();
        mapFrame.keyDetector.removeKeyListener(this);
        mapFrame.keyDetector.removeModifierExListener(this);
    }

    @Override
    public void modifiersExChanged(int n) {
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiersEx(n);
        this.computeHelperLine();
        this.addHighlighting();
    }

    @Override
    public void doKeyPressed(KeyEvent keyEvent) {
        if (!(this.snappingShortcut.isEvent(keyEvent) || USE_REPEATED_SHORTCUT.get().booleanValue() && this.getShortcut().isEvent(keyEvent))) {
            return;
        }
        this.snapHelper.setFixedMode();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    @Override
    public void doKeyReleased(KeyEvent keyEvent) {
        if (!(this.snappingShortcut.isEvent(keyEvent) || USE_REPEATED_SHORTCUT.get().booleanValue() && this.getShortcut().isEvent(keyEvent))) {
            return;
        }
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
            return;
        }
        this.snapHelper.unFixOrTurnOff();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent selectionChangeEvent) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void tryAgain(MouseEvent mouseEvent) {
        this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[0]);
        this.mouseReleased(mouseEvent);
    }

    private void finishDrawing() {
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        MainApplication.getMap().selectSelectTool(true);
        this.snapHelper.noSnapNow();
        this.computeHelperLine();
        this.removeHighlighting();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.rightClickPressPos = mouseEvent.getPoint();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        Serializable serializable;
        Iterator<Way> iterator;
        if (mouseEvent.getButton() == 3) {
            Point point = mouseEvent.getPoint();
            if (point.equals(this.rightClickPressPos)) {
                this.tryToSetBaseSegmentForAngleSnap();
            }
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        MapView mapView = MainApplication.getMap().mapView;
        if (!mapView.isActiveLayerDrawable()) {
            return;
        }
        mapView.requestFocus();
        if (mouseEvent.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(dataSet.getSelected());
        boolean bl = false;
        Node node = mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        if (this.ctrl) {
            iterator = dataSet.getSelectedWays().iterator();
            if (iterator.hasNext()) {
                if (!iterator.next().containsNode(node)) {
                    node = null;
                }
            } else {
                node = null;
            }
        }
        if (node != null && !this.snapHelper.isActive()) {
            if (arrayList.isEmpty() || this.wayIsFinished) {
                dataSet.setSelected(node);
                iterator = DrawAction.getWayForNode(node);
                if (iterator != null) {
                    dataSet.addSelected(new PrimitiveId[]{iterator});
                }
                this.wayIsFinished = false;
                return;
            }
        } else {
            if (node != null) {
                serializable = node.getEastNorth();
                iterator = this.snapHelper.getSnapPoint((EastNorth)serializable);
                double d = mapView.getDist100Pixel() * this.toleranceMultiplier;
                if (((EastNorth)serializable).distance((EastNorth)((Object)iterator)) > d) {
                    node = new Node((EastNorth)((Object)iterator));
                    bl = true;
                }
            } else {
                serializable = mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
                iterator = this.snapHelper.isSnapOn() ? this.snapHelper.getSnapPoint((EastNorth)serializable) : serializable;
                node = new Node((EastNorth)((Object)iterator));
                bl = true;
            }
            this.snapHelper.unsetFixedMode();
        }
        iterator = new LinkedList();
        serializable = new LinkedList<OsmPrimitive>(dataSet.getSelected());
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        if (bl) {
            if (node.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            iterator.add((Way)((Object)new AddCommand(node)));
            if (!this.ctrl) {
                List<WaySegment> list = mapView.getNearestWaySegments(mapView.getPoint(node), OsmPrimitive::isSelectable);
                if (this.snapHelper.isActive()) {
                    this.tryToMoveNodeOnIntersection(list, node);
                }
                this.insertNodeIntoAllNearbySegments(list, node, (Collection<OsmPrimitive>)((Object)serializable), (Collection<Command>)((Object)iterator), arrayList3, arrayList2);
            }
        }
        boolean bl2 = false;
        boolean bl3 = this.wayIsFinished;
        this.wayIsFinished = false;
        if (!arrayList.isEmpty() && !this.shift) {
            object2 = null;
            object = null;
            for (OsmPrimitive object3 : arrayList) {
                if (object3 instanceof Node) {
                    if (object2 != null) {
                        this.tryAgain(mouseEvent);
                        return;
                    }
                    object2 = (Node)object3;
                    continue;
                }
                if (!(object3 instanceof Way)) continue;
                if (object != null) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                object = (Way)object3;
            }
            Node node2 = this.findNodeToContinueFrom((Node)object2, (Way)object);
            if (node2 == null) {
                this.tryAgain(mouseEvent);
                return;
            }
            if (!bl3) {
                void var16_26;
                Way way;
                void var16_22;
                int n;
                Object object3;
                if (this.isSelfContainedWay((Way)object, node2, node)) {
                    return;
                }
                if (node2 == node) {
                    this.finishDrawing();
                    return;
                }
                Object object4 = this.alt ? null : (object3 = object != null ? object : DrawAction.getWayForNode(node2));
                if (object3 != null) {
                    n = 0;
                    for (Node node3 : ((Way)object3).getNodes()) {
                        if (!node3.equals(node2)) continue;
                        ++n;
                    }
                    if (n > 1) {
                        Object var16_21 = null;
                    }
                }
                if (var16_22 == null) {
                    Way way2 = new Way();
                    way2.addNode(node2);
                    iterator.add((Way)((Object)new AddCommand(way2)));
                    way = way2;
                } else {
                    n = arrayList3.indexOf(var16_22);
                    if (n != -1) {
                        Way way3;
                        way = way3 = (Way)arrayList2.get(n);
                    } else {
                        way = var16_22;
                        Way way4 = new Way((Way)var16_22);
                        iterator.add((Way)((Object)new ChangeCommand((OsmPrimitive)var16_22, way4)));
                        Object object5 = way4;
                    }
                }
                if (var16_26.containsNode(node)) {
                    this.wayIsFinished = true;
                    arrayList.clear();
                }
                if (var16_26.getNode(var16_26.getNodesCount() - 1) == node2) {
                    var16_26.addNode(node);
                } else {
                    var16_26.addNode(0, node);
                }
                bl2 = true;
                serializable.clear();
                serializable.add(way);
            }
        }
        if (!bl2 && !bl) {
            return;
        }
        object2 = DrawAction.getTitle(bl, node, (Collection<OsmPrimitive>)((Object)serializable), arrayList2, bl2);
        object = new SequenceCommand((String)object2, (Collection<Command>)((Object)iterator));
        MainApplication.undoRedo.add((Command)object);
        if (!this.wayIsFinished) {
            this.lastUsedNode = node;
        }
        dataSet.setSelected((Collection<? extends PrimitiveId>)((Object)serializable));
        if (VIEWPORT_FOLLOWING.get().booleanValue()) {
            mapView.smoothScrollTo(node.getEastNorth());
        }
        this.computeHelperLine();
        this.removeHighlighting();
    }

    private static String getTitle(boolean bl, Node node, Collection<OsmPrimitive> collection, List<Way> list, boolean bl2) {
        String string;
        if (!bl2) {
            if (list.isEmpty()) {
                string = I18n.tr("Add node", new Object[0]);
            } else {
                string = I18n.tr("Add node into way", new Object[0]);
                for (Way way : list) {
                    collection.remove(way);
                }
            }
            collection.clear();
            collection.add(node);
        } else {
            string = !bl ? I18n.tr("Connect existing way to node", new Object[0]) : (list.isEmpty() ? I18n.tr("Add a new node to an existing way", new Object[0]) : I18n.tr("Add node into way and connect", new Object[0]));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void insertNodeIntoAllNearbySegments(List<WaySegment> list, Node node, Collection<OsmPrimitive> collection, Collection<Command> collection2, List<Way> list2, List<Way> list3) {
        HashMap hashMap = new HashMap();
        for (WaySegment object : list) {
            void var10_11;
            if (hashMap.containsKey(object.way)) {
                List list4 = (List)hashMap.get(object.way);
            } else {
                ArrayList arrayList = new ArrayList();
                hashMap.put(object.way, arrayList);
            }
            var10_11.add(object.lowerIndex);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : hashMap.entrySet()) {
            Way way = (Way)entry.getKey();
            List list5 = (List)entry.getValue();
            Way way2 = new Way(way);
            DrawAction.pruneSuccsAndReverse(list5);
            Iterator iterator = list5.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                hashSet.add(Pair.sort(new Pair<Node, Node>(way.getNode(n), way.getNode(n + 1))));
                way2.addNode(n + 1, node);
            }
            if (this.alt) {
                collection.add((OsmPrimitive)entry.getKey());
            }
            collection2.add(new ChangeCommand((OsmPrimitive)entry.getKey(), way2));
            list2.add((Way)entry.getKey());
            list3.add(way2);
        }
        DrawAction.adjustNode(hashSet, node);
    }

    private boolean isSelfContainedWay(Way way, Node node, Node node2) {
        int n;
        if (way != null && ((n = way.getNodes().indexOf(node)) != -1 && n >= 1 && node2.equals(way.getNode(n - 1)) || n < way.getNodesCount() - 1 && node2.equals(way.getNode(n + 1)))) {
            this.getLayerManager().getEditDataSet().setSelected(node2);
            this.lastUsedNode = node2;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node node, Way way) {
        if (node == null && way == null) {
            return null;
        }
        if (node == null) {
            if (way.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (way == null) {
            return node;
        }
        if (way.isFirstLastNode(node)) {
            return node;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        if (this.snapHelper.isSnapOn() && this.ctrl) {
            this.tryToSetBaseSegmentForAngleSnap();
        }
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void tryToSetBaseSegmentForAngleSnap() {
        WaySegment waySegment;
        if (this.mousePos != null && (waySegment = MainApplication.getMap().mapView.getNearestWaySegment(this.mousePos, OsmPrimitive::isSelectable)) != null) {
            this.snapHelper.setBaseSegment(waySegment);
        }
    }

    private void computeHelperLine() {
        EastNorth eastNorth;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        MapView mapView = MainApplication.getMap().mapView;
        Node node = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        DrawAction.showStatusInfo(-1.0, -1.0, -1.0, this.snapHelper.isSnapOn());
        if (!this.ctrl && this.mousePos != null) {
            node = mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        }
        if (!this.ctrl && node == null) {
            List<WaySegment> list = mapView.getNearestWaySegments(this.mousePos, OsmPrimitive::isSelectable);
            for (WaySegment waySegment : list) {
                this.mouseOnExistingWays.add(waySegment.way);
            }
        }
        if (node != null) {
            if (collection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = node.getEastNorth();
            this.mouseOnExistingNode = node;
        } else {
            this.currentMouseEastNorth = mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        this.determineCurrentBaseNodeAndPreviousNode(collection);
        if (this.previousNode == null) {
            this.snapHelper.noSnapNow();
        }
        if (this.getCurrentBaseNode() == null || this.getCurrentBaseNode() == node) {
            return;
        }
        double d = Utils.toDegrees(this.getCurrentBaseNode().getEastNorth().heading(this.currentMouseEastNorth));
        double d2 = -1.0;
        if (this.previousNode != null && (eastNorth = this.previousNode.getEastNorth()) != null) {
            d2 = Utils.toDegrees(eastNorth.heading(this.getCurrentBaseNode().getEastNorth()));
        }
        this.snapHelper.checkAngleSnapping(this.currentMouseEastNorth, d2, d);
    }

    static void showStatusInfo(double d, double d2, double d3, boolean bl) {
        MapFrame mapFrame = MainApplication.getMap();
        mapFrame.statusLine.setAngle(d);
        mapFrame.statusLine.activateAnglePanel(bl);
        mapFrame.statusLine.setHeading(d2);
        mapFrame.statusLine.setDist(d3);
    }

    private void determineCurrentBaseNodeAndPreviousNode(Collection<OsmPrimitive> collection) {
        Node node = null;
        AbstractPrimitive abstractPrimitive = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                if (node != null) {
                    return;
                }
                node = (Node)osmPrimitive;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            if (abstractPrimitive != null) {
                return;
            }
            abstractPrimitive = (Way)osmPrimitive;
        }
        this.currentBaseNode = null;
        this.previousNode = null;
        if (abstractPrimitive == null && node != null) {
            for (OsmPrimitive osmPrimitive : node.getReferrers()) {
                if (!osmPrimitive.isUsable() || !(osmPrimitive instanceof Way) || !((Way)osmPrimitive).isFirstLastNode(node)) continue;
                if (abstractPrimitive != null) {
                    abstractPrimitive = null;
                    break;
                }
                abstractPrimitive = (Way)osmPrimitive;
            }
        }
        if (node == null) {
            if (abstractPrimitive == null) {
                return;
            }
            this.continueWayFromNode((Way)abstractPrimitive, this.lastUsedNode);
        } else if (abstractPrimitive == null) {
            this.currentBaseNode = node;
        } else if (!abstractPrimitive.isDeleted()) {
            this.continueWayFromNode((Way)abstractPrimitive, node);
        }
    }

    private void continueWayFromNode(Way way, Node node) {
        int n = way.getNodesCount();
        if (node == way.firstNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(1);
            }
        } else if (node == way.lastNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(n - 2);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        this.snapHelper.noSnapNow();
        boolean bl = this.removeHighlighting();
        if (!bl) {
            osmDataLayer.invalidate();
        }
    }

    public static Way getWayForNode(Node node) {
        Way way = null;
        for (Way way2 : Utils.filteredCollection(node.getReferrers(), Way.class)) {
            if (!way2.isUsable() || way2.getNodesCount() < 1) continue;
            Node node2 = way2.getNode(0);
            Node node3 = way2.getNode(way2.getNodesCount() - 1);
            if (node2 != node && node3 != node || node2 == node3) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    public Node getCurrentBaseNode() {
        if (!(this.currentBaseNode == null || this.currentBaseNode.getDataSet() != null && this.currentBaseNode.isUsable())) {
            this.currentBaseNode = null;
        }
        return this.currentBaseNode;
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> collection, Node node) {
        switch (collection.size()) {
            case 0: {
                return;
            }
            case 2: {
                DrawAction.adjustNodeTwoSegments(collection, node);
                break;
            }
            default: {
                DrawAction.adjustNodeDefault(collection, node);
            }
        }
    }

    private static void adjustNodeTwoSegments(Collection<Pair<Node, Node>> collection, Node node) {
        Iterator<Pair<Node, Node>> iterator = collection.iterator();
        Pair<Node, Node> pair = iterator.next();
        EastNorth eastNorth = ((Node)pair.a).getEastNorth();
        EastNorth eastNorth2 = ((Node)pair.b).getEastNorth();
        pair = iterator.next();
        EastNorth eastNorth3 = ((Node)pair.a).getEastNorth();
        EastNorth eastNorth4 = ((Node)pair.b).getEastNorth();
        double d = DrawAction.det(eastNorth2.east() - eastNorth.east(), eastNorth2.north() - eastNorth.north(), eastNorth3.east() - eastNorth4.east(), eastNorth3.north() - eastNorth4.north());
        if (d == 0.0) {
            return;
        }
        double d2 = DrawAction.det(eastNorth2.north() - eastNorth3.north(), eastNorth2.east() - eastNorth3.east(), eastNorth4.north() - eastNorth3.north(), eastNorth4.east() - eastNorth3.east()) / d;
        EastNorth eastNorth5 = new EastNorth(eastNorth2.east() + d2 * (eastNorth.east() - eastNorth2.east()), eastNorth2.north() + d2 * (eastNorth.north() - eastNorth2.north()));
        MapFrame mapFrame = MainApplication.getMap();
        if (mapFrame.mapView.getPoint2D(node).distance(mapFrame.mapView.getPoint2D(eastNorth5)) < SNAP_TO_INTERSECTION_THRESHOLD.get()) {
            node.setEastNorth(eastNorth5);
            return;
        }
        DrawAction.adjustNodeDefault(collection, node);
    }

    private static void adjustNodeDefault(Collection<Pair<Node, Node>> collection, Node node) {
        EastNorth eastNorth = node.getEastNorth();
        Pair<Node, Node> pair = collection.iterator().next();
        EastNorth eastNorth2 = ((Node)pair.a).getEastNorth();
        EastNorth eastNorth3 = ((Node)pair.b).getEastNorth();
        double d = eastNorth.distanceSq(eastNorth3);
        double d2 = eastNorth.distanceSq(eastNorth2);
        double d3 = eastNorth2.distanceSq(eastNorth3);
        double d4 = (d - d2 + d3) / (2.0 * d3);
        node.setEastNorth(new EastNorth(eastNorth3.east() + d4 * (eastNorth2.east() - eastNorth3.east()), eastNorth3.north() + d4 * (eastNorth2.north() - eastNorth3.north())));
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    private void tryToMoveNodeOnIntersection(List<WaySegment> list, Node node) {
        EastNorth eastNorth;
        if (list.isEmpty()) {
            return;
        }
        WaySegment waySegment = list.get(0);
        EastNorth eastNorth2 = waySegment.getFirstNode().getEastNorth();
        EastNorth eastNorth3 = waySegment.getSecondNode().getEastNorth();
        if (this.snapHelper.dir2 != null && this.getCurrentBaseNode() != null && (eastNorth = Geometry.getSegmentSegmentIntersection(eastNorth2, eastNorth3, this.snapHelper.dir2, this.getCurrentBaseNode().getEastNorth())) != null) {
            node.setEastNorth(eastNorth);
        }
    }

    private void addHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        MapView mapView = MainApplication.getMap().mapView;
        if (this.ctrl) {
            mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingNode == null && this.mousePos != null && this.getLayerManager().getEditDataSet().selectionEmpty()) {
            this.mouseOnExistingNode = mapView.getNearestNode(this.mousePos, OsmPrimitive::isSelectable);
        }
        if (this.mouseOnExistingNode != null) {
            mapView.setNewCursor(this.cursorJoinNode, (Object)this);
            this.newHighlights.add(this.mouseOnExistingNode);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingWays.isEmpty()) {
            mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        mapView.setNewCursor(this.cursorJoinWay, (Object)this);
        this.newHighlights.addAll(this.mouseOnExistingWays);
        this.redrawIfRequired();
    }

    private boolean removeHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        return this.redrawIfRequired();
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        MapView mapView2 = MainApplication.getMap().mapView;
        if (mapView2 == null || this.mousePos == null || this.currentMouseEastNorth == null || this.getCurrentBaseNode() == null || !mapView2.getState().getForView(this.mousePos.getX(), this.mousePos.getY()).isInView()) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D;
        this.snapHelper.drawIfNeeded(graphics2D2, mapView.getState());
        if (!DRAW_HELPER_LINE.get().booleanValue() || this.wayIsFinished || this.shift) {
            return;
        }
        if (!this.snapHelper.isActive()) {
            graphics2D2.setColor(RUBBER_LINE_COLOR.get());
            graphics2D2.setStroke(RUBBER_LINE_STROKE.get());
            this.paintConstructionGeometry(mapView, graphics2D2);
        } else if (DRAW_CONSTRUCTION_GEOMETRY.get().booleanValue()) {
            this.paintConstructionGeometry(mapView, graphics2D2);
        }
    }

    private void paintConstructionGeometry(MapView mapView, Graphics2D graphics2D) {
        MapPath2D mapPath2D = new MapPath2D();
        MapViewState.MapViewPoint mapViewPoint = mapView.getState().getPointFor(this.getCurrentBaseNode());
        MapViewState.MapViewPoint mapViewPoint2 = mapView.getState().getPointFor(this.currentMouseEastNorth);
        mapPath2D.moveTo(mapViewPoint);
        mapPath2D.lineTo(mapViewPoint2);
        if (this.alt) {
            START_WAY_INDICATOR.paintArrowAt(mapPath2D, mapViewPoint, mapViewPoint2);
        }
        graphics2D.draw(mapPath2D);
        graphics2D.setStroke(BASIC_STROKE);
    }

    @Override
    public String getModeHelpText() {
        OsmPrimitive osmPrimitive;
        StringBuilder stringBuilder = this.ctrl || this.oldHighlights.isEmpty() ? new StringBuilder(I18n.tr("Create new node.", new Object[0])) : ((osmPrimitive = this.oldHighlights.iterator().next()) instanceof Node ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size())));
        if (!this.wayIsFinished && this.getCurrentBaseNode() != null) {
            if (this.alt) {
                stringBuilder.append(' ').append(I18n.tr("Start new way from last node.", new Object[0]));
            } else {
                stringBuilder.append(' ').append(I18n.tr("Continue way from last node.", new Object[0]));
            }
            if (this.snapHelper.isSnapOn()) {
                stringBuilder.append(' ').append(I18n.tr("Angle snapping active.", new Object[0]));
            }
        }
        osmPrimitive = this.mouseOnExistingNode;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (osmPrimitive != null && dataSet != null && dataSet.getSelectedNodes().contains(osmPrimitive)) {
            stringBuilder = this.wayIsFinished ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.tr("Finish drawing.", new Object[0]));
        }
        if (!(dataSet == null || dataSet.getSelectedWays().isEmpty() || this.wayIsFinished || this.alt)) {
            Way way = dataSet.getSelectedWays().iterator().next();
            for (Node node : way.getNodes()) {
                if (!node.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(way)) continue;
                stringBuilder.append(' ').append(I18n.tr("Finish drawing.", new Object[0]));
                break;
            }
        }
        return stringBuilder.toString();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        Way way;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return null;
        }
        if (this.getCurrentBaseNode() != null && !dataSet.selectionEmpty() && (way = DrawAction.getWayForNode(this.getCurrentBaseNode())) != null) {
            return Collections.singleton(way);
        }
        return dataSet.getSelected();
    }

    @Override
    public Collection<? extends OsmPrimitive> getPreservedPrimitives() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        return dataSet != null ? dataSet.getSelected() : Collections.emptySet();
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.snapChangeAction.destroy();
    }

    private class SnapChangeAction
    extends JosmAction {
        SnapChangeAction() {
            super(I18n.tr("Angle snapping", new Object[0]), "anglesnap", I18n.tr("Switch angle snapping mode while drawing", new Object[0]), null, false);
            this.putValue("help", HelpUtil.ht("/Action/Draw/AngleSnap"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DrawAction.this.snapHelper != null) {
                DrawAction.this.snapHelper.toggleSnapping();
            }
        }

        @Override
        protected void updateEnabledState() {
            MapFrame mapFrame = MainApplication.getMap();
            this.setEnabled(mapFrame != null && mapFrame.mapMode instanceof DrawAction);
        }
    }

    public class BackSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainApplication.undoRedo.undo();
            Command command = MainApplication.undoRedo.getLastCommand();
            if (command == null) {
                return;
            }
            Node node = null;
            for (OsmPrimitive osmPrimitive : command.getParticipatingPrimitives()) {
                if (!(osmPrimitive instanceof Node)) continue;
                if (node == null) {
                    node = (Node)osmPrimitive;
                    DrawAction.this.wayIsFinished = false;
                    continue;
                }
                node = null;
                break;
            }
            if (node != null) {
                DrawAction.this.getLayerManager().getEditDataSet().addSelected(node);
            }
        }
    }
}

