/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class ImmutableGpxTrack
extends WithAttributes
implements GpxTrack {
    private final List<GpxTrackSegment> segments;
    private final double length;
    private final Bounds bounds;

    public ImmutableGpxTrack(Collection<Collection<WayPoint>> collection, Map<String, Object> map) {
        ArrayList<ImmutableGpxTrackSegment> arrayList = new ArrayList<ImmutableGpxTrackSegment>();
        for (Collection<WayPoint> collection2 : collection) {
            if (collection2 == null || collection2.isEmpty()) continue;
            arrayList.add(new ImmutableGpxTrackSegment(collection2));
        }
        this.attr = Collections.unmodifiableMap(new HashMap<String, Object>(map));
        this.segments = Collections.unmodifiableList(arrayList);
        this.length = this.calculateLength();
        this.bounds = this.calculateBounds();
    }

    private double calculateLength() {
        double d = 0.0;
        for (GpxTrackSegment gpxTrackSegment : this.segments) {
            d += gpxTrackSegment.length();
        }
        return d;
    }

    private Bounds calculateBounds() {
        Bounds bounds = null;
        for (GpxTrackSegment gpxTrackSegment : this.segments) {
            Bounds bounds2 = gpxTrackSegment.getBounds();
            if (bounds2 == null) continue;
            if (bounds == null) {
                bounds = new Bounds(bounds2);
                continue;
            }
            bounds.extend(bounds2);
        }
        return bounds;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attr;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds == null ? null : new Bounds(this.bounds);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public Collection<GpxTrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.segments == null ? 0 : this.segments.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutableGpxTrack immutableGpxTrack = (ImmutableGpxTrack)object;
        return !(this.segments == null ? immutableGpxTrack.segments != null : !this.segments.equals(immutableGpxTrack.segments));
    }
}

