/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class NoteSortDialog
extends ExtendedDialog {
    private final JRadioButton defaultSort = new JRadioButton(I18n.tr("Default (open, closed, new)", new Object[0]));
    private final JRadioButton userSort = new JRadioButton(I18n.tr("Username", new Object[0]));
    private final JRadioButton dateSort = new JRadioButton(I18n.tr("Created date", new Object[0]));
    private final JRadioButton lastActionSort = new JRadioButton(I18n.tr("Last change date", new Object[0]));

    public NoteSortDialog(Component component, String string, String string2) {
        super(component, string, string2, I18n.tr("Cancel", new Object[0]));
    }

    public void showSortDialog(Comparator<Note> comparator) {
        JLabel jLabel = new JLabel(I18n.tr("Select note sorting method", new Object[0]));
        if (comparator == Note.DEFAULT_COMPARATOR) {
            this.defaultSort.setSelected(true);
        } else if (comparator == Note.DATE_COMPARATOR) {
            this.dateSort.setSelected(true);
        } else if (comparator == Note.USER_COMPARATOR) {
            this.userSort.setSelected(true);
        } else if (comparator == Note.LAST_ACTION_COMPARATOR) {
            this.lastActionSort.setSelected(true);
        } else {
            Logging.warn("sort mode not recognized");
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultSort);
        buttonGroup.add(this.userSort);
        buttonGroup.add(this.dateSort);
        buttonGroup.add(this.lastActionSort);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(this.defaultSort);
        jPanel.add(this.userSort);
        jPanel.add(this.dateSort);
        jPanel.add(this.lastActionSort);
        this.setContent(jPanel);
        this.showDialog();
    }

    public Comparator<Note> getSelectedComparator() {
        if (this.dateSort.isSelected()) {
            return Note.DATE_COMPARATOR;
        }
        if (this.userSort.isSelected()) {
            return Note.USER_COMPARATOR;
        }
        if (this.lastActionSort.isSelected()) {
            return Note.LAST_ACTION_COMPARATOR;
        }
        return Note.DEFAULT_COMPARATOR;
    }
}

