/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractMergePanel
extends JPanel {
    protected int currentRow;

    public AbstractMergePanel() {
        super(new GridBagLayout());
    }

    protected void buildRows() {
        this.getRows().forEach(mergeRow -> mergeRow.addTo(this));
    }

    protected abstract List<? extends MergeRow> getRows();

    protected static abstract class AbstractUndecideRow
    extends MergeRow {
        protected AbstractUndecideRow() {
        }

        @Override
        protected JComponent merged() {
            AbstractAction abstractAction = this.createAction();
            JButton jButton = new JButton(abstractAction);
            jButton.setName(this.getButtonName());
            return jButton;
        }

        protected abstract AbstractAction createAction();

        protected abstract String getButtonName();

        @Override
        protected void addConstraints(GBC gBC, int n) {
            super.addConstraints(gBC, n);
            gBC.fill(0);
        }
    }

    protected static class TitleRow
    extends MergeRow {
        @Override
        protected JComponent mineField() {
            JLabel jLabel = new JLabel(I18n.tr("My version (local dataset)", new Object[0]));
            jLabel.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset", new Object[0]));
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }

        @Override
        protected JComponent merged() {
            JLabel jLabel = new JLabel(I18n.tr("Merged version", new Object[0]));
            jLabel.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied.", new Object[0]));
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }

        @Override
        protected JComponent theirsField() {
            JLabel jLabel = new JLabel(I18n.tr("Their version (server dataset)", new Object[0]));
            jLabel.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset", new Object[0]));
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    protected static class MergeRowWithoutButton
    extends MergeRow {
        protected MergeRowWithoutButton() {
        }

        @Override
        protected JComponent[] getColumns() {
            return new JComponent[]{this.rowTitle(), this.mineField(), null, this.merged(), this.theirsField(), null};
        }

        @Override
        protected void addConstraints(GBC gBC, int n) {
            super.addConstraints(gBC, n);
            if (n == 1 || n == 4) {
                gBC.gridwidth = 2;
            }
        }
    }

    protected static class MergeRow {
        protected int marginTop = 5;

        protected JComponent rowTitle() {
            return null;
        }

        protected JComponent mineField() {
            return null;
        }

        protected JComponent mineButton() {
            return null;
        }

        protected JComponent merged() {
            return null;
        }

        protected JComponent theirsButton() {
            return null;
        }

        protected JComponent theirsField() {
            return null;
        }

        void addTo(AbstractMergePanel abstractMergePanel) {
            JComponent[] jComponentArray = this.getColumns();
            for (int i = 0; i < jComponentArray.length; ++i) {
                if (jComponentArray[i] == null) continue;
                GBC gBC = GBC.std(i, abstractMergePanel.currentRow);
                this.addConstraints(gBC, i);
                abstractMergePanel.add((Component)jComponentArray[i], gBC);
            }
            ++abstractMergePanel.currentRow;
        }

        protected JComponent[] getColumns() {
            return new JComponent[]{this.rowTitle(), this.mineField(), this.mineButton(), this.merged(), this.theirsButton(), this.theirsField()};
        }

        protected void addConstraints(GBC gBC, int n) {
            gBC.anchor(10);
            gBC.fill = 1;
            gBC.weight(0.0, 0.0);
            gBC.insets(3, this.marginTop, 3, 0);
            if (n == 1 || n == 3 || n == 5) {
                gBC.weightx = 1.0;
            }
        }
    }
}

