/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.BookmarkSelection;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.DownloadSourceSizingPolicy;
import org.openstreetmap.josm.gui.download.OSMDownloadSource;
import org.openstreetmap.josm.gui.download.OverpassDownloadSource;
import org.openstreetmap.josm.gui.download.PlaceSelection;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.TileSelection;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class DownloadDialog
extends JDialog {
    private static final IntegerProperty DOWNLOAD_TAB = new IntegerProperty("download.tab", 0);
    private static final StringProperty DOWNLOAD_SOURCE_TAB = new StringProperty("download.source.tab", "osmdownloadpanel");
    private static final BooleanProperty DOWNLOAD_AUTORUN = new BooleanProperty("download.autorun", false);
    private static final BooleanProperty DOWNLOAD_NEWLAYER = new BooleanProperty("download.newlayer", false);
    private static final BooleanProperty DOWNLOAD_ZOOMTODATA = new BooleanProperty("download.zoomtodata", true);
    private static DownloadDialog instance;
    protected final transient List<DownloadSource<?>> downloadSources = new ArrayList();
    protected final transient List<DownloadSelection> downloadSelections = new ArrayList<DownloadSelection>();
    protected final JTabbedPane tpDownloadAreaSelectors = new JTabbedPane();
    protected final DownloadSourceTabs downloadSourcesTab = new DownloadSourceTabs();
    protected JCheckBox cbNewLayer;
    protected JCheckBox cbStartup;
    protected JCheckBox cbZoomToDownloadedData;
    protected SlippyMapChooser slippyMapChooser;
    protected JPanel mainPanel;
    protected DownloadDialogSplitPane dialogSplit;
    protected final transient ExpertToggleAction.ExpertModeChangeListener expertListener = this.getExpertModeListenerForDownloadSources();
    protected transient Bounds currentBounds;
    protected boolean canceled;
    protected JButton btnDownload;
    protected JButton btnCancel;
    protected JButton btnHelp;

    public static synchronized DownloadDialog getInstance() {
        if (instance == null) {
            instance = new DownloadDialog(Main.parent);
        }
        return instance;
    }

    protected final JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.addDownloadSource(new OSMDownloadSource());
        this.addDownloadSource(new OverpassDownloadSource());
        this.slippyMapChooser = new SlippyMapChooser();
        this.downloadSelections.add(this.slippyMapChooser);
        this.downloadSelections.add(new BookmarkSelection());
        this.downloadSelections.add(new BoundingBoxSelection());
        this.downloadSelections.add(new PlaceSelection());
        this.downloadSelections.add(new TileSelection());
        PluginHandler.addDownloadSelection(this.downloadSelections);
        for (DownloadSelection object2 : this.downloadSelections) {
            object2.addGui(this);
        }
        this.downloadSourcesTab.setMinimumSize(new Dimension(0, 25));
        this.tpDownloadAreaSelectors.setMinimumSize(new Dimension(0, 0));
        this.dialogSplit = new DownloadDialogSplitPane(this.downloadSourcesTab, this.tpDownloadAreaSelectors);
        ChangeListener changeListener = this.getDownloadSourceTabChangeListener();
        changeListener.stateChanged(new ChangeEvent(this.downloadSourcesTab));
        this.downloadSourcesTab.addChangeListener(changeListener);
        this.mainPanel.add((Component)this.dialogSplit, GBC.eol().fill());
        this.cbNewLayer = new JCheckBox(I18n.tr("Download as new layer", new Object[0]));
        this.cbNewLayer.setToolTipText(I18n.tr("<html>Select to download data into a new data layer.<br>Unselect to download into the currently active data layer.</html>", new Object[0]));
        this.cbStartup = new JCheckBox(I18n.tr("Open this dialog on startup", new Object[0]));
        this.cbStartup.setToolTipText(I18n.tr("<html>Autostart ''Download from OSM'' dialog every time JOSM is started.<br>You can open it manually from File menu or toolbar.</html>", new Object[0]));
        this.cbStartup.addActionListener(actionEvent -> DOWNLOAD_AUTORUN.put(this.cbStartup.isSelected()));
        this.cbZoomToDownloadedData = new JCheckBox(I18n.tr("Zoom to downloaded data", new Object[0]));
        this.cbZoomToDownloadedData.setToolTipText(I18n.tr("Select to zoom to entire newly downloaded data.", new Object[0]));
        this.mainPanel.add((Component)this.cbNewLayer, GBC.std().anchor(17).insets(5, 5, 5, 5));
        this.mainPanel.add((Component)this.cbStartup, GBC.std().anchor(17).insets(15, 5, 5, 5));
        this.mainPanel.add((Component)this.cbZoomToDownloadedData, GBC.std().anchor(17).insets(15, 5, 5, 5));
        ExpertToggleAction.addVisibilitySwitcher(this.cbZoomToDownloadedData);
        this.mainPanel.add((Component)new JLabel(), GBC.eol());
        JLabel jLabel = new JLabel(I18n.tr("Use left click&drag to select area, arrows or right mouse button to scroll map, wheel or +/- to zoom.", new Object[0]));
        this.mainPanel.add((Component)jLabel, GBC.eol().anchor(10).insets(0, 0, 0, 0));
        ExpertToggleAction.addExpertModeChangeListener(bl -> jLabel.setVisible(!bl), true);
        return this.mainPanel;
    }

    protected final JPanel buildButtonPanel() {
        this.btnDownload = new JButton(new DownloadAction());
        this.btnCancel = new JButton(new CancelAction());
        this.btnHelp = new JButton(new ContextSensitiveHelpAction(this.getRootPane().getClientProperty("help").toString()));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.btnDownload);
        jPanel.add(this.btnCancel);
        jPanel.add(this.btnHelp);
        InputMapUtils.enableEnter(this.btnDownload);
        InputMapUtils.enableEnter(this.btnCancel);
        InputMapUtils.addEscapeAction(this.getRootPane(), this.btnCancel.getAction());
        InputMapUtils.enableEnter(this.btnHelp);
        InputMapUtils.addEnterActionWhenAncestor(this.cbNewLayer, this.btnDownload.getAction());
        InputMapUtils.addEnterActionWhenAncestor(this.cbStartup, this.btnDownload.getAction());
        InputMapUtils.addEnterActionWhenAncestor(this.cbZoomToDownloadedData, this.btnDownload.getAction());
        return jPanel;
    }

    public DownloadDialog(Component component) {
        this(component, HelpUtil.ht("/Action/Download"));
    }

    public DownloadDialog(Component component, String string) {
        super((Window)GuiHelper.getFrameForComponent(component), I18n.tr("Download", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        HelpUtil.setHelpContext(this.getRootPane(), string);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(86, 128), "checkClipboardContents");
        this.getRootPane().getActionMap().put("checkClipboardContents", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ClipboardUtils.getClipboardStringContent();
                if (string == null) {
                    return;
                }
                Bounds bounds = OsmUrlToBounds.parse(string);
                if (bounds != null) {
                    DownloadDialog.this.boundingBoxChanged(new Bounds(bounds), null);
                }
            }
        });
        this.addWindowListener(new WindowEventHandler());
        ExpertToggleAction.addExpertModeChangeListener(this.expertListener);
        this.restoreSettings();
        if (this.currentBounds == null) {
            this.boundingBoxChanged(null, null);
        }
    }

    public void boundingBoxChanged(Bounds bounds, DownloadSelection downloadSelection) {
        this.currentBounds = bounds;
        for (DownloadSelection object : this.downloadSelections) {
            if (object == downloadSelection) continue;
            object.setDownloadArea(this.currentBounds);
        }
        for (AbstractDownloadSourcePanel abstractDownloadSourcePanel : this.downloadSourcesTab.getAllPanels()) {
            abstractDownloadSourcePanel.boudingBoxChanged(bounds);
        }
    }

    public void startDownload(Bounds bounds) {
        this.currentBounds = bounds;
        this.startDownload();
    }

    public void startDownload() {
        this.btnDownload.doClick();
    }

    public boolean isNewLayerRequired() {
        return this.cbNewLayer.isSelected();
    }

    public boolean isZoomToDownloadedDataRequired() {
        return this.cbZoomToDownloadedData.isSelected();
    }

    public static boolean isAutorunEnabled() {
        return DOWNLOAD_AUTORUN.get();
    }

    public void addDownloadAreaSelector(JPanel jPanel, String string) {
        this.tpDownloadAreaSelectors.add(string, jPanel);
    }

    public <T> void addDownloadSource(DownloadSource<T> downloadSource) {
        if (this.downloadSources.contains(downloadSource)) {
            throw new JosmRuntimeException("The download source you are trying to add already exists.");
        }
        this.downloadSources.add(downloadSource);
        this.addNewDownloadSourceTab(downloadSource);
    }

    public final void refreshTileSources() {
        if (this.slippyMapChooser != null) {
            this.slippyMapChooser.refreshTileSources();
        }
    }

    public void rememberSettings() {
        DOWNLOAD_TAB.put(this.tpDownloadAreaSelectors.getSelectedIndex());
        this.downloadSourcesTab.getSelectedPanel().ifPresent(abstractDownloadSourcePanel -> DOWNLOAD_SOURCE_TAB.put(abstractDownloadSourcePanel.getSimpleName()));
        DOWNLOAD_NEWLAYER.put(this.cbNewLayer.isSelected());
        DOWNLOAD_ZOOMTODATA.put(this.cbZoomToDownloadedData.isSelected());
        if (this.currentBounds != null) {
            Main.pref.put("osm-download.bounds", this.currentBounds.encodeAsString(";"));
        }
    }

    public void restoreSettings() {
        this.cbNewLayer.setSelected(DOWNLOAD_NEWLAYER.get());
        this.cbStartup.setSelected(DownloadDialog.isAutorunEnabled());
        this.cbZoomToDownloadedData.setSelected(DOWNLOAD_ZOOMTODATA.get());
        try {
            this.tpDownloadAreaSelectors.setSelectedIndex(DOWNLOAD_TAB.get());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logging.trace(indexOutOfBoundsException);
            this.tpDownloadAreaSelectors.setSelectedIndex(0);
        }
        this.downloadSourcesTab.setSelected(DOWNLOAD_SOURCE_TAB.get());
        if (MainApplication.isDisplayingMapView()) {
            MapView mapView = MainApplication.getMap().mapView;
            this.currentBounds = new Bounds(mapView.getLatLon(0, mapView.getHeight()), mapView.getLatLon(mapView.getWidth(), 0));
            this.boundingBoxChanged(this.currentBounds, null);
        } else {
            Bounds bounds = DownloadDialog.getSavedDownloadBounds();
            if (bounds != null) {
                this.currentBounds = bounds;
                this.boundingBoxChanged(this.currentBounds, null);
            }
        }
    }

    public static Bounds getSavedDownloadBounds() {
        String string = Main.pref.get("osm-download.bounds");
        if (!string.isEmpty()) {
            try {
                return new Bounds(string, ";");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.warn(illegalArgumentException);
            }
        }
        return null;
    }

    public static void autostartIfNeeded() {
        if (DownloadDialog.isAutorunEnabled()) {
            MainApplication.getMenu().download.actionPerformed(null);
        }
    }

    public Optional<Bounds> getSelectedDownloadArea() {
        return Optional.ofNullable(this.currentBounds);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public DownloadSettings getDownloadSettings() {
        return new DownloadSettings(this.currentBounds, this.isNewLayerRequired(), this.isZoomToDownloadedDataRequired());
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    protected <T> void addNewDownloadSourceTab(DownloadSource<T> downloadSource) {
        this.downloadSourcesTab.addPanel(downloadSource.createPanel());
    }

    private ExpertToggleAction.ExpertModeChangeListener getExpertModeListenerForDownloadSources() {
        return this.downloadSourcesTab::updateExpert;
    }

    private ChangeListener getDownloadSourceTabChangeListener() {
        return changeEvent -> this.downloadSourcesTab.getSelectedPanel().ifPresent(abstractDownloadSourcePanel -> this.dialogSplit.setPolicy(abstractDownloadSourcePanel.getSizingPolicy()));
    }

    private static class DownloadDialogSplitPane
    extends JSplitPane {
        private DownloadSourceSizingPolicy policy;
        private JTabbedPane topComponent;

        DownloadDialogSplitPane(JTabbedPane jTabbedPane, Component component) {
            super(0, jTabbedPane, component);
            this.topComponent = jTabbedPane;
        }

        public void setPolicy(DownloadSourceSizingPolicy downloadSourceSizingPolicy) {
            this.policy = downloadSourceSizingPolicy;
            super.setDividerLocation(downloadSourceSizingPolicy.getComponentHeight() + this.computeOffset());
            this.setDividerSize(downloadSourceSizingPolicy.isHeightAdjustable() ? 10 : 0);
            this.setEnabled(downloadSourceSizingPolicy.isHeightAdjustable());
        }

        @Override
        public void doLayout() {
            int n = this.computeOffset();
            if (this.policy.isHeightAdjustable()) {
                this.policy.storeHeight(Math.max(this.getDividerLocation() - n, 0));
            }
            super.setDividerLocation(this.policy.getComponentHeight() + n);
            super.doLayout();
        }

        private int computeOffset() {
            Component component = this.topComponent.getSelectedComponent();
            return this.topComponent.getHeight() - (component == null ? 0 : component.getHeight());
        }
    }

    private static class DownloadSourceTabs
    extends JTabbedPane {
        private final List<AbstractDownloadSourcePanel<?>> allPanels = new ArrayList();

        private DownloadSourceTabs() {
        }

        List<AbstractDownloadSourcePanel<?>> getAllPanels() {
            return this.allPanels;
        }

        List<AbstractDownloadSourcePanel<?>> getVisiblePanels() {
            return IntStream.range(0, this.getTabCount()).mapToObj(this::getComponentAt).map(component -> (AbstractDownloadSourcePanel)component).collect(Collectors.toList());
        }

        void setSelected(String string) {
            this.getVisiblePanels().stream().filter(abstractDownloadSourcePanel -> string.equals(abstractDownloadSourcePanel.getSimpleName())).findFirst().ifPresent(this::setSelectedComponent);
        }

        void updateExpert(boolean bl) {
            this.updateTabs();
        }

        void addPanel(AbstractDownloadSourcePanel<?> abstractDownloadSourcePanel) {
            this.allPanels.add(abstractDownloadSourcePanel);
            this.updateTabs();
        }

        private void updateTabs() {
            this.removeAll();
            boolean bl = ExpertToggleAction.isExpert();
            this.allPanels.stream().filter(abstractDownloadSourcePanel -> bl || !abstractDownloadSourcePanel.getDownloadSource().onlyExpert()).forEach(abstractDownloadSourcePanel -> this.addTab(abstractDownloadSourcePanel.getDownloadSource().getLabel(), abstractDownloadSourcePanel.getIcon(), (Component)abstractDownloadSourcePanel));
        }

        Optional<AbstractDownloadSourcePanel<?>> getSelectedPanel() {
            return Optional.ofNullable((AbstractDownloadSourcePanel)this.getSelectedComponent());
        }

        @Override
        public void insertTab(String string, Icon icon, Component component, String string2, int n) {
            if (!(component instanceof AbstractDownloadSourcePanel)) {
                throw new IllegalArgumentException("Can only add AbstractDownloadSourcePanels");
            }
            super.insertTab(string, icon, component, string2, n);
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().run();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DownloadDialog.this.btnDownload.requestFocusInWindow();
        }
    }

    class DownloadAction
    extends AbstractAction {
        DownloadAction() {
            this.putValue("Name", I18n.tr("Download", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to download the currently selected area", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        public void run() {
            DownloadDialog.this.rememberSettings();
            DownloadDialog.this.downloadSourcesTab.getSelectedPanel().ifPresent(abstractDownloadSourcePanel -> {
                DownloadSettings downloadSettings = DownloadDialog.this.getDownloadSettings();
                if (abstractDownloadSourcePanel.checkDownload(downloadSettings)) {
                    DownloadDialog.this.setCanceled(false);
                    DownloadDialog.this.setVisible(false);
                    abstractDownloadSourcePanel.triggerDownload(downloadSettings);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort downloading", new Object[0]));
        }

        public void run() {
            DownloadDialog.this.rememberSettings();
            DownloadDialog.this.setCanceled(true);
            DownloadDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Optional<AbstractDownloadSourcePanel<?>> optional = DownloadDialog.this.downloadSourcesTab.getSelectedPanel();
            this.run();
            optional.ifPresent(AbstractDownloadSourcePanel::checkCancel);
        }
    }
}

