/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.I18n;

public class AutoZoomAction
extends AbstractAction
implements Layer.LayerAction {
    private final AbstractTileSourceLayer<?> layer;

    public AutoZoomAction(AbstractTileSourceLayer<?> abstractTileSourceLayer) {
        super(I18n.tr("Auto zoom", new Object[0]));
        this.layer = abstractTileSourceLayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TileSourceDisplaySettings tileSourceDisplaySettings;
        tileSourceDisplaySettings.setAutoZoom(!(tileSourceDisplaySettings = this.layer.getDisplaySettings()).isAutoZoom());
    }

    @Override
    public Component createMenuComponent() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
        jCheckBoxMenuItem.setSelected(this.layer.getDisplaySettings().isAutoZoom());
        return jCheckBoxMenuItem;
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return AbstractTileSourceLayer.actionSupportLayers(list);
    }
}

