/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.text.View;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;

public class JMultilineLabel
extends JEditorPane {
    private int maxWidth = Integer.MAX_VALUE;
    private Rectangle oldbounds;
    private Dimension oldPreferred;

    public JMultilineLabel(String string) {
        this(string, false);
    }

    public JMultilineLabel(String string, boolean bl) {
        JosmEditorPane.makeJLabelLike(this, bl);
        String string2 = string.trim().replaceAll("\n", "<br>");
        if (!string2.startsWith("<html>")) {
            string2 = "<html>" + string2 + "</html>";
        }
        this.setFocusable(false);
        super.setText(string2);
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.oldPreferred != null && this.getBounds().equals(this.oldbounds)) {
            return this.oldPreferred;
        }
        this.oldbounds = this.getBounds();
        Dimension dimension = super.getPreferredSize();
        int n = Math.min(dimension.width, this.maxWidth);
        View view = (View)super.getClientProperty("html");
        if (view == null) {
            return dimension;
        }
        view.setSize(n, 0.0f);
        int n2 = (int)Math.ceil(view.getPreferredSpan(0));
        int n3 = (int)Math.ceil(view.getPreferredSpan(1));
        this.oldPreferred = new Dimension(n2, n3);
        return this.oldPreferred;
    }
}

