/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.NameFinder;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public class OverpassDownloadReader
extends BoundingBoxDownloader {
    private static final String DATA_PREFIX = "?data=";
    static final Pattern OUTPUT_FORMAT_STATEMENT = Pattern.compile(".*\\[out:([a-z]{3,})\\].*", 32);
    static final Map<OverpassOutpoutFormat, Class<? extends AbstractReader>> outputFormatReaders = new ConcurrentHashMap<OverpassOutpoutFormat, Class<? extends AbstractReader>>();
    final String overpassServer;
    final String overpassQuery;

    public OverpassDownloadReader(Bounds bounds, String string, String string2) {
        super(bounds);
        this.setDoAuthenticate(false);
        this.overpassServer = string;
        this.overpassQuery = string2.trim();
    }

    public static final Class<? extends AbstractReader> registerOverpassOutpoutFormatReader(OverpassOutpoutFormat overpassOutpoutFormat, Class<? extends AbstractReader> clazz) {
        return outputFormatReaders.put(Objects.requireNonNull(overpassOutpoutFormat), Objects.requireNonNull(clazz));
    }

    @Override
    protected String getBaseUrl() {
        return this.overpassServer;
    }

    @Override
    protected String getRequestForBbox(double d, double d2, double d3, double d4) {
        if (this.overpassQuery.isEmpty()) {
            return super.getRequestForBbox(d, d2, d3, d4);
        }
        String string = this.overpassQuery.replace("{{bbox}}", d2 + "," + d + "," + d4 + "," + d3);
        String string2 = OverpassDownloadReader.expandExtendedQueries(string);
        return "interpreter?data=" + Utils.encodeUrl(string2);
    }

    static String expandExtendedQueries(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = Pattern.compile("\\{\\{(geocodeArea):([^}]+)\\}\\}").matcher(string);
        block8: while (matcher.find()) {
            try {
                switch (matcher.group(1)) {
                    case "geocodeArea": {
                        matcher.appendReplacement(stringBuffer, OverpassDownloadReader.geocodeArea(matcher.group(2)));
                        continue block8;
                    }
                }
                Logging.warn("Unsupported syntax: " + matcher.group(1));
            }
            catch (UncheckedParseException uncheckedParseException) {
                String string2 = I18n.tr("Failed to evaluate {0}", matcher.group());
                Logging.log(Logging.LEVEL_WARN, string2, uncheckedParseException);
                matcher.appendReplacement(stringBuffer, "// " + string2 + "\n");
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String geocodeArea(String string) {
        EnumMap<OsmPrimitiveType, Long> enumMap = new EnumMap<OsmPrimitiveType, Long>(OsmPrimitiveType.class);
        enumMap.put(OsmPrimitiveType.NODE, 0L);
        enumMap.put(OsmPrimitiveType.WAY, 2400000000L);
        enumMap.put(OsmPrimitiveType.RELATION, 3600000000L);
        try {
            PrimitiveId primitiveId = ((NameFinder.SearchResult)NameFinder.queryNominatim(string).stream().filter(searchResult -> !OsmPrimitiveType.NODE.equals((Object)searchResult.getOsmId().getType())).iterator().next()).getOsmId();
            return String.format("area(%d)", primitiveId.getUniqueId() + (Long)enumMap.get((Object)primitiveId.getType()));
        }
        catch (IOException | IndexOutOfBoundsException | NoSuchElementException exception) {
            throw new UncheckedParseException(exception);
        }
    }

    @Override
    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2, boolean bl) throws OsmTransferException {
        try {
            int n = string.indexOf(DATA_PREFIX);
            return super.getInputStreamRaw(string.substring(0, n), progressMonitor, string2, bl, "POST", Utils.decodeUrl(string.substring(n + DATA_PREFIX.length())).getBytes(StandardCharsets.UTF_8));
        }
        catch (OsmApiException osmApiException) {
            String string3;
            if (osmApiException.getMessage() != null && osmApiException.getMessage().contains("Error</strong>: ") && (string3 = osmApiException.getMessage().split("Error</strong>: ")[1]) != null) {
                osmApiException.setErrorHeader(string3.split("</")[0].replaceAll(".*::request_read_and_idx::", ""));
            }
            throw osmApiException;
        }
    }

    @Override
    protected void adaptRequest(HttpClient httpClient) {
        Matcher matcher = Pattern.compile("\\[timeout:(\\d+)\\]").matcher(this.overpassQuery);
        int n = matcher.find() ? (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(matcher.group(1))) : (int)TimeUnit.MINUTES.toMillis(3L);
        httpClient.setConnectTimeout(n);
        httpClient.setReadTimeout(n);
    }

    @Override
    protected String getTaskName() {
        return I18n.tr("Contacting Server...", new Object[0]);
    }

    @Override
    protected DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        Class<? extends AbstractReader> clazz;
        AbstractReader abstractReader = null;
        Matcher matcher = OUTPUT_FORMAT_STATEMENT.matcher(this.overpassQuery);
        if (matcher.matches() && (clazz = outputFormatReaders.get((Object)OverpassOutpoutFormat.from(matcher.group(1)))) != null) {
            try {
                abstractReader = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                Logging.error(exception);
            }
        }
        if (abstractReader == null) {
            abstractReader = new OverpassOsmReader();
        }
        return ((AbstractReader)abstractReader).doParseDataSet(inputStream, progressMonitor);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet = super.parseOsm(progressMonitor);
        if (dataSet != null && dataSet.getDataSources().isEmpty() && this.overpassQuery.contains("{{bbox}}")) {
            if (this.crosses180th) {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                DataSource dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.addDataSource(dataSource);
                bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.addDataSource(dataSource);
            } else {
                Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                DataSource dataSource = new DataSource(bounds, this.getBaseUrl());
                dataSet.addDataSource(dataSource);
            }
        }
        return dataSet;
    }

    static {
        OverpassDownloadReader.registerOverpassOutpoutFormatReader(OverpassOutpoutFormat.OSM_XML, OverpassOsmReader.class);
    }

    public static enum OverpassOutpoutFormat {
        OSM_XML("xml"),
        OSM_JSON("json"),
        CSV("csv"),
        CUSTOM("custom"),
        POPUP("popup"),
        PBF("pbf");

        private final String directive;

        private OverpassOutpoutFormat(String string2) {
            this.directive = string2;
        }

        public String getDirective() {
            return this.directive;
        }

        static OverpassOutpoutFormat from(String string) {
            for (OverpassOutpoutFormat overpassOutpoutFormat : OverpassOutpoutFormat.values()) {
                if (!overpassOutpoutFormat.directive.equals(string)) continue;
                return overpassOutpoutFormat;
            }
            throw new IllegalArgumentException(string);
        }
    }

    static final class OverpassOsmReader
    extends OsmReader {
        OverpassOsmReader() {
        }

        @Override
        protected void parseUnknown(boolean bl) throws XMLStreamException {
            String string;
            if ("remark".equals(this.parser.getLocalName()) && this.parser.getEventType() == 1 && (string = this.parser.getElementText()).contains("runtime error")) {
                throw new XMLStreamException(string);
            }
            super.parseUnknown(bl);
        }
    }
}

