/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Signature;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.RubyClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class JRubyCallSite
extends MutableCallSite {
    private final MethodHandles.Lookup lookup;
    private final CallType callType;
    public CacheEntry entry = CacheEntry.NULL_CACHE;
    private final Set<Integer> seenTypes = new HashSet<Integer>();
    private final boolean expression;
    private final String name;
    private int clearCount;
    private static final AtomicLong SITE_ID = new AtomicLong(1L);
    private final long siteID = SITE_ID.getAndIncrement();
    private final String file;
    private final int line;
    private boolean boundOnce = false;
    private final Signature signature;
    private final Signature fullSignature;
    private final int arity;
    public static final Signature STANDARD_SITE_SIG = Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("caller", IRubyObject.class).appendArg("self", IRubyObject.class);
    public static final Signature STANDARD_SITE_SIG_1ARG = STANDARD_SITE_SIG.appendArg("arg0", IRubyObject.class);
    public static final Signature STANDARD_SITE_SIG_2ARG = STANDARD_SITE_SIG_1ARG.appendArg("arg1", IRubyObject.class);
    public static final Signature STANDARD_SITE_SIG_3ARG = STANDARD_SITE_SIG_2ARG.appendArg("arg2", IRubyObject.class);
    public static final Signature STANDARD_SITE_SIG_NARG = STANDARD_SITE_SIG.appendArg("args", IRubyObject[].class);
    public static final Signature[] STANDARD_SITE_SIGS = new Signature[]{STANDARD_SITE_SIG, STANDARD_SITE_SIG_1ARG, STANDARD_SITE_SIG_2ARG, STANDARD_SITE_SIG_3ARG, STANDARD_SITE_SIG_NARG};
    public static final Signature STANDARD_SITE_SIG_BLOCK = STANDARD_SITE_SIG.appendArg("block", Block.class);
    public static final Signature STANDARD_SITE_SIG_1ARG_BLOCK = STANDARD_SITE_SIG_1ARG.appendArg("block", Block.class);
    public static final Signature STANDARD_SITE_SIG_2ARG_BLOCK = STANDARD_SITE_SIG_2ARG.appendArg("block", Block.class);
    public static final Signature STANDARD_SITE_SIG_3ARG_BLOCK = STANDARD_SITE_SIG_3ARG.appendArg("block", Block.class);
    public static final Signature STANDARD_SITE_SIG_NARG_BLOCK = STANDARD_SITE_SIG_NARG.appendArg("block", Block.class);
    public static final Signature[] STANDARD_SITE_SIGS_BLOCK = new Signature[]{STANDARD_SITE_SIG_BLOCK, STANDARD_SITE_SIG_1ARG_BLOCK, STANDARD_SITE_SIG_2ARG_BLOCK, STANDARD_SITE_SIG_3ARG_BLOCK, STANDARD_SITE_SIG_NARG_BLOCK};
    public static final Signature STANDARD_SUPER_SIG = Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("caller", IRubyObject.class).appendArg("self", IRubyObject.class).appendArg("class", RubyClass.class);

    public JRubyCallSite(MethodHandles.Lookup lookup, MethodType type2, CallType callType, String file2, int line, String name2, boolean expression) {
        super(type2);
        int arity2;
        int argOffset;
        Signature startSig;
        this.name = name2;
        this.callType = callType;
        if (callType == CallType.SUPER) {
            startSig = STANDARD_SUPER_SIG;
            argOffset = 4;
        } else {
            startSig = STANDARD_SITE_SIG;
            argOffset = 3;
        }
        if (type2.parameterType(type2.parameterCount() - 1) == Block.class) {
            arity2 = type2.parameterCount() - (argOffset + 1);
            if (arity2 == 1 && type2.parameterType(argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i2 = 0; i2 < arity2; ++i2) {
                    startSig = startSig.appendArg("arg" + i2, IRubyObject.class);
                }
            }
            this.fullSignature = this.signature = (startSig = startSig.appendArg("block", Block.class));
        } else {
            arity2 = type2.parameterCount() - argOffset;
            if (arity2 == 1 && type2.parameterType(argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i3 = 0; i3 < arity2; ++i3) {
                    startSig = startSig.appendArg("arg" + i3, IRubyObject.class);
                }
            }
            this.signature = startSig;
            this.fullSignature = startSig.appendArg("block", Block.class);
        }
        this.arity = arity2;
        this.lookup = lookup;
        this.expression = expression;
        this.file = file2;
        this.line = line;
    }

    public int arity() {
        return this.arity;
    }

    public MethodHandles.Lookup lookup() {
        return this.lookup;
    }

    public CallType callType() {
        return this.callType;
    }

    public boolean isAttrAssign() {
        return false;
    }

    public boolean isIterator() {
        return false;
    }

    public boolean isExpression() {
        return this.expression;
    }

    public String name() {
        return this.name;
    }

    public synchronized boolean hasSeenType(int typeCode) {
        return this.seenTypes.contains(typeCode);
    }

    public synchronized void addType(int typeCode) {
        this.seenTypes.add(typeCode);
    }

    public synchronized int seenTypesCount() {
        return this.seenTypes.size();
    }

    public synchronized void clearTypes() {
        this.seenTypes.clear();
        ++this.clearCount;
    }

    public int clearCount() {
        return this.clearCount;
    }

    public long siteID() {
        return this.siteID;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public boolean boundOnce() {
        return this.boundOnce;
    }

    public void boundOnce(boolean boundOnce) {
        this.boundOnce = boundOnce;
    }

    @Override
    public void setTarget(MethodHandle target) {
        super.setTarget(target);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target) {
        super.setTarget(target);
    }

    public Signature signature() {
        return this.signature;
    }

    public Signature fullSignature() {
        return this.fullSignature;
    }
}

