// Copyright (c) 2009   INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org).
// You can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL$
// $Id$
// 
//
// Author(s)     : Manuel Caroli <Manuel.Caroli@sophia.inria.fr>

#ifdef CGAL_INCLUDE_FROM_PERIODIC_3_TRIANGULATION_3_H 


template < class GT, class TDS >
inline std::vector<typename Periodic_3_triangulation_3<GT,TDS>::Vertex_handle >
Periodic_3_triangulation_3<GT,TDS>::insert_dummy_points() {
  clear();

  Vertex_handle vertices[36];
  Cell_handle cells[216];
  
  // Initialise vertices:
  for (int i=0; i<4; i++) {
    for (int j=0; j<3; j++) {
      for (int k=0; k<3; k++) {
	// Initialise virtual vertices out of the domain for debugging
	vertices[9*i+3*j+k] = _tds.create_vertex();
	Point p(k*(1.0/3.0) + i*(1.0/6.0),
	    j*(1.0/3.0) + i*(1.0/6.0), i*(1.0/4.0) );
	p = Point((p.x() > FT(0.9375) ? (std::max)( p.x()-1, FT(0) ) : p.x()),
	    (p.y() > FT(0.9375) ? (std::max)( p.y()-1, FT(0) ) : p.y()), p.z());
	p = Point((_domain.xmax()-_domain.xmin())*p.x(),
	    (_domain.xmax()-_domain.xmin())*p.y(),
	    (_domain.xmax()-_domain.xmin())*p.z());
	p = Point(p.x() + _domain.xmin(),
	    p.y() + _domain.ymin(),
	    p.z() + _domain.zmin());
	vertices[9*i+3*j+k]->set_point(p);
      }
    }
  }

  // Create cells:
  for (int i=0; i<216; i++) {
    cells[i] = _tds.create_cell();
  }
  
  cells[0]->set_vertices(vertices[3],vertices[9],vertices[4],vertices[12]);
  cells[1]->set_vertices(vertices[28],vertices[8],vertices[3],vertices[6]);
  cells[2]->set_vertices(vertices[0],vertices[11],vertices[9],vertices[3]);
  cells[3]->set_vertices(vertices[11],vertices[19],vertices[13],vertices[10]);
  cells[4]->set_vertices(vertices[7],vertices[15],vertices[12],vertices[13]);
  cells[5]->set_vertices(vertices[6],vertices[12],vertices[7],vertices[15]);
  cells[6]->set_vertices(vertices[2],vertices[8],vertices[6],vertices[17]);
  cells[7]->set_vertices(vertices[3],vertices[12],vertices[4],vertices[6]);
  cells[8]->set_vertices(vertices[25],vertices[24],vertices[16],vertices[22]);
  cells[9]->set_vertices(vertices[3],vertices[14],vertices[12],vertices[6]);
  cells[10]->set_vertices(vertices[2],vertices[1],vertices[10],vertices[4]);
  cells[11]->set_vertices(vertices[8],vertices[7],vertices[5],vertices[13]);
  cells[12]->set_vertices(vertices[27],vertices[5],vertices[28],vertices[8]);
  cells[13]->set_vertices(vertices[29],vertices[21],vertices[27],vertices[18]);
  cells[14]->set_vertices(vertices[26],vertices[25],vertices[17],vertices[23]);
  cells[15]->set_vertices(vertices[21],vertices[30],vertices[27],vertices[22]);
  cells[16]->set_vertices(vertices[29],vertices[6],vertices[3],vertices[4]);
  cells[17]->set_vertices(vertices[17],vertices[8],vertices[6],vertices[14]);
  cells[18]->set_vertices(vertices[22],vertices[30],vertices[31],vertices[25]);
  cells[19]->set_vertices(vertices[6],vertices[2],vertices[17],vertices[0]);
  cells[20]->set_vertices(vertices[11],vertices[19],vertices[14],vertices[13]);
  cells[21]->set_vertices(vertices[2],vertices[4],vertices[10],vertices[5]);
  cells[22]->set_vertices(vertices[12],vertices[21],vertices[23],vertices[18]);
  cells[23]->set_vertices(vertices[16],vertices[14],vertices[17],vertices[22]);
  cells[24]->set_vertices(vertices[31],vertices[2],vertices[34],vertices[33]);
  cells[25]->set_vertices(vertices[25],vertices[31],vertices[23],vertices[26]);
  cells[26]->set_vertices(vertices[25],vertices[22],vertices[17],vertices[23]);
  cells[27]->set_vertices(vertices[14],vertices[5],vertices[11],vertices[13]);
  cells[28]->set_vertices(vertices[2],vertices[16],vertices[17],vertices[10]);
  cells[29]->set_vertices(vertices[9],vertices[24],vertices[16],vertices[10]);
  cells[30]->set_vertices(vertices[19],vertices[18],vertices[13],vertices[10]);
  cells[31]->set_vertices(vertices[17],vertices[2],vertices[11],vertices[0]);
  cells[32]->set_vertices(vertices[21],vertices[32],vertices[27],vertices[30]);
  cells[33]->set_vertices(vertices[4],vertices[7],vertices[13],vertices[5]);
  cells[34]->set_vertices(vertices[11],vertices[2],vertices[10],vertices[5]);
  cells[35]->set_vertices(vertices[0],vertices[2],vertices[11],vertices[5]);
  cells[36]->set_vertices(vertices[6],vertices[15],vertices[7],vertices[0]);
  cells[37]->set_vertices(vertices[8],vertices[5],vertices[14],vertices[13]);
  cells[38]->set_vertices(vertices[30],vertices[8],vertices[31],vertices[2]);
  cells[39]->set_vertices(vertices[31],vertices[8],vertices[6],vertices[2]);
  cells[40]->set_vertices(vertices[19],vertices[28],vertices[20],vertices[22]);
  cells[41]->set_vertices(vertices[13],vertices[15],vertices[21],vertices[16]);
  cells[42]->set_vertices(vertices[10],vertices[18],vertices[25],vertices[19]);
  cells[43]->set_vertices(vertices[9],vertices[26],vertices[15],vertices[24]);
  cells[44]->set_vertices(vertices[12],vertices[23],vertices[20],vertices[18]);
  cells[45]->set_vertices(vertices[30],vertices[8],vertices[28],vertices[31]);
  cells[46]->set_vertices(vertices[16],vertices[8],vertices[14],vertices[13]);
  cells[47]->set_vertices(vertices[15],vertices[26],vertices[17],vertices[23]);
  cells[48]->set_vertices(vertices[4],vertices[12],vertices[9],vertices[10]);
  cells[49]->set_vertices(vertices[6],vertices[17],vertices[15],vertices[0]);
  cells[50]->set_vertices(vertices[10],vertices[1],vertices[9],vertices[4]);
  cells[51]->set_vertices(vertices[14],vertices[19],vertices[20],vertices[22]);
  cells[52]->set_vertices(vertices[23],vertices[14],vertices[20],vertices[22]);
  cells[53]->set_vertices(vertices[16],vertices[1],vertices[9],vertices[10]);
  cells[54]->set_vertices(vertices[22],vertices[28],vertices[23],vertices[31]);
  cells[55]->set_vertices(vertices[4],vertices[3],vertices[1],vertices[9]);
  cells[56]->set_vertices(vertices[0],vertices[3],vertices[9],vertices[1]);
  cells[57]->set_vertices(vertices[17],vertices[11],vertices[15],vertices[0]);
  cells[58]->set_vertices(vertices[19],vertices[28],vertices[34],vertices[20]);
  cells[59]->set_vertices(vertices[9],vertices[12],vertices[18],vertices[10]);
  cells[60]->set_vertices(vertices[7],vertices[6],vertices[4],vertices[12]);
  cells[61]->set_vertices(vertices[33],vertices[4],vertices[2],vertices[5]);
  cells[62]->set_vertices(vertices[33],vertices[35],vertices[1],vertices[4]);
  cells[63]->set_vertices(vertices[0],vertices[5],vertices[11],vertices[3]);
  cells[64]->set_vertices(vertices[4],vertices[7],vertices[12],vertices[13]);
  cells[65]->set_vertices(vertices[7],vertices[16],vertices[13],vertices[8]);
  cells[66]->set_vertices(vertices[32],vertices[34],vertices[26],vertices[31]);
  cells[67]->set_vertices(vertices[26],vertices[23],vertices[15],vertices[21]);
  cells[68]->set_vertices(vertices[7],vertices[1],vertices[16],vertices[8]);
  cells[69]->set_vertices(vertices[3],vertices[8],vertices[14],vertices[6]);
  cells[70]->set_vertices(vertices[4],vertices[13],vertices[10],vertices[5]);
  cells[71]->set_vertices(vertices[16],vertices[1],vertices[10],vertices[2]);
  cells[72]->set_vertices(vertices[13],vertices[5],vertices[11],vertices[10]);
  cells[73]->set_vertices(vertices[13],vertices[21],vertices[18],vertices[19]);
  cells[74]->set_vertices(vertices[9],vertices[20],vertices[18],vertices[12]);
  cells[75]->set_vertices(vertices[32],vertices[0],vertices[6],vertices[7]);
  cells[76]->set_vertices(vertices[3],vertices[14],vertices[9],vertices[12]);
  cells[77]->set_vertices(vertices[7],vertices[15],vertices[1],vertices[0]);
  cells[78]->set_vertices(vertices[27],vertices[29],vertices[4],vertices[7]);
  cells[79]->set_vertices(vertices[28],vertices[8],vertices[6],vertices[31]);
  cells[80]->set_vertices(vertices[15],vertices[9],vertices[1],vertices[0]);
  cells[81]->set_vertices(vertices[7],vertices[15],vertices[13],vertices[16]);
  cells[82]->set_vertices(vertices[4],vertices[13],vertices[12],vertices[10]);
  cells[83]->set_vertices(vertices[15],vertices[11],vertices[9],vertices[0]);
  cells[84]->set_vertices(vertices[2],vertices[17],vertices[11],vertices[10]);
  cells[85]->set_vertices(vertices[7],vertices[1],vertices[15],vertices[16]);
  cells[86]->set_vertices(vertices[8],vertices[1],vertices[16],vertices[2]);
  cells[87]->set_vertices(vertices[15],vertices[1],vertices[9],vertices[16]);
  cells[88]->set_vertices(vertices[3],vertices[11],vertices[9],vertices[14]);
  cells[89]->set_vertices(vertices[14],vertices[5],vertices[3],vertices[11]);
  cells[90]->set_vertices(vertices[8],vertices[5],vertices[3],vertices[14]);
  cells[91]->set_vertices(vertices[19],vertices[34],vertices[28],vertices[27]);
  cells[92]->set_vertices(vertices[23],vertices[14],vertices[22],vertices[17]);
  cells[93]->set_vertices(vertices[11],vertices[19],vertices[26],vertices[20]);
  cells[94]->set_vertices(vertices[18],vertices[29],vertices[35],vertices[33]);
  cells[95]->set_vertices(vertices[12],vertices[13],vertices[18],vertices[10]);
  cells[96]->set_vertices(vertices[23],vertices[21],vertices[29],vertices[18]);
  cells[97]->set_vertices(vertices[17],vertices[14],vertices[6],vertices[12]);
  cells[98]->set_vertices(vertices[15],vertices[17],vertices[6],vertices[12]);
  cells[99]->set_vertices(vertices[16],vertices[8],vertices[17],vertices[14]);
  cells[100]->set_vertices(vertices[2],vertices[8],vertices[17],vertices[16]);
  cells[101]->set_vertices(vertices[24],vertices[26],vertices[15],vertices[21]);
  cells[102]->set_vertices(vertices[35],vertices[3],vertices[1],vertices[4]);
  cells[103]->set_vertices(vertices[12],vertices[14],vertices[23],vertices[17]);
  cells[104]->set_vertices(vertices[24],vertices[30],vertices[32],vertices[21]);
  cells[105]->set_vertices(vertices[9],vertices[11],vertices[26],vertices[20]);
  cells[106]->set_vertices(vertices[29],vertices[6],vertices[4],vertices[7]);
  cells[107]->set_vertices(vertices[33],vertices[30],vertices[24],vertices[25]);
  cells[108]->set_vertices(vertices[21],vertices[24],vertices[30],vertices[22]);
  cells[109]->set_vertices(vertices[18],vertices[29],vertices[20],vertices[35]);
  cells[110]->set_vertices(vertices[35],vertices[34],vertices[3],vertices[28]);
  cells[111]->set_vertices(vertices[24],vertices[21],vertices[15],vertices[16]);
  cells[112]->set_vertices(vertices[20],vertices[28],vertices[23],vertices[22]);
  cells[113]->set_vertices(vertices[25],vertices[33],vertices[30],vertices[31]);
  cells[114]->set_vertices(vertices[29],vertices[23],vertices[28],vertices[31]);
  cells[115]->set_vertices(vertices[12],vertices[17],vertices[23],vertices[15]);
  cells[116]->set_vertices(vertices[9],vertices[11],vertices[15],vertices[26]);
  cells[117]->set_vertices(vertices[12],vertices[14],vertices[20],vertices[23]);
  cells[118]->set_vertices(vertices[29],vertices[28],vertices[3],vertices[6]);
  cells[119]->set_vertices(vertices[24],vertices[35],vertices[30],vertices[33]);
  cells[120]->set_vertices(vertices[9],vertices[20],vertices[26],vertices[24]);
  cells[121]->set_vertices(vertices[15],vertices[11],vertices[17],vertices[26]);
  cells[122]->set_vertices(vertices[9],vertices[20],vertices[24],vertices[18]);
  cells[123]->set_vertices(vertices[27],vertices[7],vertices[5],vertices[8]);
  cells[124]->set_vertices(vertices[19],vertices[27],vertices[28],vertices[22]);
  cells[125]->set_vertices(vertices[9],vertices[18],vertices[24],vertices[10]);
  cells[126]->set_vertices(vertices[35],vertices[20],vertices[34],vertices[28]);
  cells[127]->set_vertices(vertices[12],vertices[23],vertices[21],vertices[15]);
  cells[128]->set_vertices(vertices[22],vertices[30],vertices[28],vertices[31]);
  cells[129]->set_vertices(vertices[29],vertices[32],vertices[6],vertices[7]);
  cells[130]->set_vertices(vertices[25],vertices[16],vertices[17],vertices[22]);
  cells[131]->set_vertices(vertices[24],vertices[21],vertices[16],vertices[22]);
  cells[132]->set_vertices(vertices[20],vertices[11],vertices[19],vertices[14]);
  cells[133]->set_vertices(vertices[9],vertices[11],vertices[20],vertices[14]);
  cells[134]->set_vertices(vertices[9],vertices[14],vertices[20],vertices[12]);
  cells[135]->set_vertices(vertices[10],vertices[25],vertices[11],vertices[19]);
  cells[136]->set_vertices(vertices[35],vertices[32],vertices[26],vertices[24]);
  cells[137]->set_vertices(vertices[12],vertices[21],vertices[18],vertices[13]);
  cells[138]->set_vertices(vertices[12],vertices[15],vertices[21],vertices[13]);
  cells[139]->set_vertices(vertices[22],vertices[31],vertices[23],vertices[25]);
  cells[140]->set_vertices(vertices[9],vertices[24],vertices[15],vertices[16]);
  cells[141]->set_vertices(vertices[35],vertices[32],vertices[30],vertices[1]);
  cells[142]->set_vertices(vertices[11],vertices[25],vertices[17],vertices[26]);
  cells[143]->set_vertices(vertices[32],vertices[35],vertices[0],vertices[1]);
  cells[144]->set_vertices(vertices[13],vertices[22],vertices[21],vertices[19]);
  cells[145]->set_vertices(vertices[22],vertices[13],vertices[14],vertices[19]);
  cells[146]->set_vertices(vertices[16],vertices[13],vertices[14],vertices[22]);
  cells[147]->set_vertices(vertices[13],vertices[16],vertices[21],vertices[22]);
  cells[148]->set_vertices(vertices[34],vertices[2],vertices[0],vertices[5]);
  cells[149]->set_vertices(vertices[28],vertices[5],vertices[3],vertices[8]);
  cells[150]->set_vertices(vertices[24],vertices[30],vertices[22],vertices[25]);
  cells[151]->set_vertices(vertices[21],vertices[23],vertices[29],vertices[32]);
  cells[152]->set_vertices(vertices[33],vertices[35],vertices[30],vertices[1]);
  cells[153]->set_vertices(vertices[19],vertices[33],vertices[34],vertices[27]);
  cells[154]->set_vertices(vertices[27],vertices[8],vertices[28],vertices[30]);
  cells[155]->set_vertices(vertices[27],vertices[30],vertices[7],vertices[8]);
  cells[156]->set_vertices(vertices[19],vertices[21],vertices[27],vertices[22]);
  cells[157]->set_vertices(vertices[18],vertices[33],vertices[25],vertices[19]);
  cells[158]->set_vertices(vertices[10],vertices[18],vertices[24],vertices[25]);
  cells[159]->set_vertices(vertices[10],vertices[24],vertices[16],vertices[25]);
  cells[160]->set_vertices(vertices[10],vertices[16],vertices[17],vertices[25]);
  cells[161]->set_vertices(vertices[10],vertices[17],vertices[11],vertices[25]);
  cells[162]->set_vertices(vertices[27],vertices[30],vertices[28],vertices[22]);
  cells[163]->set_vertices(vertices[18],vertices[20],vertices[29],vertices[23]);
  cells[164]->set_vertices(vertices[32],vertices[23],vertices[31],vertices[26]);
  cells[165]->set_vertices(vertices[11],vertices[19],vertices[25],vertices[26]);
  cells[166]->set_vertices(vertices[33],vertices[2],vertices[30],vertices[31]);
  cells[167]->set_vertices(vertices[30],vertices[1],vertices[7],vertices[8]);
  cells[168]->set_vertices(vertices[27],vertices[7],vertices[4],vertices[5]);
  cells[169]->set_vertices(vertices[18],vertices[21],vertices[27],vertices[19]);
  cells[170]->set_vertices(vertices[24],vertices[32],vertices[30],vertices[35]);
  cells[171]->set_vertices(vertices[30],vertices[1],vertices[2],vertices[33]);
  cells[172]->set_vertices(vertices[33],vertices[31],vertices[25],vertices[34]);
  cells[173]->set_vertices(vertices[34],vertices[5],vertices[28],vertices[27]);
  cells[174]->set_vertices(vertices[32],vertices[31],vertices[6],vertices[0]);
  cells[175]->set_vertices(vertices[29],vertices[23],vertices[31],vertices[32]);
  cells[176]->set_vertices(vertices[18],vertices[35],vertices[24],vertices[33]);
  cells[177]->set_vertices(vertices[35],vertices[34],vertices[26],vertices[32]);
  cells[178]->set_vertices(vertices[29],vertices[3],vertices[35],vertices[4]);
  cells[179]->set_vertices(vertices[29],vertices[35],vertices[3],vertices[28]);
  cells[180]->set_vertices(vertices[33],vertices[1],vertices[2],vertices[4]);
  cells[181]->set_vertices(vertices[34],vertices[5],vertices[0],vertices[3]);
  cells[182]->set_vertices(vertices[35],vertices[3],vertices[0],vertices[1]);
  cells[183]->set_vertices(vertices[19],vertices[34],vertices[25],vertices[26]);
  cells[184]->set_vertices(vertices[30],vertices[1],vertices[8],vertices[2]);
  cells[185]->set_vertices(vertices[33],vertices[2],vertices[34],vertices[5]);
  cells[186]->set_vertices(vertices[28],vertices[5],vertices[34],vertices[3]);
  cells[187]->set_vertices(vertices[19],vertices[34],vertices[26],vertices[20]);
  cells[188]->set_vertices(vertices[31],vertices[2],vertices[0],vertices[34]);
  cells[189]->set_vertices(vertices[18],vertices[33],vertices[24],vertices[25]);
  cells[190]->set_vertices(vertices[30],vertices[32],vertices[27],vertices[7]);
  cells[191]->set_vertices(vertices[30],vertices[32],vertices[7],vertices[1]);
  cells[192]->set_vertices(vertices[21],vertices[29],vertices[27],vertices[32]);
  cells[193]->set_vertices(vertices[32],vertices[0],vertices[7],vertices[1]);
  cells[194]->set_vertices(vertices[32],vertices[29],vertices[27],vertices[7]);
  cells[195]->set_vertices(vertices[29],vertices[31],vertices[28],vertices[6]);
  cells[196]->set_vertices(vertices[31],vertices[2],vertices[6],vertices[0]);
  cells[197]->set_vertices(vertices[29],vertices[20],vertices[28],vertices[23]);
  cells[198]->set_vertices(vertices[20],vertices[34],vertices[26],vertices[35]);
  cells[199]->set_vertices(vertices[32],vertices[0],vertices[34],vertices[31]);
  cells[200]->set_vertices(vertices[18],vertices[35],vertices[20],vertices[24]);
  cells[201]->set_vertices(vertices[20],vertices[35],vertices[26],vertices[24]);
  cells[202]->set_vertices(vertices[18],vertices[27],vertices[33],vertices[19]);
  cells[203]->set_vertices(vertices[33],vertices[29],vertices[35],vertices[4]);
  cells[204]->set_vertices(vertices[33],vertices[5],vertices[34],vertices[27]);
  cells[205]->set_vertices(vertices[19],vertices[33],vertices[25],vertices[34]);
  cells[206]->set_vertices(vertices[34],vertices[31],vertices[25],vertices[26]);
  cells[207]->set_vertices(vertices[24],vertices[32],vertices[26],vertices[21]);
  cells[208]->set_vertices(vertices[21],vertices[23],vertices[32],vertices[26]);
  cells[209]->set_vertices(vertices[29],vertices[31],vertices[6],vertices[32]);
  cells[210]->set_vertices(vertices[33],vertices[27],vertices[29],vertices[4]);
  cells[211]->set_vertices(vertices[27],vertices[4],vertices[33],vertices[5]);
  cells[212]->set_vertices(vertices[18],vertices[27],vertices[29],vertices[33]);
  cells[213]->set_vertices(vertices[29],vertices[20],vertices[35],vertices[28]);
  cells[214]->set_vertices(vertices[34],vertices[3],vertices[0],vertices[35]);
  cells[215]->set_vertices(vertices[35],vertices[0],vertices[34],vertices[32]);

  cells[0]->set_neighbors(cells[48],cells[7],cells[76],cells[55]);
  cells[1]->set_neighbors(cells[69],cells[118],cells[79],cells[149]);
  cells[2]->set_neighbors(cells[88],cells[56],cells[63],cells[83]);
  cells[3]->set_neighbors(cells[30],cells[72],cells[135],cells[20]);
  cells[4]->set_neighbors(cells[138],cells[64],cells[81],cells[5]);
  cells[5]->set_neighbors(cells[4],cells[36],cells[98],cells[60]);
  cells[6]->set_neighbors(cells[17],cells[19],cells[100],cells[39]);
  cells[7]->set_neighbors(cells[60],cells[16],cells[9],cells[0]);
  cells[8]->set_neighbors(cells[131],cells[130],cells[150],cells[159]);
  cells[9]->set_neighbors(cells[97],cells[7],cells[69],cells[76]);
  cells[10]->set_neighbors(cells[50],cells[21],cells[180],cells[71]);
  cells[11]->set_neighbors(cells[33],cells[37],cells[65],cells[123]);
  cells[12]->set_neighbors(cells[149],cells[154],cells[123],cells[173]);
  cells[13]->set_neighbors(cells[169],cells[212],cells[96],cells[192]);
  cells[14]->set_neighbors(cells[26],cells[47],cells[25],cells[142]);
  cells[15]->set_neighbors(cells[162],cells[156],cells[108],cells[32]);
  cells[16]->set_neighbors(cells[7],cells[178],cells[106],cells[118]);
  cells[17]->set_neighbors(cells[69],cells[97],cells[99],cells[6]);
  cells[18]->set_neighbors(cells[113],cells[139],cells[150],cells[128]);
  cells[19]->set_neighbors(cells[31],cells[49],cells[196],cells[6]);
  cells[20]->set_neighbors(cells[145],cells[27],cells[3],cells[132]);
  cells[21]->set_neighbors(cells[70],cells[34],cells[61],cells[10]);
  cells[22]->set_neighbors(cells[96],cells[44],cells[137],cells[127]);
  cells[23]->set_neighbors(cells[92],cells[130],cells[146],cells[99]);
  cells[24]->set_neighbors(cells[185],cells[172],cells[166],cells[188]);
  cells[25]->set_neighbors(cells[164],cells[14],cells[206],cells[139]);
  cells[26]->set_neighbors(cells[92],cells[14],cells[139],cells[130]);
  cells[27]->set_neighbors(cells[72],cells[20],cells[37],cells[89]);
  cells[28]->set_neighbors(cells[160],cells[84],cells[71],cells[100]);
  cells[29]->set_neighbors(cells[159],cells[53],cells[125],cells[140]);
  cells[30]->set_neighbors(cells[95],cells[3],cells[42],cells[73]);
  cells[31]->set_neighbors(cells[35],cells[57],cells[19],cells[84]);
  cells[32]->set_neighbors(cells[190],cells[15],cells[104],cells[192]);
  cells[33]->set_neighbors(cells[11],cells[70],cells[168],cells[64]);
  cells[34]->set_neighbors(cells[21],cells[72],cells[35],cells[84]);
  cells[35]->set_neighbors(cells[34],cells[63],cells[148],cells[31]);
  cells[36]->set_neighbors(cells[77],cells[75],cells[49],cells[5]);
  cells[37]->set_neighbors(cells[27],cells[46],cells[11],cells[90]);
  cells[38]->set_neighbors(cells[39],cells[166],cells[184],cells[45]);
  cells[39]->set_neighbors(cells[6],cells[196],cells[38],cells[79]);
  cells[40]->set_neighbors(cells[112],cells[51],cells[124],cells[58]);
  cells[41]->set_neighbors(cells[111],cells[147],cells[81],cells[138]);
  cells[42]->set_neighbors(cells[157],cells[135],cells[30],cells[158]);
  cells[43]->set_neighbors(cells[101],cells[140],cells[120],cells[116]);
  cells[44]->set_neighbors(cells[163],cells[74],cells[22],cells[117]);
  cells[45]->set_neighbors(cells[79],cells[128],cells[38],cells[154]);
  cells[46]->set_neighbors(cells[37],cells[146],cells[65],cells[99]);
  cells[47]->set_neighbors(cells[14],cells[115],cells[67],cells[121]);
  cells[48]->set_neighbors(cells[59],cells[50],cells[82],cells[0]);
  cells[49]->set_neighbors(cells[57],cells[36],cells[19],cells[98]);
  cells[50]->set_neighbors(cells[55],cells[48],cells[10],cells[53]);
  cells[51]->set_neighbors(cells[40],cells[52],cells[145],cells[132]);
  cells[52]->set_neighbors(cells[51],cells[112],cells[92],cells[117]);
  cells[53]->set_neighbors(cells[50],cells[29],cells[71],cells[87]);
  cells[54]->set_neighbors(cells[114],cells[139],cells[128],cells[112]);
  cells[55]->set_neighbors(cells[56],cells[50],cells[0],cells[102]);
  cells[56]->set_neighbors(cells[55],cells[80],cells[182],cells[2]);
  cells[57]->set_neighbors(cells[83],cells[49],cells[31],cells[121]);
  cells[58]->set_neighbors(cells[126],cells[187],cells[40],cells[91]);
  cells[59]->set_neighbors(cells[95],cells[125],cells[48],cells[74]);
  cells[60]->set_neighbors(cells[7],cells[64],cells[5],cells[106]);
  cells[61]->set_neighbors(cells[21],cells[185],cells[211],cells[180]);
  cells[62]->set_neighbors(cells[102],cells[180],cells[203],cells[152]);
  cells[63]->set_neighbors(cells[89],cells[2],cells[181],cells[35]);
  cells[64]->set_neighbors(cells[4],cells[82],cells[33],cells[60]);
  cells[65]->set_neighbors(cells[46],cells[11],cells[68],cells[81]);
  cells[66]->set_neighbors(cells[206],cells[164],cells[199],cells[177]);
  cells[67]->set_neighbors(cells[127],cells[101],cells[208],cells[47]);
  cells[68]->set_neighbors(cells[86],cells[65],cells[167],cells[85]);
  cells[69]->set_neighbors(cells[17],cells[9],cells[1],cells[90]);
  cells[70]->set_neighbors(cells[72],cells[21],cells[33],cells[82]);
  cells[71]->set_neighbors(cells[10],cells[28],cells[86],cells[53]);
  cells[72]->set_neighbors(cells[34],cells[3],cells[70],cells[27]);
  cells[73]->set_neighbors(cells[169],cells[30],cells[144],cells[137]);
  cells[74]->set_neighbors(cells[44],cells[59],cells[134],cells[122]);
  cells[75]->set_neighbors(cells[36],cells[129],cells[193],cells[174]);
  cells[76]->set_neighbors(cells[134],cells[0],cells[9],cells[88]);
  cells[77]->set_neighbors(cells[80],cells[193],cells[36],cells[85]);
  cells[78]->set_neighbors(cells[106],cells[168],cells[194],cells[210]);
  cells[79]->set_neighbors(cells[39],cells[195],cells[45],cells[1]);
  cells[80]->set_neighbors(cells[56],cells[77],cells[83],cells[87]);
  cells[81]->set_neighbors(cells[41],cells[65],cells[85],cells[4]);
  cells[82]->set_neighbors(cells[95],cells[48],cells[70],cells[64]);
  cells[83]->set_neighbors(cells[2],cells[80],cells[57],cells[116]);
  cells[84]->set_neighbors(cells[161],cells[34],cells[28],cells[31]);
  cells[85]->set_neighbors(cells[87],cells[81],cells[68],cells[77]);
  cells[86]->set_neighbors(cells[71],cells[100],cells[184],cells[68]);
  cells[87]->set_neighbors(cells[53],cells[140],cells[85],cells[80]);
  cells[88]->set_neighbors(cells[133],cells[76],cells[89],cells[2]);
  cells[89]->set_neighbors(cells[63],cells[88],cells[27],cells[90]);
  cells[90]->set_neighbors(cells[89],cells[69],cells[37],cells[149]);
  cells[91]->set_neighbors(cells[173],cells[124],cells[153],cells[58]);
  cells[92]->set_neighbors(cells[23],cells[26],cells[103],cells[52]);
  cells[93]->set_neighbors(cells[187],cells[105],cells[132],cells[165]);
  cells[94]->set_neighbors(cells[203],cells[176],cells[212],cells[109]);
  cells[95]->set_neighbors(cells[30],cells[59],cells[82],cells[137]);
  cells[96]->set_neighbors(cells[13],cells[163],cells[22],cells[151]);
  cells[97]->set_neighbors(cells[9],cells[98],cells[103],cells[17]);
  cells[98]->set_neighbors(cells[97],cells[5],cells[115],cells[49]);
  cells[99]->set_neighbors(cells[17],cells[23],cells[46],cells[100]);
  cells[100]->set_neighbors(cells[99],cells[28],cells[86],cells[6]);
  cells[101]->set_neighbors(cells[67],cells[111],cells[207],cells[43]);
  cells[102]->set_neighbors(cells[55],cells[62],cells[178],cells[182]);
  cells[103]->set_neighbors(cells[92],cells[115],cells[97],cells[117]);
  cells[104]->set_neighbors(cells[32],cells[207],cells[108],cells[170]);
  cells[105]->set_neighbors(cells[93],cells[120],cells[133],cells[116]);
  cells[106]->set_neighbors(cells[60],cells[78],cells[129],cells[16]);
  cells[107]->set_neighbors(cells[150],cells[189],cells[113],cells[119]);
  cells[108]->set_neighbors(cells[150],cells[15],cells[131],cells[104]);
  cells[109]->set_neighbors(cells[213],cells[200],cells[94],cells[163]);
  cells[110]->set_neighbors(cells[186],cells[179],cells[126],cells[214]);
  cells[111]->set_neighbors(cells[41],cells[140],cells[131],cells[101]);
  cells[112]->set_neighbors(cells[54],cells[52],cells[40],cells[197]);
  cells[113]->set_neighbors(cells[166],cells[18],cells[172],cells[107]);
  cells[114]->set_neighbors(cells[54],cells[195],cells[175],cells[197]);
  cells[115]->set_neighbors(cells[47],cells[127],cells[98],cells[103]);
  cells[116]->set_neighbors(cells[121],cells[43],cells[105],cells[83]);
  cells[117]->set_neighbors(cells[52],cells[44],cells[103],cells[134]);
  cells[118]->set_neighbors(cells[1],cells[16],cells[195],cells[179]);
  cells[119]->set_neighbors(cells[152],cells[107],cells[176],cells[170]);
  cells[120]->set_neighbors(cells[201],cells[43],cells[122],cells[105]);
  cells[121]->set_neighbors(cells[142],cells[47],cells[116],cells[57]);
  cells[122]->set_neighbors(cells[200],cells[125],cells[74],cells[120]);
  cells[123]->set_neighbors(cells[11],cells[12],cells[155],cells[168]);
  cells[124]->set_neighbors(cells[162],cells[40],cells[156],cells[91]);
  cells[125]->set_neighbors(cells[158],cells[29],cells[59],cells[122]);
  cells[126]->set_neighbors(cells[58],cells[110],cells[213],cells[198]);
  cells[127]->set_neighbors(cells[67],cells[138],cells[115],cells[22]);
  cells[128]->set_neighbors(cells[45],cells[54],cells[18],cells[162]);
  cells[129]->set_neighbors(cells[75],cells[106],cells[194],cells[209]);
  cells[130]->set_neighbors(cells[23],cells[26],cells[8],cells[160]);
  cells[131]->set_neighbors(cells[147],cells[8],cells[108],cells[111]);
  cells[132]->set_neighbors(cells[20],cells[51],cells[133],cells[93]);
  cells[133]->set_neighbors(cells[132],cells[134],cells[88],cells[105]);
  cells[134]->set_neighbors(cells[117],cells[74],cells[76],cells[133]);
  cells[135]->set_neighbors(cells[165],cells[3],cells[42],cells[161]);
  cells[136]->set_neighbors(cells[207],cells[201],cells[170],cells[177]);
  cells[137]->set_neighbors(cells[73],cells[95],cells[138],cells[22]);
  cells[138]->set_neighbors(cells[41],cells[137],cells[4],cells[127]);
  cells[139]->set_neighbors(cells[25],cells[26],cells[18],cells[54]);
  cells[140]->set_neighbors(cells[111],cells[87],cells[29],cells[43]);
  cells[141]->set_neighbors(cells[191],cells[152],cells[143],cells[170]);
  cells[142]->set_neighbors(cells[14],cells[121],cells[165],cells[161]);
  cells[143]->set_neighbors(cells[182],cells[193],cells[141],cells[215]);
  cells[144]->set_neighbors(cells[156],cells[73],cells[145],cells[147]);
  cells[145]->set_neighbors(cells[20],cells[51],cells[144],cells[146]);
  cells[146]->set_neighbors(cells[145],cells[23],cells[147],cells[46]);
  cells[147]->set_neighbors(cells[131],cells[144],cells[146],cells[41]);
  cells[148]->set_neighbors(cells[35],cells[181],cells[185],cells[188]);
  cells[149]->set_neighbors(cells[90],cells[1],cells[12],cells[186]);
  cells[150]->set_neighbors(cells[18],cells[8],cells[107],cells[108]);
  cells[151]->set_neighbors(cells[175],cells[192],cells[208],cells[96]);
  cells[152]->set_neighbors(cells[141],cells[171],cells[62],cells[119]);
  cells[153]->set_neighbors(cells[204],cells[91],cells[202],cells[205]);
  cells[154]->set_neighbors(cells[45],cells[162],cells[155],cells[12]);
  cells[155]->set_neighbors(cells[167],cells[123],cells[154],cells[190]);
  cells[156]->set_neighbors(cells[15],cells[124],cells[144],cells[169]);
  cells[157]->set_neighbors(cells[205],cells[42],cells[202],cells[189]);
  cells[158]->set_neighbors(cells[189],cells[159],cells[42],cells[125]);
  cells[159]->set_neighbors(cells[8],cells[160],cells[158],cells[29]);
  cells[160]->set_neighbors(cells[130],cells[161],cells[159],cells[28]);
  cells[161]->set_neighbors(cells[142],cells[135],cells[160],cells[84]);
  cells[162]->set_neighbors(cells[128],cells[124],cells[15],cells[154]);
  cells[163]->set_neighbors(cells[197],cells[96],cells[44],cells[109]);
  cells[164]->set_neighbors(cells[25],cells[66],cells[208],cells[175]);
  cells[165]->set_neighbors(cells[183],cells[142],cells[93],cells[135]);
  cells[166]->set_neighbors(cells[38],cells[113],cells[24],cells[171]);
  cells[167]->set_neighbors(cells[68],cells[155],cells[184],cells[191]);
  cells[168]->set_neighbors(cells[33],cells[211],cells[123],cells[78]);
  cells[169]->set_neighbors(cells[156],cells[202],cells[73],cells[13]);
  cells[170]->set_neighbors(cells[141],cells[119],cells[136],cells[104]);
  cells[171]->set_neighbors(cells[180],cells[166],cells[152],cells[184]);
  cells[172]->set_neighbors(cells[206],cells[205],cells[24],cells[113]);
  cells[173]->set_neighbors(cells[12],cells[91],cells[204],cells[186]);
  cells[174]->set_neighbors(cells[196],cells[75],cells[199],cells[209]);
  cells[175]->set_neighbors(cells[164],cells[209],cells[151],cells[114]);
  cells[176]->set_neighbors(cells[119],cells[189],cells[94],cells[200]);
  cells[177]->set_neighbors(cells[66],cells[136],cells[215],cells[198]);
  cells[178]->set_neighbors(cells[102],cells[203],cells[16],cells[179]);
  cells[179]->set_neighbors(cells[110],cells[118],cells[213],cells[178]);
  cells[180]->set_neighbors(cells[10],cells[61],cells[62],cells[171]);
  cells[181]->set_neighbors(cells[63],cells[214],cells[186],cells[148]);
  cells[182]->set_neighbors(cells[56],cells[143],cells[102],cells[214]);
  cells[183]->set_neighbors(cells[206],cells[165],cells[187],cells[205]);
  cells[184]->set_neighbors(cells[86],cells[38],cells[171],cells[167]);
  cells[185]->set_neighbors(cells[148],cells[204],cells[61],cells[24]);
  cells[186]->set_neighbors(cells[181],cells[110],cells[149],cells[173]);
  cells[187]->set_neighbors(cells[198],cells[93],cells[58],cells[183]);
  cells[188]->set_neighbors(cells[148],cells[199],cells[24],cells[196]);
  cells[189]->set_neighbors(cells[107],cells[158],cells[157],cells[176]);
  cells[190]->set_neighbors(cells[194],cells[155],cells[191],cells[32]);
  cells[191]->set_neighbors(cells[193],cells[167],cells[141],cells[190]);
  cells[192]->set_neighbors(cells[194],cells[32],cells[151],cells[13]);
  cells[193]->set_neighbors(cells[77],cells[191],cells[143],cells[75]);
  cells[194]->set_neighbors(cells[78],cells[190],cells[129],cells[192]);
  cells[195]->set_neighbors(cells[79],cells[118],cells[209],cells[114]);
  cells[196]->set_neighbors(cells[19],cells[174],cells[188],cells[39]);
  cells[197]->set_neighbors(cells[112],cells[114],cells[163],cells[213]);
  cells[198]->set_neighbors(cells[177],cells[201],cells[126],cells[187]);
  cells[199]->set_neighbors(cells[188],cells[66],cells[174],cells[215]);
  cells[200]->set_neighbors(cells[201],cells[122],cells[176],cells[109]);
  cells[201]->set_neighbors(cells[136],cells[120],cells[200],cells[198]);
  cells[202]->set_neighbors(cells[153],cells[157],cells[169],cells[212]);
  cells[203]->set_neighbors(cells[178],cells[62],cells[210],cells[94]);
  cells[204]->set_neighbors(cells[173],cells[153],cells[211],cells[185]);
  cells[205]->set_neighbors(cells[172],cells[183],cells[153],cells[157]);
  cells[206]->set_neighbors(cells[25],cells[183],cells[66],cells[172]);
  cells[207]->set_neighbors(cells[208],cells[101],cells[104],cells[136]);
  cells[208]->set_neighbors(cells[164],cells[207],cells[67],cells[151]);
  cells[209]->set_neighbors(cells[174],cells[129],cells[175],cells[195]);
  cells[210]->set_neighbors(cells[78],cells[203],cells[211],cells[212]);
  cells[211]->set_neighbors(cells[61],cells[204],cells[168],cells[210]);
  cells[212]->set_neighbors(cells[210],cells[94],cells[202],cells[13]);
  cells[213]->set_neighbors(cells[126],cells[179],cells[197],cells[109]);
  cells[214]->set_neighbors(cells[182],cells[215],cells[110],cells[181]);
  cells[215]->set_neighbors(cells[199],cells[177],cells[143],cells[214]);

  set_offsets(cells[0],0,0,0,0);
  set_offsets(cells[1],0,1,5,5);
  set_offsets(cells[2],4,0,4,4);
  set_offsets(cells[3],0,0,0,0);
  set_offsets(cells[4],0,0,0,0);
  set_offsets(cells[5],0,0,0,0);
  set_offsets(cells[6],2,0,4,0);
  set_offsets(cells[7],0,0,0,0);
  set_offsets(cells[8],2,2,0,0);
  set_offsets(cells[9],4,0,4,4);
  set_offsets(cells[10],0,0,0,0);
  set_offsets(cells[11],0,0,0,0);
  set_offsets(cells[12],0,1,0,1);
  set_offsets(cells[13],0,0,0,0);
  set_offsets(cells[14],6,2,0,4);
  set_offsets(cells[15],0,0,0,0);
  set_offsets(cells[16],0,1,1,1);
  set_offsets(cells[17],0,0,4,0);
  set_offsets(cells[18],0,0,0,2);
  set_offsets(cells[19],4,2,0,6);
  set_offsets(cells[20],0,0,0,0);
  set_offsets(cells[21],0,0,0,0);
  set_offsets(cells[22],0,0,0,0);
  set_offsets(cells[23],0,0,0,0);
  set_offsets(cells[24],0,3,2,2);
  set_offsets(cells[25],2,0,4,6);
  set_offsets(cells[26],2,0,0,4);
  set_offsets(cells[27],0,0,0,0);
  set_offsets(cells[28],2,0,0,2);
  set_offsets(cells[29],2,2,0,2);
  set_offsets(cells[30],0,0,0,0);
  set_offsets(cells[31],0,2,2,6);
  set_offsets(cells[32],0,0,0,0);
  set_offsets(cells[33],0,0,0,0);
  set_offsets(cells[34],0,0,0,0);
  set_offsets(cells[35],4,0,0,0);
  set_offsets(cells[36],0,0,0,2);
  set_offsets(cells[37],0,0,0,0);
  set_offsets(cells[38],0,1,0,3);
  set_offsets(cells[39],0,1,5,3);
  set_offsets(cells[40],0,0,4,0);
  set_offsets(cells[41],0,0,0,0);
  set_offsets(cells[42],0,0,0,0);
  set_offsets(cells[43],2,2,0,2);
  set_offsets(cells[44],0,0,0,0);
  set_offsets(cells[45],0,1,0,0);
  set_offsets(cells[46],0,0,0,0);
  set_offsets(cells[47],4,6,0,4);
  set_offsets(cells[48],0,0,0,0);
  set_offsets(cells[49],4,0,4,6);
  set_offsets(cells[50],0,0,0,0);
  set_offsets(cells[51],0,0,4,0);
  set_offsets(cells[52],4,0,4,0);
  set_offsets(cells[53],0,2,2,2);
  set_offsets(cells[54],0,0,4,0);
  set_offsets(cells[55],0,0,0,0);
  set_offsets(cells[56],0,0,0,0);
  set_offsets(cells[57],0,2,4,6);
  set_offsets(cells[58],0,0,0,4);
  set_offsets(cells[59],0,0,0,0);
  set_offsets(cells[60],0,0,0,0);
  set_offsets(cells[61],0,1,1,1);
  set_offsets(cells[62],0,0,1,1);
  set_offsets(cells[63],4,0,0,4);
  set_offsets(cells[64],0,0,0,0);
  set_offsets(cells[65],0,0,0,0);
  set_offsets(cells[66],4,2,6,0);
  set_offsets(cells[67],2,0,0,0);
  set_offsets(cells[68],0,2,0,0);
  set_offsets(cells[69],4,0,0,4);
  set_offsets(cells[70],0,0,0,0);
  set_offsets(cells[71],0,2,2,2);
  set_offsets(cells[72],0,0,0,0);
  set_offsets(cells[73],0,0,0,0);
  set_offsets(cells[74],0,0,0,0);
  set_offsets(cells[75],0,3,1,1);
  set_offsets(cells[76],4,0,4,4);
  set_offsets(cells[77],0,0,2,2);
  set_offsets(cells[78],0,0,1,1);
  set_offsets(cells[79],0,1,5,0);
  set_offsets(cells[80],0,2,2,2);
  set_offsets(cells[81],0,0,0,0);
  set_offsets(cells[82],0,0,0,0);
  set_offsets(cells[83],4,2,6,6);
  set_offsets(cells[84],2,0,2,2);
  set_offsets(cells[85],0,2,0,0);
  set_offsets(cells[86],0,2,0,2);
  set_offsets(cells[87],0,2,2,0);
  set_offsets(cells[88],4,0,4,0);
  set_offsets(cells[89],0,0,4,0);
  set_offsets(cells[90],0,0,4,0);
  set_offsets(cells[91],0,0,0,0);
  set_offsets(cells[92],4,0,0,0);
  set_offsets(cells[93],0,0,4,4);
  set_offsets(cells[94],0,0,0,0);
  set_offsets(cells[95],0,0,0,0);
  set_offsets(cells[96],0,0,0,0);
  set_offsets(cells[97],0,0,4,4);
  set_offsets(cells[98],4,0,4,4);
  set_offsets(cells[99],0,0,0,0);
  set_offsets(cells[100],2,0,0,0);
  set_offsets(cells[101],2,2,0,0);
  set_offsets(cells[102],0,1,1,1);
  set_offsets(cells[103],4,0,4,0);
  set_offsets(cells[104],2,0,0,0);
  set_offsets(cells[105],4,0,4,4);
  set_offsets(cells[106],0,1,1,1);
  set_offsets(cells[107],2,0,2,2);
  set_offsets(cells[108],0,2,0,0);
  set_offsets(cells[109],0,0,0,0);
  set_offsets(cells[110],4,0,5,0);
  set_offsets(cells[111],2,0,0,0);
  set_offsets(cells[112],4,0,4,0);
  set_offsets(cells[113],2,2,0,0);
  set_offsets(cells[114],4,4,0,0);
  set_offsets(cells[115],4,0,4,4);
  set_offsets(cells[116],6,2,4,6);
  set_offsets(cells[117],4,0,4,4);
  set_offsets(cells[118],4,0,5,5);
  set_offsets(cells[119],2,2,0,2);
  set_offsets(cells[120],0,0,0,0);
  set_offsets(cells[121],4,2,0,6);
  set_offsets(cells[122],0,0,0,0);
  set_offsets(cells[123],0,1,1,1);
  set_offsets(cells[124],0,0,0,0);
  set_offsets(cells[125],0,0,0,0);
  set_offsets(cells[126],4,4,0,0);
  set_offsets(cells[127],0,0,0,0);
  set_offsets(cells[128],0,0,0,0);
  set_offsets(cells[129],0,0,1,1);
  set_offsets(cells[130],2,0,0,0);
  set_offsets(cells[131],2,0,0,0);
  set_offsets(cells[132],4,0,0,0);
  set_offsets(cells[133],4,0,4,0);
  set_offsets(cells[134],4,0,4,4);
  set_offsets(cells[135],0,0,0,0);
  set_offsets(cells[136],2,0,2,2);
  set_offsets(cells[137],0,0,0,0);
  set_offsets(cells[138],0,0,0,0);
  set_offsets(cells[139],0,0,4,2);
  set_offsets(cells[140],2,2,0,0);
  set_offsets(cells[141],2,0,0,3);
  set_offsets(cells[142],2,2,0,6);
  set_offsets(cells[143],0,2,3,3);
  set_offsets(cells[144],0,0,0,0);
  set_offsets(cells[145],0,0,0,0);
  set_offsets(cells[146],0,0,0,0);
  set_offsets(cells[147],0,0,0,0);
  set_offsets(cells[148],0,1,5,1);
  set_offsets(cells[149],0,1,5,1);
  set_offsets(cells[150],2,0,0,2);
  set_offsets(cells[151],0,0,0,0);
  set_offsets(cells[152],2,2,0,3);
  set_offsets(cells[153],0,0,0,0);
  set_offsets(cells[154],0,1,0,0);
  set_offsets(cells[155],0,0,1,1);
  set_offsets(cells[156],0,0,0,0);
  set_offsets(cells[157],0,0,0,0);
  set_offsets(cells[158],0,0,0,0);
  set_offsets(cells[159],2,2,0,2);
  set_offsets(cells[160],2,0,0,2);
  set_offsets(cells[161],2,0,2,2);
  set_offsets(cells[162],0,0,0,0);
  set_offsets(cells[163],0,0,0,0);
  set_offsets(cells[164],4,4,0,6);
  set_offsets(cells[165],0,0,0,4);
  set_offsets(cells[166],2,3,0,0);
  set_offsets(cells[167],0,3,1,1);
  set_offsets(cells[168],0,1,1,1);
  set_offsets(cells[169],0,0,0,0);
  set_offsets(cells[170],2,0,0,2);
  set_offsets(cells[171],0,3,3,2);
  set_offsets(cells[172],2,0,2,2);
  set_offsets(cells[173],0,1,0,0);
  set_offsets(cells[174],4,0,5,7);
  set_offsets(cells[175],4,4,0,4);
  set_offsets(cells[176],0,0,0,0);
  set_offsets(cells[177],6,2,6,4);
  set_offsets(cells[178],0,1,0,1);
  set_offsets(cells[179],4,4,5,0);
  set_offsets(cells[180],0,1,1,1);
  set_offsets(cells[181],0,1,5,5);
  set_offsets(cells[182],0,1,1,1);
  set_offsets(cells[183],0,0,0,4);
  set_offsets(cells[184],0,3,1,3);
  set_offsets(cells[185],0,1,0,1);
  set_offsets(cells[186],0,1,0,5);
  set_offsets(cells[187],0,0,4,4);
  set_offsets(cells[188],0,3,7,2);
  set_offsets(cells[189],0,0,0,0);
  set_offsets(cells[190],0,0,0,1);
  set_offsets(cells[191],0,0,1,3);
  set_offsets(cells[192],0,0,0,0);
  set_offsets(cells[193],0,3,1,3);
  set_offsets(cells[194],0,0,0,1);
  set_offsets(cells[195],4,0,0,5);
  set_offsets(cells[196],0,3,5,7);
  set_offsets(cells[197],4,4,0,4);
  set_offsets(cells[198],4,0,4,4);
  set_offsets(cells[199],4,7,2,0);
  set_offsets(cells[200],0,0,0,0);
  set_offsets(cells[201],0,0,0,0);
  set_offsets(cells[202],0,0,0,0);
  set_offsets(cells[203],0,0,0,1);
  set_offsets(cells[204],0,1,0,0);
  set_offsets(cells[205],0,0,0,0);
  set_offsets(cells[206],2,0,2,6);
  set_offsets(cells[207],2,0,2,0);
  set_offsets(cells[208],0,0,0,2);
  set_offsets(cells[209],4,0,5,4);
  set_offsets(cells[210],0,0,0,1);
  set_offsets(cells[211],0,1,0,1);
  set_offsets(cells[212],0,0,0,0);
  set_offsets(cells[213],4,4,4,0);
  set_offsets(cells[214],0,5,5,4);
  set_offsets(cells[215],6,7,2,4);

  vertices[0]->set_cell(cells[2]);
  vertices[1]->set_cell(cells[10]);
  vertices[2]->set_cell(cells[6]);
  vertices[3]->set_cell(cells[0]);
  vertices[4]->set_cell(cells[0]);
  vertices[5]->set_cell(cells[11]);
  vertices[6]->set_cell(cells[1]);
  vertices[7]->set_cell(cells[4]);
  vertices[8]->set_cell(cells[1]);
  vertices[9]->set_cell(cells[0]);
  vertices[10]->set_cell(cells[3]);
  vertices[11]->set_cell(cells[2]);
  vertices[12]->set_cell(cells[0]);
  vertices[13]->set_cell(cells[3]);
  vertices[14]->set_cell(cells[9]);
  vertices[15]->set_cell(cells[4]);
  vertices[16]->set_cell(cells[8]);
  vertices[17]->set_cell(cells[6]);
  vertices[18]->set_cell(cells[13]);
  vertices[19]->set_cell(cells[3]);
  vertices[20]->set_cell(cells[40]);
  vertices[21]->set_cell(cells[13]);
  vertices[22]->set_cell(cells[8]);
  vertices[23]->set_cell(cells[14]);
  vertices[24]->set_cell(cells[8]);
  vertices[25]->set_cell(cells[8]);
  vertices[26]->set_cell(cells[14]);
  vertices[27]->set_cell(cells[12]);
  vertices[28]->set_cell(cells[1]);
  vertices[29]->set_cell(cells[13]);
  vertices[30]->set_cell(cells[15]);
  vertices[31]->set_cell(cells[18]);
  vertices[32]->set_cell(cells[32]);
  vertices[33]->set_cell(cells[24]);
  vertices[34]->set_cell(cells[24]);
  vertices[35]->set_cell(cells[62]);

  _tds.set_dimension(3);
  _cover = make_array(1,1,1);

  std::vector<Vertex_handle> ret_vector(36);
  for (int i=0; i<36; i++) {
        ret_vector[i] = vertices[i];
  }

  return ret_vector;
}

#endif // CGAL_INCLUDE_FROM_PERIODIC_3_TRIANGULATION_3_H
