/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.nurbs;

import jogamp.opengl.glu.nurbs.CArrayOfBreakpts;
import jogamp.opengl.glu.nurbs.CArrayOfFloats;
import jogamp.opengl.glu.nurbs.CArrayOfQuiltspecs;
import jogamp.opengl.glu.nurbs.Knotspec;
import jogamp.opengl.glu.nurbs.Knotvector;
import jogamp.opengl.glu.nurbs.Quilt;

public class Splinespec {
    private final int dim;
    private Knotspec kspec;
    private CArrayOfFloats outcpts;

    public Splinespec(int n) {
        this.dim = n;
    }

    public void kspecinit(Knotvector knotvector) {
        this.kspec = new Knotspec();
        this.kspec.inkbegin = new CArrayOfFloats(knotvector.knotlist, 0);
        this.kspec.inkend = new CArrayOfFloats(knotvector.knotlist, knotvector.knotcount);
        this.kspec.prestride = knotvector.stride;
        this.kspec.order = knotvector.order;
        this.kspec.next = null;
    }

    public void kspecinit(Knotvector knotvector, Knotvector knotvector2) {
        this.kspec = new Knotspec();
        Knotspec knotspec = new Knotspec();
        this.kspec.inkbegin = new CArrayOfFloats(knotvector.knotlist, 0);
        this.kspec.inkend = new CArrayOfFloats(knotvector.knotlist, knotvector.knotcount);
        this.kspec.prestride = knotvector.stride;
        this.kspec.order = knotvector.order;
        this.kspec.next = knotspec;
        knotspec.inkbegin = new CArrayOfFloats(knotvector2.knotlist, 0);
        knotspec.inkend = new CArrayOfFloats(knotvector2.knotlist, knotvector2.knotcount);
        knotspec.prestride = knotvector2.stride;
        knotspec.order = knotvector2.order;
        knotspec.next = null;
    }

    public void select() {
        Knotspec knotspec = this.kspec;
        while (knotspec != null) {
            knotspec.preselect();
            knotspec.select();
            knotspec = knotspec.next;
        }
    }

    public void layout(int n) {
        int n2 = n;
        Knotspec knotspec = this.kspec;
        while (knotspec != null) {
            knotspec.poststride = n2;
            n2 *= (knotspec.bend.getPointer() - knotspec.bbegin.getPointer()) * knotspec.order + knotspec.postoffset;
            knotspec.preoffset *= knotspec.prestride;
            knotspec.prewidth *= knotspec.poststride;
            knotspec.postwidth *= knotspec.poststride;
            knotspec.postoffset *= knotspec.poststride;
            knotspec.ncoords = n;
            knotspec = knotspec.next;
        }
        this.outcpts = new CArrayOfFloats(new float[n2]);
    }

    public void setupquilt(Quilt quilt) {
        CArrayOfQuiltspecs cArrayOfQuiltspecs = new CArrayOfQuiltspecs(quilt.qspec);
        quilt.eqspec = new CArrayOfQuiltspecs(cArrayOfQuiltspecs.getArray(), this.dim);
        Knotspec knotspec = this.kspec;
        while (knotspec != null) {
            cArrayOfQuiltspecs.get().stride = knotspec.poststride;
            cArrayOfQuiltspecs.get().width = knotspec.bend.getPointer() - knotspec.bbegin.getPointer();
            cArrayOfQuiltspecs.get().order = knotspec.order;
            cArrayOfQuiltspecs.get().offset = knotspec.postoffset;
            cArrayOfQuiltspecs.get().index = 0;
            cArrayOfQuiltspecs.get().bdry[0] = knotspec.kleft.getPointer() == knotspec.kfirst.getPointer() ? 1 : 0;
            cArrayOfQuiltspecs.get().bdry[1] = knotspec.kright.getPointer() == knotspec.klast.getPointer() ? 1 : 0;
            cArrayOfQuiltspecs.get().breakpoints = new float[cArrayOfQuiltspecs.get().width + 1];
            CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(cArrayOfQuiltspecs.get().breakpoints, 0);
            CArrayOfBreakpts cArrayOfBreakpts = new CArrayOfBreakpts(knotspec.bbegin);
            while (cArrayOfBreakpts.getPointer() <= knotspec.bend.getPointer()) {
                cArrayOfFloats.set(cArrayOfBreakpts.get().value);
                cArrayOfFloats.pp();
                cArrayOfBreakpts.pp();
            }
            knotspec = knotspec.next;
            if (knotspec == null) continue;
            cArrayOfQuiltspecs.pp();
        }
        quilt.cpts = new CArrayOfFloats(this.outcpts);
        quilt.next = null;
    }

    public void copy(CArrayOfFloats cArrayOfFloats) {
        this.kspec.copy(cArrayOfFloats, this.outcpts);
    }

    public void transform() {
        this.outcpts.setPointer(0);
        Knotspec knotspec = this.kspec;
        while (knotspec != null) {
            knotspec.istransformed = false;
            knotspec = knotspec.next;
        }
        knotspec = this.kspec;
        while (knotspec != null) {
            Knotspec knotspec2 = this.kspec;
            while (knotspec2 != null) {
                knotspec2.kspectotrans = knotspec;
                knotspec2 = knotspec2.next;
            }
            this.kspec.transform(this.outcpts);
            knotspec.istransformed = true;
            knotspec = knotspec.next;
        }
    }
}

