/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.util.Message;

public class StatusManager {
    private List status = new ArrayList();
    private String defaultStatus;
    private Map statusPriorityMap;
    private Map statusIntegrationMap;
    private String deliveryStatusListString;

    public static StatusManager newDefaultInstance() {
        return new StatusManager(new Status[]{new Status("release", false), new Status("milestone", false), new Status("integration", true)}, "integration");
    }

    public static StatusManager getCurrent() {
        return IvyContext.getContext().getSettings().getStatusManager();
    }

    public StatusManager(Status[] status, String defaultStatus) {
        this.status.addAll(Arrays.asList(status));
        this.defaultStatus = defaultStatus;
        this.computeMaps();
    }

    public StatusManager() {
    }

    public void addStatus(Status status) {
        this.status.add(status);
    }

    public void setDefaultStatus(String defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public List getStatuses() {
        return this.status;
    }

    private void computeMaps() {
        if (this.status.isEmpty()) {
            throw new IllegalStateException("badly configured statuses: no status found");
        }
        this.statusPriorityMap = new HashMap();
        Iterator iter = this.status.listIterator();
        while (iter.hasNext()) {
            Status status = (Status)iter.next();
            this.statusPriorityMap.put(status.getName(), new Integer(iter.previousIndex()));
        }
        this.statusIntegrationMap = new HashMap();
        for (Status status : this.status) {
            this.statusIntegrationMap.put(status.getName(), status.isIntegration());
        }
    }

    public boolean isStatus(String status) {
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        return this.statusPriorityMap.containsKey(status);
    }

    public int getPriority(String status) {
        Integer priority;
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        if ((priority = (Integer)this.statusPriorityMap.get(status)) == null) {
            Message.debug("unknown status " + status + ": assuming lowest priority");
            return Integer.MAX_VALUE;
        }
        return priority;
    }

    public boolean isIntegration(String status) {
        Boolean isIntegration;
        if (this.statusIntegrationMap == null) {
            this.computeMaps();
        }
        if ((isIntegration = (Boolean)this.statusIntegrationMap.get(status)) == null) {
            Message.debug("unknown status " + status + ": assuming integration");
            return true;
        }
        return isIntegration;
    }

    public String getDeliveryStatusListString() {
        if (this.deliveryStatusListString == null) {
            StringBuffer ret = new StringBuffer();
            for (Status status : this.status) {
                if (status.isIntegration()) continue;
                ret.append(status.getName()).append(",");
            }
            if (ret.length() > 0) {
                ret.deleteCharAt(ret.length() - 1);
            }
            this.deliveryStatusListString = ret.toString();
        }
        return this.deliveryStatusListString;
    }

    public String getDefaultStatus() {
        if (this.defaultStatus == null) {
            if (this.status.isEmpty()) {
                throw new IllegalStateException("badly configured statuses: no status found");
            }
            this.defaultStatus = ((Status)this.status.get(this.status.size() - 1)).getName();
        }
        return this.defaultStatus;
    }
}

