/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.PainlessScript;
import org.elasticsearch.painless.ScriptInterface;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.antlr.Walker;
import org.elasticsearch.painless.node.SSource;
import org.objectweb.asm.util.Printer;

final class Compiler {
    static final int MAXIMUM_SOURCE_LENGTH = 16384;
    private static final CodeSource CODESOURCE;

    static <T> T compile(Loader loader, Class<T> iface, String name, String source, CompilerSettings settings) {
        if (source.length() > 16384) {
            throw new IllegalArgumentException("Scripts may be no longer than 16384 characters.  The passed in script is " + source.length() + " characters.  Consider using a plugin if a script longer than this length is a requirement.");
        }
        Definition definition = Definition.BUILTINS;
        ScriptInterface scriptInterface = new ScriptInterface(definition, iface);
        SSource root = Walker.buildPainlessTree(scriptInterface, name, source, settings, definition, null);
        root.analyze(definition);
        root.write();
        try {
            Class<? extends PainlessScript> clazz = loader.defineScript(WriterConstants.CLASS_NAME, root.getBytes());
            clazz.getField("$DEFINITION").set(null, definition);
            Constructor<? extends PainlessScript> constructor = clazz.getConstructor(String.class, String.class, BitSet.class);
            return iface.cast(constructor.newInstance(name, source, root.getStatements()));
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the script [" + name + "].", exception);
        }
    }

    static byte[] compile(Class<?> iface, String name, String source, CompilerSettings settings, Printer debugStream) {
        if (source.length() > 16384) {
            throw new IllegalArgumentException("Scripts may be no longer than 16384 characters.  The passed in script is " + source.length() + " characters.  Consider using a plugin if a script longer than this length is a requirement.");
        }
        Definition definition = Definition.BUILTINS;
        ScriptInterface scriptInterface = new ScriptInterface(definition, iface);
        SSource root = Walker.buildPainlessTree(scriptInterface, name, source, settings, definition, debugStream);
        root.analyze(definition);
        root.write();
        return root.getBytes();
    }

    private Compiler() {
    }

    static {
        try {
            CODESOURCE = new CodeSource(new URL("file:/untrusted"), (Certificate[])null);
        }
        catch (MalformedURLException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    static final class Loader
    extends SecureClassLoader {
        private final AtomicInteger lambdaCounter = new AtomicInteger(0);

        Loader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends PainlessScript> defineScript(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE).asSubclass(PainlessScript.class);
        }

        Class<?> defineLambda(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE);
        }

        int newLambdaIdentifier() {
            return this.lambdaCounter.getAndIncrement();
        }
    }
}

