/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class SequentialReader {
    private boolean _isMotorolaByteOrder = true;

    protected abstract byte getByte() throws IOException;

    @NotNull
    public abstract byte[] getBytes(int var1) throws IOException;

    public abstract void skip(long var1) throws IOException;

    public abstract boolean trySkip(long var1) throws IOException;

    public void setMotorolaByteOrder(boolean bl) {
        this._isMotorolaByteOrder = bl;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public short getUInt8() throws IOException {
        return (short)(this.getByte() & 0xFF);
    }

    public byte getInt8() throws IOException {
        return this.getByte();
    }

    public int getUInt16() throws IOException {
        if (this._isMotorolaByteOrder) {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }
        return this.getByte() & 0xFF | this.getByte() << 8 & 0xFF00;
    }

    public short getInt16() throws IOException {
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.getByte() << 8 & 0xFFFFFF00 | (short)this.getByte() & 0xFF);
        }
        return (short)((short)this.getByte() & 0xFF | (short)this.getByte() << 8 & 0xFFFFFF00);
    }

    public long getUInt32() throws IOException {
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte() << 24 & 0xFF000000L | (long)this.getByte() << 16 & 0xFF0000L | (long)this.getByte() << 8 & 0xFF00L | (long)this.getByte() & 0xFFL;
        }
        return (long)this.getByte() & 0xFFL | (long)this.getByte() << 8 & 0xFF00L | (long)this.getByte() << 16 & 0xFF0000L | (long)this.getByte() << 24 & 0xFF000000L;
    }

    public int getInt32() throws IOException {
        if (this._isMotorolaByteOrder) {
            return this.getByte() << 24 & 0xFF000000 | this.getByte() << 16 & 0xFF0000 | this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }
        return this.getByte() & 0xFF | this.getByte() << 8 & 0xFF00 | this.getByte() << 16 & 0xFF0000 | this.getByte() << 24 & 0xFF000000;
    }

    public long getInt64() throws IOException {
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte() << 56 & 0xFF00000000000000L | (long)this.getByte() << 48 & 0xFF000000000000L | (long)this.getByte() << 40 & 0xFF0000000000L | (long)this.getByte() << 32 & 0xFF00000000L | (long)this.getByte() << 24 & 0xFF000000L | (long)this.getByte() << 16 & 0xFF0000L | (long)this.getByte() << 8 & 0xFF00L | (long)this.getByte() & 0xFFL;
        }
        return (long)this.getByte() & 0xFFL | (long)this.getByte() << 8 & 0xFF00L | (long)this.getByte() << 16 & 0xFF0000L | (long)this.getByte() << 24 & 0xFF000000L | (long)this.getByte() << 32 & 0xFF00000000L | (long)this.getByte() << 40 & 0xFF0000000000L | (long)this.getByte() << 48 & 0xFF000000000000L | (long)this.getByte() << 56 & 0xFF00000000000000L;
    }

    public float getS15Fixed16() throws IOException {
        if (this._isMotorolaByteOrder) {
            float f = (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
            int n = (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
            return (float)((double)f + (double)n / 65536.0);
        }
        int n = this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8;
        float f = this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8;
        return (float)((double)f + (double)n / 65536.0);
    }

    public float getFloat32() throws IOException {
        return Float.intBitsToFloat(this.getInt32());
    }

    public double getDouble64() throws IOException {
        return Double.longBitsToDouble(this.getInt64());
    }

    @NotNull
    public String getString(int n) throws IOException {
        return new String(this.getBytes(n));
    }

    @NotNull
    public String getString(int n, String string) throws IOException {
        byte[] byArray = this.getBytes(n);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    @NotNull
    public String getNullTerminatedString(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < byArray.length && (byArray[n2] = this.getByte()) != 0; ++n2) {
        }
        return new String(byArray, 0, n2);
    }
}

