/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryKeepAliveRunner
implements Runnable {
    private static final Log log = LogFactory.getLog(RegistryKeepAliveRunner.class);
    private String namingURL;
    private int registryPort;
    private ICacheEventLogger cacheEventLogger;

    public RegistryKeepAliveRunner(String string, int n, String string2) {
        this.namingURL = RemoteUtils.getNamingURL(string, n, string2);
        this.registryPort = n;
    }

    @Override
    public void run() {
        this.checkAndRestoreIfNeeded();
    }

    protected void checkAndRestoreIfNeeded() {
        if (log.isDebugEnabled()) {
            log.debug("looking up server " + this.namingURL);
        }
        try {
            Remote remote = Naming.lookup(this.namingURL);
            String string = "RMI registry looks fine.  Found [" + remote + "] in registry [" + this.namingURL + "]";
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "Naming.lookup", string);
            }
            if (log.isDebugEnabled()) {
                log.debug(string);
            }
        }
        catch (Exception exception) {
            String string = "Problem finding server at [" + this.namingURL + "].  Will attempt to start registry and rebind.";
            log.error(string, exception);
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "Naming.lookup", string + ":" + exception.getMessage());
            }
            this.createAndRegister(this.namingURL);
        }
    }

    protected void createAndRegister(String string) {
        this.createReqistry(string);
        this.registerServer(string);
    }

    protected void createReqistry(String string) {
        Registry registry = RemoteUtils.createRegistry(this.registryPort);
        if (this.cacheEventLogger != null) {
            if (registry != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", "Successfully created registry [" + string + "].");
            } else {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", "Could not start registry [" + string + "].");
            }
        }
    }

    protected void registerServer(String string) {
        block4: {
            try {
                RemoteCacheServerFactory.registerServer(string, RemoteCacheServerFactory.getRemoteCacheServer());
                String string2 = "Successfully rebound server to registry [" + string + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", string2);
                }
                if (log.isInfoEnabled()) {
                    log.info(string2);
                }
            }
            catch (RemoteException remoteException) {
                String string3 = "Could not rebind server to registry [" + string + "].";
                log.error(string3, remoteException);
                if (this.cacheEventLogger == null) break block4;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", string3 + ":" + remoteException.getMessage());
            }
        }
    }

    public void setCacheEventLogger(ICacheEventLogger iCacheEventLogger) {
        this.cacheEventLogger = iCacheEventLogger;
    }
}

