/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DoubleLinkedList<T extends DoubleLinkedListNode> {
    private int size = 0;
    private static final Log log = LogFactory.getLog(DoubleLinkedList.class);
    private T first;
    private T last;

    public synchronized void addLast(T t) {
        if (this.first == null) {
            this.first = t;
        } else {
            ((DoubleLinkedListNode)this.last).next = t;
            ((DoubleLinkedListNode)t).prev = this.last;
        }
        this.last = t;
        ++this.size;
    }

    public synchronized void addFirst(T t) {
        if (this.last == null) {
            this.last = t;
        } else {
            ((DoubleLinkedListNode)this.first).prev = t;
            ((DoubleLinkedListNode)t).next = this.first;
        }
        this.first = t;
        ++this.size;
    }

    public synchronized T getLast() {
        if (log.isDebugEnabled()) {
            log.debug("returning last node");
        }
        return this.last;
    }

    public synchronized T getFirst() {
        if (log.isDebugEnabled()) {
            log.debug("returning first node");
        }
        return this.first;
    }

    public synchronized void makeFirst(T t) {
        if (((DoubleLinkedListNode)t).prev == null) {
            return;
        }
        ((DoubleLinkedListNode)t).prev.next = ((DoubleLinkedListNode)t).next;
        if (((DoubleLinkedListNode)t).next == null) {
            this.last = ((DoubleLinkedListNode)t).prev;
            ((DoubleLinkedListNode)this.last).next = null;
        } else {
            ((DoubleLinkedListNode)t).next.prev = ((DoubleLinkedListNode)t).prev;
        }
        ((DoubleLinkedListNode)this.first).prev = t;
        ((DoubleLinkedListNode)t).next = this.first;
        ((DoubleLinkedListNode)t).prev = null;
        this.first = t;
    }

    public synchronized void makeLast(T t) {
        if (((DoubleLinkedListNode)t).next == null) {
            return;
        }
        if (((DoubleLinkedListNode)t).prev != null) {
            ((DoubleLinkedListNode)t).prev.next = ((DoubleLinkedListNode)t).next;
        } else {
            this.first = this.last;
        }
        if (this.last != null) {
            ((DoubleLinkedListNode)this.last).next = t;
        }
        ((DoubleLinkedListNode)t).prev = this.last;
        ((DoubleLinkedListNode)t).next = null;
        this.last = t;
    }

    public synchronized void removeAll() {
        Object object = this.first;
        while (object != null) {
            if (((DoubleLinkedListNode)object).prev != null) {
                ((DoubleLinkedListNode)object).prev = null;
            }
            DoubleLinkedListNode doubleLinkedListNode = ((DoubleLinkedListNode)object).next;
            object = doubleLinkedListNode;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized boolean remove(T t) {
        if (log.isDebugEnabled()) {
            log.debug("removing node");
        }
        if (((DoubleLinkedListNode)t).next == null) {
            if (((DoubleLinkedListNode)t).prev == null) {
                if (t == this.first && t == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = ((DoubleLinkedListNode)t).prev;
                ((DoubleLinkedListNode)this.last).next = null;
                ((DoubleLinkedListNode)t).prev = null;
            }
        } else if (((DoubleLinkedListNode)t).prev == null) {
            this.first = ((DoubleLinkedListNode)t).next;
            ((DoubleLinkedListNode)this.first).prev = null;
            ((DoubleLinkedListNode)t).next = null;
        } else {
            ((DoubleLinkedListNode)t).prev.next = ((DoubleLinkedListNode)t).next;
            ((DoubleLinkedListNode)t).next.prev = ((DoubleLinkedListNode)t).prev;
            ((DoubleLinkedListNode)t).next = null;
            ((DoubleLinkedListNode)t).prev = null;
        }
        --this.size;
        return true;
    }

    public synchronized T removeLast() {
        if (log.isDebugEnabled()) {
            log.debug("removing last node");
        }
        T t = this.last;
        if (this.last != null) {
            this.remove(this.last);
        }
        return t;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void debugDumpEntries() {
        if (log.isDebugEnabled()) {
            log.debug("dumping Entries");
            Object object = this.first;
            while (object != null) {
                log.debug("dump Entries> payload= '" + ((DoubleLinkedListNode)object).getPayload() + "'");
                object = ((DoubleLinkedListNode)object).next;
            }
        }
    }
}

