/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private ArrayList<JsonValue> valueList;
    private final BufferPool bufferPool;

    JsonArrayBuilderImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonArrayBuilder add(JsonValue jsonValue) {
        this.validateValue(jsonValue);
        this.addValueList(jsonValue);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String string) {
        this.validateValue(string);
        this.addValueList(new JsonStringImpl(string));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal bigDecimal) {
        this.validateValue(bigDecimal);
        this.addValueList(JsonNumberImpl.getJsonNumber(bigDecimal));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger bigInteger) {
        this.validateValue(bigInteger);
        this.addValueList(JsonNumberImpl.getJsonNumber(bigInteger));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int n) {
        this.addValueList(JsonNumberImpl.getJsonNumber(n));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long l) {
        this.addValueList(JsonNumberImpl.getJsonNumber(l));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double d) {
        this.addValueList(JsonNumberImpl.getJsonNumber(d));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean bl) {
        this.addValueList(bl ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.addValueList(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder jsonObjectBuilder) {
        if (jsonObjectBuilder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList(jsonObjectBuilder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder jsonArrayBuilder) {
        if (jsonArrayBuilder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_ARRAY_BUILDER_NULL());
        }
        this.addValueList(jsonArrayBuilder.build());
        return this;
    }

    @Override
    public JsonArray build() {
        List<Object> list = this.valueList == null ? Collections.emptyList() : Collections.unmodifiableList(this.valueList);
        this.valueList = null;
        return new JsonArrayImpl(list, this.bufferPool);
    }

    private void addValueList(JsonValue jsonValue) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(jsonValue);
    }

    private void validateValue(Object object) {
        if (object == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;
        private final BufferPool bufferPool;

        JsonArrayImpl(List<JsonValue> list, BufferPool bufferPool) {
            this.valueList = list;
            this.bufferPool = bufferPool;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public JsonObject getJsonObject(int n) {
            return (JsonObject)this.valueList.get(n);
        }

        @Override
        public JsonArray getJsonArray(int n) {
            return (JsonArray)this.valueList.get(n);
        }

        @Override
        public JsonNumber getJsonNumber(int n) {
            return (JsonNumber)this.valueList.get(n);
        }

        @Override
        public JsonString getJsonString(int n) {
            return (JsonString)this.valueList.get(n);
        }

        @Override
        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        @Override
        public String getString(int n) {
            return this.getJsonString(n).getString();
        }

        @Override
        public String getString(int n, String string) {
            try {
                return this.getString(n);
            }
            catch (Exception exception) {
                return string;
            }
        }

        @Override
        public int getInt(int n) {
            return this.getJsonNumber(n).intValue();
        }

        @Override
        public int getInt(int n, int n2) {
            try {
                return this.getInt(n);
            }
            catch (Exception exception) {
                return n2;
            }
        }

        @Override
        public boolean getBoolean(int n) {
            JsonValue jsonValue = this.get(n);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(int n, boolean bl) {
            try {
                return this.getBoolean(n);
            }
            catch (Exception exception) {
                return bl;
            }
        }

        @Override
        public boolean isNull(int n) {
            return this.valueList.get(n).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int n) {
            return this.valueList.get(n);
        }

        @Override
        public String toString() {
            StringWriter stringWriter = new StringWriter();
            JsonWriterImpl jsonWriterImpl = new JsonWriterImpl(stringWriter, this.bufferPool);
            jsonWriterImpl.write(this);
            jsonWriterImpl.close();
            return stringWriter.toString();
        }
    }
}

