/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class CombineWayAction
extends JosmAction {
    private static final BooleanProperty PROP_REVERSE_WAY = new BooleanProperty("tag-correction.reverse-way", true);

    public CombineWayAction() {
        super(I18n.tr("Combine Way", new Object[0]), "combineway", I18n.tr("Combine several ways into one.", new Object[0]), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way", new Object[0])), 67, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/CombineWay"));
    }

    protected static boolean confirmChangeDirectionOfWays() {
        return new ExtendedDialog(Main.parent, I18n.tr("Change directions?", new Object[0]), I18n.tr("Reverse and Combine", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("wayflip", "cancel").setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?", new Object[0])).toggleEnable("combineway-reverse").showDialog().getValue() == 1;
    }

    protected static void warnCombiningImpossible() {
        String string = I18n.tr("Could not combine ways<br>(They could not be merged into a single string of nodes)", new Object[0]);
        new Notification(string).setIcon(1).show();
    }

    protected static Way getTargetWay(Collection<Way> collection) {
        Way way = collection.iterator().next();
        Iterator<Way> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Way way2;
            way = way2 = iterator.next();
            if (way2.isNew()) continue;
            break;
        }
        return way;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Way, Command> combineWaysWorker(Collection<Way> collection) throws UserCancelException {
        Object object;
        List<Command> list;
        List<Way> list2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        collection.remove(null);
        collection = new LinkedHashSet<Way>(collection);
        collection.removeIf(AbstractPrimitive::isIncomplete);
        if (collection.size() < 2) {
            return null;
        }
        List list3 = collection.stream().map(OsmPrimitive::getDataSet).distinct().collect(Collectors.toList());
        if (list3.size() != 1) {
            throw new IllegalArgumentException("Cannot combine ways of multiple data sets.");
        }
        NodeGraph nodeGraph = NodeGraph.createNearlyUndirectedGraphFromNodeWays(collection);
        List<Node> list4 = nodeGraph.buildSpanningPath();
        if (list4 == null) {
            CombineWayAction.warnCombiningImpossible();
            return null;
        }
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        LinkedList<Command> linkedList = new LinkedList<Command>();
        List<Way> list5 = new LinkedList<Way>();
        List<Way> list6 = new LinkedList<Way>();
        for (Way object32 : collection) {
            if (object32.getNodesCount() < 2 || list4.indexOf(object32.getNode(0)) + 1 == list4.lastIndexOf(object32.getNode(1))) {
                list6.add(object32);
                continue;
            }
            list5.add(object32);
        }
        if (list6.isEmpty()) {
            Collections.reverse(list4);
            list6 = list5;
            list5 = null;
        }
        if (list5 != null && !list5.isEmpty()) {
            if (!CombineWayAction.confirmChangeDirectionOfWays()) {
                return null;
            }
            list6 = ReverseWayTagCorrector.irreversibleWays(list6);
            if ((list5 = ReverseWayTagCorrector.irreversibleWays(list5)).size() > list6.size()) {
                Collections.reverse(list4);
                list2 = list6;
                list6 = null;
                list5 = list2;
            }
            if (!list5.isEmpty() && PROP_REVERSE_WAY.get().booleanValue()) {
                list2 = new ArrayList<Way>(collection);
                list2.removeAll(list5);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                list = new ArrayList<Command>(list5.size());
                for (Way way : list5) {
                    object = new Way(way);
                    list.add((Command)object);
                    linkedList.addAll(reverseWayTagCorrector.execute(way, (Way)object));
                }
                if (!linkedList.isEmpty()) {
                    MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Reverse Ways", new Object[0]), linkedList));
                }
                tagCollection = TagCollection.unionOfAllPrimitives(list);
                tagCollection.add(TagCollection.unionOfAllPrimitives(list2));
            }
        }
        list2 = CombineWayAction.getTargetWay(collection);
        Way way = new Way((Way)((Object)list2));
        way.setNodes(list4);
        try {
            list = CombinePrimitiveResolverDialog.launchIfNecessary(tagCollection, collection, Collections.singleton(list2));
        }
        finally {
            if (!linkedList.isEmpty()) {
                MainApplication.undoRedo.undo();
            }
        }
        LinkedList<ChangeCommand> linkedList2 = new LinkedList<ChangeCommand>();
        LinkedList<Way> linkedList3 = new LinkedList<Way>(collection);
        linkedList3.remove(list2);
        linkedList2.add(new ChangeCommand((DataSet)list3.get(0), (OsmPrimitive)((Object)list2), (OsmPrimitive)way));
        linkedList2.addAll(linkedList);
        linkedList2.addAll(list);
        linkedList2.add((ChangeCommand)((Object)new DeleteCommand((DataSet)list3.get(0), linkedList3)));
        object = new SequenceCommand(I18n.trn("Combine {0} way", "Combine {0} ways", collection.size(), collection.size()), (Collection<Command>)linkedList2);
        return new Pair<List<Way>, Object>(list2, object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Pair<Way, Command> pair;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return;
        }
        Collection<Way> collection = dataSet.getSelectedWays();
        if (collection.size() < 2) {
            new Notification(I18n.tr("Please select at least two ways to combine.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        try {
            pair = CombineWayAction.combineWaysWorker(collection);
        }
        catch (UserCancelException userCancelException) {
            Logging.trace(userCancelException);
            return;
        }
        if (pair == null) {
            return;
        }
        Way way = (Way)pair.a;
        MainApplication.undoRedo.add((Command)pair.b);
        if (way != null) {
            GuiHelper.runInEDT(() -> dataSet.setSelected(way));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Way && !osmPrimitive.isIncomplete() && ++n >= 2) break;
        }
        this.setEnabled(n >= 2);
    }
}

