/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class HelpAction
extends JosmAction {
    public HelpAction() {
        this(true);
    }

    private HelpAction(boolean bl) {
        super(I18n.tr("Help", new Object[0]), "help", null, bl ? Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003) : null, true);
        this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
    }

    public static HelpAction createWithoutShortcut() {
        return new HelpAction(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == null) {
            String string;
            if (actionEvent.getSource() instanceof Component) {
                Component component = SwingUtilities.getRoot((Component)actionEvent.getSource());
                Point point = component.getMousePosition();
                if (point != null) {
                    component = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
                    string = HelpUtil.getContextSpecificHelpTopic(component);
                } else {
                    string = null;
                }
            } else {
                Point point = Main.parent.getMousePosition();
                string = HelpUtil.getContextSpecificHelpTopic(SwingUtilities.getDeepestComponentAt(Main.parent, point.x, point.y));
            }
            HelpBrowser.setUrlForHelpTopic(Optional.ofNullable(string).orElse("/"));
        } else {
            HelpBrowser.setUrlForHelpTopic("/");
        }
    }
}

