/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class PurgeAction
extends JosmAction {
    protected transient OsmDataLayer layer;
    protected JCheckBox cbClearUndoRedo;
    protected boolean modified;
    protected transient List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge...", new Object[0]), "purge", I18n.tr("Forget objects but do not delete them on server when uploading.", new Object[0]), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge", new Object[0])), 80, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        PurgeCommand purgeCommand = this.getPurgeCommand(this.getLayerManager().getEditDataSet().getAllSelected());
        boolean bl = false;
        if (!GraphicsEnvironment.isHeadless()) {
            boolean bl2 = ConditionalOptionPaneUtil.showConfirmationDialog("purge", Main.parent, this.buildPanel(this.modified), I18n.tr("Confirm Purging", new Object[0]), 2, -1, 0);
            if (!bl2) {
                return;
            }
            bl = this.cbClearUndoRedo.isSelected();
            Main.pref.put("purge.clear_undo_redo", bl);
        }
        MainApplication.undoRedo.add(purgeCommand);
        if (bl) {
            MainApplication.undoRedo.clean();
            this.getLayerManager().getEditDataSet().clearSelectionHistory();
        }
    }

    public PurgeCommand getPurgeCommand(Collection<OsmPrimitive> collection) {
        this.layer = this.getLayerManager().getEditLayer();
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        PurgeCommand purgeCommand = PurgeCommand.build(this.layer, collection, this.toPurgeAdditionally);
        this.modified = purgeCommand.getParticipatingPrimitives().stream().anyMatch(AbstractPrimitive::isModified);
        return purgeCommand;
    }

    private JPanel buildPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.", new Object[0]) + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:", new Object[0]) + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            this.toPurgeAdditionally.sort((osmPrimitive, osmPrimitive2) -> {
                int n = osmPrimitive2.getType().compareTo(osmPrimitive.getType());
                if (n != 0) {
                    return n;
                }
                return Long.compare(osmPrimitive.getUniqueId(), osmPrimitive2.getUniqueId());
            });
            JList<OsmPrimitive> jList = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[this.toPurgeAdditionally.size()]));
            jList.setCellRenderer(new SelectionForcedOsmPrimitivRenderer());
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setPreferredSize(new Dimension(250, 300));
            jScrollPane.setMinimumSize(new Dimension(250, 300));
            jPanel.add((Component)jScrollPane, GBC.std().fill(1).weight(1.0, 1.0));
            JButton jButton = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jButton, GBC.eol().anchor(16).weight(0.0, 1.0).insets(2, 0, 0, 3));
        }
        if (bl) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>", new Object[0]), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer", new Object[0]));
        this.cbClearUndoRedo.setSelected(Main.pref.getBoolean("purge.clear_undo_redo", false));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)this.cbClearUndoRedo, GBC.eol());
        return jPanel;
    }

    @Override
    protected void updateEnabledState() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        this.setEnabled(dataSet != null && !dataSet.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    static class SelectionForcedOsmPrimitivRenderer
    extends OsmPrimitivRenderer {
        SelectionForcedOsmPrimitivRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends OsmPrimitive> jList, OsmPrimitive osmPrimitive, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, osmPrimitive, n, true, false);
        }
    }
}

