/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayNoTagCorrector;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways", new Object[0]), "wayflip", I18n.tr("Reverse the direction of all selected ways.", new Object[0]), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways", new Object[0])), 82, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/ReverseWays"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (!this.isEnabled() || dataSet == null) {
            return;
        }
        LinkedHashSet<Way> linkedHashSet = new LinkedHashSet<Way>(dataSet.getSelectedWays());
        linkedHashSet.removeIf(AbstractPrimitive::isIncomplete);
        if (linkedHashSet.isEmpty()) {
            new Notification(I18n.tr("Please select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Way way : linkedHashSet) {
            ReverseWayResult reverseWayResult;
            try {
                reverseWayResult = ReverseWayAction.reverseWay(way);
            }
            catch (UserCancelException userCancelException) {
                Logging.trace(userCancelException);
                return;
            }
            linkedList.addAll(reverseWayResult.getCommands());
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways", new Object[0]), linkedList));
    }

    public static ReverseWayResult reverseWay(Way way) throws UserCancelException {
        ReverseWayNoTagCorrector.checkAndConfirmReverseWay(way);
        Way way2 = new Way(way);
        List<Node> list = way2.getNodes();
        Collections.reverse(list);
        way2.setNodes(list);
        Collection<Command> collection = Collections.emptyList();
        if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
            collection = new ReverseWayTagCorrector().execute(way, way2);
        }
        return new ReverseWayResult(way2, collection, new ChangeCommand(way.getDataSet(), (OsmPrimitive)way, (OsmPrimitive)way2));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection.stream().anyMatch(osmPrimitive -> osmPrimitive instanceof Way && !osmPrimitive.isIncomplete()));
    }

    public static class ReverseWayResult {
        private final Way newWay;
        private final Collection<Command> tagCorrectionCommands;
        private final Command reverseCommand;

        public ReverseWayResult(Way way, Collection<Command> collection, Command command) {
            this.newWay = way;
            this.tagCorrectionCommands = collection;
            this.reverseCommand = command;
        }

        public Way getNewWay() {
            return this.newWay;
        }

        public Collection<Command> getCommands() {
            ArrayList<Command> arrayList = new ArrayList<Command>();
            arrayList.addAll(this.tagCorrectionCommands);
            arrayList.add(this.reverseCommand);
            return arrayList;
        }

        public Command getAsSequenceCommand() {
            return new SequenceCommand(I18n.tr("Reverse way", new Object[0]), this.getCommands());
        }

        public Command getReverseCommand() {
            return this.reverseCommand;
        }

        public Collection<Command> getTagCorrectionCommands() {
            return this.tagCorrectionCommands;
        }
    }
}

