/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    public SaveActionBase(String string, String string2, String string3, Shortcut shortcut) {
        super(string, string2, string3, shortcut);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSave();
    }

    public boolean doSave() {
        Layer layer = this.getLayerManager().getActiveLayer();
        if (layer != null && layer.isSavable()) {
            return this.doSave(layer);
        }
        return false;
    }

    public boolean doSave(Layer layer) {
        if (!layer.checkSaveConditions()) {
            return false;
        }
        return SaveActionBase.doInternalSave(layer, this.getFile(layer));
    }

    public static boolean doSave(Layer layer, File file, boolean bl) {
        if (bl && !layer.checkSaveConditions()) {
            return false;
        }
        return SaveActionBase.doInternalSave(layer, file);
    }

    private static boolean doInternalSave(Layer layer, File file) {
        if (file == null) {
            return false;
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            for (FileExporter fileExporter : ExtensionFileFilter.getExporters()) {
                if (!fileExporter.acceptFile(file, layer)) continue;
                fileExporter.exportData(file, layer);
                bl = true;
                bl2 = fileExporter.isCanceled();
                break;
            }
            if (!bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No Exporter found! Nothing saved.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return false;
            }
            if (bl2) {
                return false;
            }
            if (!layer.isRenamed()) {
                layer.setName(file.getName());
            }
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
            Main.parent.repaint();
        }
        catch (IOException iOException) {
            Logging.error(iOException);
            return false;
        }
        SaveActionBase.addToFileOpenHistory(file);
        return true;
    }

    protected abstract File getFile(Layer var1);

    @Override
    protected void updateEnabledState() {
        Layer layer = this.getLayerManager().getActiveLayer();
        this.setEnabled(layer != null && layer.isSavable());
    }

    public static File createAndOpenSaveFileChooser(String string, ExtensionFileFilter extensionFileFilter) {
        AbstractFileChooser abstractFileChooser = SaveActionBase.createAndOpenFileChooser(false, false, string, extensionFileFilter, 0, null);
        return SaveActionBase.checkFileAndConfirmOverWrite(abstractFileChooser, extensionFileFilter.getDefaultExtension());
    }

    public static File createAndOpenSaveFileChooser(String string, String string2) {
        AbstractFileChooser abstractFileChooser = SaveActionBase.createAndOpenFileChooser(false, false, string, string2);
        return SaveActionBase.checkFileAndConfirmOverWrite(abstractFileChooser, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static File checkFileAndConfirmOverWrite(AbstractFileChooser abstractFileChooser, String string) {
        if (abstractFileChooser == null) {
            return null;
        }
        File file = abstractFileChooser.getSelectedFile();
        FileFilter fileFilter = abstractFileChooser.getFileFilter();
        if (!fileFilter.accept(file)) {
            void var4_8;
            for (FileFilter fileFilter2 : abstractFileChooser.getChoosableFileFilters()) {
                if (!fileFilter2.accept(file)) continue;
                abstractFileChooser.setFileFilter(fileFilter2);
                return file;
            }
            String string2 = file.getPath();
            if (string != null && fileFilter.accept(new File(string2 + '.' + string))) {
                String string3 = string2 + '.' + string;
            } else if (fileFilter instanceof ExtensionFileFilter) {
                String string4 = string2 + '.' + ((ExtensionFileFilter)fileFilter).getDefaultExtension();
            }
            file = new File((String)var4_8);
            if (!abstractFileChooser.getSelectedFile().exists() && !SaveActionBase.confirmOverwrite(file)) {
                return null;
            }
        }
        return file;
    }

    public static boolean confirmOverwrite(File file) {
        if (file == null || file.exists()) {
            return new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(I18n.tr("File exists. Overwrite?", new Object[0])).setButtonIcons("save_as", "cancel").showDialog().getValue() == 1;
        }
        return true;
    }

    static void addToFileOpenHistory(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            Logging.warn(iOException);
            return;
        }
        int n = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
        Collection<String> collection = Main.pref.getCollection("file-open.history");
        LinkedList<String> linkedList = new LinkedList<String>(collection);
        linkedList.remove(string);
        linkedList.add(0, string);
        Main.pref.putCollectionBounded("file-open.history", n, linkedList);
    }
}

